/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.ibatis;

import com.ibatis.common.beans.Probe;
import com.ibatis.common.beans.ProbeFactory;
import com.ibatis.sqlmap.client.event.RowHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RollupRowHandler
implements RowHandler {
    private final String[] keyProperties;
    private final String collectionProperty;
    private final RowHandler rowHandler;
    private final int maxResults;
    private Object[] lastKeyValues;
    private List<Object> rawResults;
    private int resultCount;

    public RollupRowHandler(String[] keyProperties, String collectionProperty, RowHandler rowHandler) {
        this(keyProperties, collectionProperty, rowHandler, Integer.MAX_VALUE);
    }

    public RollupRowHandler(String[] keyProperties, String collectionProperty, RowHandler rowHandler, int maxResults) {
        if (keyProperties == null || keyProperties.length == 0) {
            throw new IllegalArgumentException("RollupRowHandler can only be used with at least one key property.");
        }
        if (collectionProperty == null) {
            throw new IllegalArgumentException("RollupRowHandler must have a collection property.");
        }
        this.keyProperties = keyProperties;
        this.collectionProperty = collectionProperty;
        this.rowHandler = rowHandler;
        this.maxResults = maxResults;
        this.rawResults = new ArrayList<Object>(100);
    }

    public void handleRow(Object valueObject) {
        Object[] currentKeyValues;
        if (this.maxResults > 0 && this.resultCount >= this.maxResults) {
            return;
        }
        Probe probe = ProbeFactory.getProbe((Object)valueObject);
        if (this.lastKeyValues == null) {
            this.lastKeyValues = this.getKeyValues(valueObject, probe);
            this.resultCount = 0;
        }
        if (!Arrays.deepEquals(this.lastKeyValues, currentKeyValues = this.getKeyValues(valueObject, probe))) {
            Object resultObject = RollupRowHandler.coalesceResults(this.rawResults, this.collectionProperty);
            if (resultObject != null) {
                this.rowHandler.handleRow(resultObject);
                ++this.resultCount;
            }
            this.rawResults.clear();
            this.lastKeyValues = currentKeyValues;
        }
        this.rawResults.add(valueObject);
    }

    public void processLastResults() {
        if (this.maxResults > 0 && this.resultCount >= this.maxResults) {
            return;
        }
        Object resultObject = RollupRowHandler.coalesceResults(this.rawResults, this.collectionProperty);
        if (resultObject != null) {
            this.rowHandler.handleRow(resultObject);
            ++this.resultCount;
            this.rawResults.clear();
        }
    }

    private static Object coalesceResults(List<Object> valueObjects, String collectionProperty) {
        Object resultObject = null;
        Probe probe = null;
        Collection collection = null;
        for (Object object : valueObjects) {
            if (collection == null) {
                resultObject = object;
                probe = ProbeFactory.getProbe((Object)resultObject);
                collection = (Collection)probe.getObject(resultObject, collectionProperty);
                continue;
            }
            Collection addedValues = (Collection)probe.getObject(object, collectionProperty);
            collection.addAll(addedValues);
        }
        return resultObject;
    }

    private Object[] getKeyValues(Object valueObject, Probe probe) {
        Object[] keyValues = new Object[this.keyProperties.length];
        for (int i = 0; i < this.keyProperties.length; ++i) {
            keyValues[i] = probe.getObject(valueObject, this.keyProperties[i]);
        }
        return keyValues;
    }
}

