/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.io.Serializable;
import java.text.FieldPosition;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.buf.DateTool;
import org.apache.tomcat.util.buf.MessageBytes;

public class ServerCookie
implements Serializable {
    private static Log log = LogFactory.getLog(ServerCookie.class);
    private MessageBytes name = MessageBytes.newInstance();
    private MessageBytes value = MessageBytes.newInstance();
    private MessageBytes comment = MessageBytes.newInstance();
    private MessageBytes domain = MessageBytes.newInstance();
    private int maxAge = -1;
    private MessageBytes path = MessageBytes.newInstance();
    private boolean secure;
    private int version = 0;
    private static final String tspecials = ",; ";
    private static final String tspecials2 = ",; \"";
    private static final String ancientDate = DateTool.formatOldCookie(new Date(10000L));
    static final int dbg = 1;

    public void recycle() {
        this.path.recycle();
        this.name.recycle();
        this.value.recycle();
        this.comment.recycle();
        this.maxAge = -1;
        this.path.recycle();
        this.domain.recycle();
        this.version = 0;
        this.secure = false;
    }

    public MessageBytes getComment() {
        return this.comment;
    }

    public MessageBytes getDomain() {
        return this.domain;
    }

    public void setMaxAge(int expiry) {
        this.maxAge = expiry;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public MessageBytes getPath() {
        return this.path;
    }

    public void setSecure(boolean flag) {
        this.secure = flag;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public MessageBytes getName() {
        return this.name;
    }

    public MessageBytes getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int v) {
        this.version = v;
    }

    public String toString() {
        return "Cookie " + this.getName() + "=" + this.getValue() + " ; " + this.getVersion() + " " + this.getPath() + " " + this.getDomain();
    }

    public static boolean isToken(String value) {
        if (value == null) {
            return true;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u007f' && tspecials.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isToken2(String value) {
        if (value == null) {
            return true;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u007f' && tspecials2.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean checkName(String name) {
        return ServerCookie.isToken(name) && !name.equalsIgnoreCase("Comment") && !name.equalsIgnoreCase("Discard") && !name.equalsIgnoreCase("Domain") && !name.equalsIgnoreCase("Expires") && !name.equalsIgnoreCase("Max-Age") && !name.equalsIgnoreCase("Path") && !name.equalsIgnoreCase("Secure") && !name.equalsIgnoreCase("Version");
    }

    public String getCookieHeaderName() {
        return ServerCookie.getCookieHeaderName(this.version);
    }

    public static String getCookieHeaderName(int version) {
        ServerCookie.log(version == 1 ? "Set-Cookie2" : "Set-Cookie");
        if (version == 1) {
            return "Set-Cookie";
        }
        return "Set-Cookie";
    }

    public static void appendCookieValue(StringBuffer buf, int version, String name, String value, String path, String domain, String comment, int maxAge, boolean isSecure) {
        buf.append(name);
        buf.append("=");
        ServerCookie.maybeQuote2(version, buf, value);
        if (version == 1) {
            buf.append("; Version=1");
            if (comment != null) {
                buf.append("; Comment=");
                ServerCookie.maybeQuote(version, buf, comment);
            }
        }
        if (domain != null) {
            buf.append("; Domain=");
            ServerCookie.maybeQuote(version, buf, domain);
        }
        if (maxAge >= 0) {
            if (version == 0) {
                buf.append("; Expires=");
                if (maxAge == 0) {
                    buf.append(ancientDate);
                } else {
                    DateTool.formatOldCookie(new Date(System.currentTimeMillis() + (long)maxAge * 1000L), buf, new FieldPosition(0));
                }
            } else {
                buf.append("; Max-Age=");
                buf.append(maxAge);
            }
        }
        if (path != null) {
            buf.append("; Path=");
            ServerCookie.maybeQuote(version, buf, path);
        }
        if (isSecure) {
            buf.append("; Secure");
        }
    }

    public static void maybeQuote(int version, StringBuffer buf, String value) {
        if (ServerCookie.isToken(value)) {
            buf.append(value);
        } else {
            buf.append('\"');
            buf.append(ServerCookie.escapeDoubleQuotes(value));
            buf.append('\"');
        }
    }

    public static void maybeQuote2(int version, StringBuffer buf, String value) {
        if (ServerCookie.isToken2(value)) {
            buf.append(value);
        } else {
            buf.append('\"');
            buf.append(ServerCookie.escapeDoubleQuotes(value));
            buf.append('\"');
        }
    }

    public static void log(String s) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ServerCookie: " + s));
        }
    }

    private static String escapeDoubleQuotes(String s) {
        if (s == null || s.length() == 0 || s.indexOf(34) == -1) {
            return s;
        }
        StringBuffer b = new StringBuffer();
        char p = s.charAt(0);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"' && p != '\\') {
                b.append('\\').append('\"');
            } else {
                b.append(c);
            }
            p = c;
        }
        return b.toString();
    }
}

