/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.net.jsse.JSSESupport;

class JSSE14Support
extends JSSESupport {
    private static Log logger = LogFactory.getLog(JSSE14Support.class);
    Listener listener = new Listener();

    public JSSE14Support(SSLSocket sock) {
        super(sock);
        sock.addHandshakeCompletedListener(this.listener);
    }

    protected void handShake() throws IOException {
        if (this.ssl.getWantClientAuth()) {
            logger.debug((Object)"No client cert sent for want");
        } else {
            this.ssl.setNeedClientAuth(true);
        }
        this.synchronousHandshake(this.ssl);
    }

    private void synchronousHandshake(SSLSocket socket) throws IOException {
        InputStream in = socket.getInputStream();
        int oldTimeout = socket.getSoTimeout();
        socket.setSoTimeout(1000);
        byte[] b = new byte[]{};
        this.listener.reset();
        socket.startHandshake();
        int maxTries = 60;
        for (int i = 0; i < maxTries; ++i) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Reading for try #" + i));
            }
            try {
                int x = in.read(b);
            }
            catch (SSLException sslex) {
                logger.info((Object)"SSL Error getting client Certs", (Throwable)sslex);
                throw sslex;
            }
            catch (IOException e) {
                // empty catch block
            }
            if (this.listener.completed) break;
        }
        socket.setSoTimeout(oldTimeout);
        if (!this.listener.completed) {
            throw new SocketException("SSL Cert handshake timeout");
        }
    }

    protected X509Certificate[] getX509Certificates(SSLSession session) throws IOException {
        Certificate[] certs = null;
        try {
            certs = session.getPeerCertificates();
        }
        catch (Throwable t) {
            logger.debug((Object)"Error getting client certs", t);
            return null;
        }
        if (certs == null) {
            return null;
        }
        X509Certificate[] x509Certs = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            if (certs[i] instanceof X509Certificate) {
                x509Certs[i] = (X509Certificate)certs[i];
            } else {
                try {
                    byte[] buffer = certs[i].getEncoded();
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                    x509Certs[i] = (X509Certificate)cf.generateCertificate(stream);
                }
                catch (Exception ex) {
                    logger.info((Object)("Error translating cert " + certs[i]), (Throwable)ex);
                    return null;
                }
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace((Object)("Cert #" + i + " = " + x509Certs[i]));
        }
        if (x509Certs.length < 1) {
            return null;
        }
        return x509Certs;
    }

    private static class Listener
    implements HandshakeCompletedListener {
        volatile boolean completed = false;

        private Listener() {
        }

        public void handshakeCompleted(HandshakeCompletedEvent event) {
            this.completed = true;
        }

        void reset() {
            this.completed = false;
        }
    }
}

