/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.mapping;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.cmis.CMISConstraintException;
import org.alfresco.cmis.CMISContentAlreadyExistsException;
import org.alfresco.cmis.CMISContentStreamAllowedEnum;
import org.alfresco.cmis.CMISDataTypeEnum;
import org.alfresco.cmis.CMISDictionaryModel;
import org.alfresco.cmis.CMISDictionaryService;
import org.alfresco.cmis.CMISFilterNotValidException;
import org.alfresco.cmis.CMISInvalidArgumentException;
import org.alfresco.cmis.CMISNotSupportedException;
import org.alfresco.cmis.CMISObjectNotFoundException;
import org.alfresco.cmis.CMISPermissionDeniedException;
import org.alfresco.cmis.CMISPropertyDefinition;
import org.alfresco.cmis.CMISRelationshipDirectionEnum;
import org.alfresco.cmis.CMISRendition;
import org.alfresco.cmis.CMISRenditionService;
import org.alfresco.cmis.CMISRuntimeException;
import org.alfresco.cmis.CMISScope;
import org.alfresco.cmis.CMISServiceException;
import org.alfresco.cmis.CMISServices;
import org.alfresco.cmis.CMISStreamNotSupportedException;
import org.alfresco.cmis.CMISTypeDefinition;
import org.alfresco.cmis.CMISTypesFilterEnum;
import org.alfresco.cmis.CMISUpdatabilityEnum;
import org.alfresco.cmis.CMISVersioningException;
import org.alfresco.cmis.CMISVersioningStateEnum;
import org.alfresco.cmis.PropertyFilter;
import org.alfresco.cmis.dictionary.CMISFolderTypeDefinition;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.encoding.ContentCharsetFinder;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.search.QueryParameterDefImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantDeployer;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.coci.CheckOutCheckInServiceException;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.InvalidAspectException;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionDoesNotExistException;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISServicesImpl
implements CMISServices,
ApplicationContextAware,
ApplicationListener<ApplicationContextEvent>,
TenantDeployer {
    private static final QName PARAM_PARENT = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"parent");
    private static final QName PARAM_USERNAME = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"username");
    private static final String LUCENE_QUERY_CHECKEDOUT = "+@cm\\:workingCopyOwner:${cm:username}";
    private static final String LUCENE_QUERY_CHECKEDOUT_IN_FOLDER = "+@cm\\:workingCopyOwner:${cm:username} +PARENT:\"${cm:parent}\"";
    private static final int ASSOC_ID_PREFIX_LENGTH = "assoc:".length();
    private static final Pattern ORDER_BY_PATTERN = Pattern.compile("^([^\\s,\"'\\\\\\.\\(\\)]+)\\s+(ASC|DESC)$");
    private Repository repository;
    private RetryingTransactionHelper retryingTransactionHelper;
    private DictionaryService dictionaryService;
    private CMISDictionaryService cmisDictionaryService;
    private NamespaceService namespaceService;
    private SearchService searchService;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private ContentService contentService;
    private TenantAdminService tenantAdminService;
    private CMISRenditionService cmisRenditionService;
    private CheckOutCheckInService checkOutCheckInService;
    private VersionService versionService;
    private MimetypeService mimetypeService;
    private ProcessorLifecycle lifecycle = new ProcessorLifecycle();
    private String cmisVersion = "[undefined]";
    private String cmisSpecTitle = "[undefined]";
    private StoreRef defaultStoreRef;
    private String defaultRootPath;
    private Map<String, NodeRef> defaultRootNodeRefs;
    private DataTypeDefinition nodeRefDataType;
    private DataTypeDefinition textDataType;

    public void setCMISSpecVersion(String cmisVersion) {
        this.cmisVersion = cmisVersion;
    }

    public void setCMISSpecTitle(String cmisSpecTitle) {
        this.cmisSpecTitle = cmisSpecTitle;
    }

    public void setDefaultStore(String store) {
        this.defaultStoreRef = new StoreRef(store);
    }

    public void setDefaultRootPath(String path) {
        this.defaultRootPath = path;
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    public void setTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setCMISDictionaryService(CMISDictionaryService cmisDictionaryService) {
        this.cmisDictionaryService = cmisDictionaryService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setCMISRenditionService(CMISRenditionService cmisRenditionService) {
        this.cmisRenditionService = cmisRenditionService;
    }

    public void setCheckOutCheckInService(CheckOutCheckInService checkOutCheckInService) {
        this.checkOutCheckInService = checkOutCheckInService;
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.lifecycle.setApplicationContext(applicationContext);
    }

    public void onApplicationEvent(ApplicationContextEvent event) {
        this.lifecycle.onApplicationEvent((ApplicationEvent)event);
    }

    public void onEnableTenant() {
        this.init();
    }

    public void onDisableTenant() {
        this.destroy();
    }

    public void init() {
        this.nodeRefDataType = this.dictionaryService.getDataType(DataTypeDefinition.NODE_REF);
        this.textDataType = this.dictionaryService.getDataType(DataTypeDefinition.TEXT);
        this.tenantAdminService.register(this);
        if (this.defaultRootNodeRefs == null) {
            this.defaultRootNodeRefs = new HashMap<String, NodeRef>(1);
        }
        this.getDefaultRootNodeRef();
    }

    public void destroy() {
        this.defaultRootNodeRefs.remove(this.tenantAdminService.getCurrentUserDomain());
    }

    @Override
    public String getCMISVersion() {
        return this.cmisVersion;
    }

    @Override
    public String getCMISSpecTitle() {
        return this.cmisSpecTitle;
    }

    @Override
    public String getDefaultRootPath() {
        return this.defaultRootPath;
    }

    @Override
    public NodeRef getDefaultRootNodeRef() {
        String tenantDomain = this.tenantAdminService.getCurrentUserDomain();
        NodeRef defaultNodeRef = this.defaultRootNodeRefs.get(tenantDomain);
        if (defaultNodeRef == null) {
            defaultNodeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    return CMISServicesImpl.this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                        @Override
                        public NodeRef execute() throws Exception {
                            NodeRef root = CMISServicesImpl.this.nodeService.getRootNode(CMISServicesImpl.this.defaultStoreRef);
                            List rootNodes = CMISServicesImpl.this.searchService.selectNodes(root, CMISServicesImpl.this.defaultRootPath, null, (NamespacePrefixResolver)CMISServicesImpl.this.namespaceService, false);
                            if (rootNodes.size() != 1) {
                                throw new AlfrescoRuntimeException("Unable to locate CMIS root path " + CMISServicesImpl.this.defaultRootPath);
                            }
                            return (NodeRef)rootNodes.get(0);
                        }
                    }, true, false);
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            if (defaultNodeRef == null) {
                throw new AlfrescoRuntimeException("Default root folder path '" + this.defaultRootPath + "' not found");
            }
            this.defaultRootNodeRefs.put(tenantDomain, defaultNodeRef);
        }
        return defaultNodeRef;
    }

    @Override
    public StoreRef getDefaultRootStoreRef() {
        return this.getDefaultRootNodeRef().getStoreRef();
    }

    @Override
    public NodeRef getNode(String referenceType, String[] reference) {
        NodeRef nodeRef = this.repository.findNodeRef(referenceType, reference);
        return nodeRef;
    }

    @Override
    public Map<String, Object> getRenditions(NodeRef nodeRef, String renditionFilter) throws CMISFilterNotValidException {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        List<CMISRendition> renditions = this.cmisRenditionService.getRenditions(nodeRef, renditionFilter);
        if (renditions == null) {
            renditions = Collections.emptyList();
        }
        result.put("node", nodeRef);
        result.put("renditionFilter", renditionFilter);
        result.put("renditions", renditions);
        ArrayList<NodeRef> renditionNodes = new ArrayList<NodeRef>(renditions.size());
        for (CMISRendition rendition : renditions) {
            renditionNodes.add(rendition.getNodeRef());
        }
        result.put("renditionNodes", renditionNodes);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRef[] getChildren(NodeRef parent, CMISTypesFilterEnum typesFilter, String orderBy) throws CMISInvalidArgumentException {
        if (typesFilter == CMISTypesFilterEnum.POLICIES) {
            return new NodeRef[0];
        }
        SearchParameters params = new SearchParameters();
        params.setLanguage("lucene");
        params.addStore(parent.getStoreRef());
        QueryParameterDefImpl parentDef = new QueryParameterDefImpl(PARAM_PARENT, this.nodeRefDataType, true, parent.toString());
        params.addQueryParameterDefinition((QueryParameterDefinition)parentDef);
        StringBuilder query = new StringBuilder(1024).append("+PARENT:\"${cm:parent}\" -ASPECT:\"").append(ContentModel.ASPECT_WORKING_COPY).append("\" +TYPE:(");
        if (typesFilter != CMISTypesFilterEnum.FOLDERS) {
            query.append('\"').append(ContentModel.TYPE_CONTENT).append('\"');
        }
        if (typesFilter != CMISTypesFilterEnum.DOCUMENTS) {
            if (typesFilter == CMISTypesFilterEnum.ANY) {
                query.append(" ");
            }
            query.append('\"').append(ContentModel.TYPE_FOLDER).append('\"');
        }
        query.append(") -TYPE:\"").append(ContentModel.TYPE_SYSTEM_FOLDER).append("\"");
        params.setQuery(query.toString());
        this.parseOrderBy(orderBy, params);
        ResultSet resultSet = null;
        try {
            resultSet = this.searchService.query(params);
            List results = resultSet.getNodeRefs();
            NodeRef[] nodeRefs = new NodeRef[results.size()];
            NodeRef[] nodeRefArray = results.toArray(nodeRefs);
            return nodeRefArray;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRef[] getCheckedOut(String username, NodeRef folder, boolean includeDescendants, String orderBy) throws CMISInvalidArgumentException {
        SearchParameters params = new SearchParameters();
        params.setLanguage("lucene");
        QueryParameterDefImpl usernameDef = new QueryParameterDefImpl(PARAM_USERNAME, this.textDataType, true, username);
        params.addQueryParameterDefinition((QueryParameterDefinition)usernameDef);
        if (folder == null) {
            params.setQuery(LUCENE_QUERY_CHECKEDOUT);
            params.addStore(this.getDefaultRootStoreRef());
        } else if (includeDescendants && this.nodeService.getRootNode(folder.getStoreRef()) == folder) {
            params.setQuery(LUCENE_QUERY_CHECKEDOUT);
            params.addStore(folder.getStoreRef());
        } else {
            params.setQuery(LUCENE_QUERY_CHECKEDOUT_IN_FOLDER);
            params.addStore(folder.getStoreRef());
            QueryParameterDefImpl parentDef = new QueryParameterDefImpl(PARAM_PARENT, this.nodeRefDataType, true, folder.toString());
            params.addQueryParameterDefinition((QueryParameterDefinition)parentDef);
        }
        this.parseOrderBy(orderBy, params);
        ResultSet resultSet = null;
        try {
            resultSet = this.searchService.query(params);
            List results = resultSet.getNodeRefs();
            NodeRef[] nodeRefs = new NodeRef[results.size()];
            NodeRef[] nodeRefArray = results.toArray(nodeRefs);
            return nodeRefArray;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    private void parseOrderBy(String orderBy, SearchParameters params) throws CMISInvalidArgumentException {
        if (orderBy == null) {
            return;
        }
        for (String token : orderBy.split(",")) {
            Matcher matcher = ORDER_BY_PATTERN.matcher(token);
            if (!matcher.matches()) {
                throw new CMISInvalidArgumentException("Invalid order by clause: \"" + orderBy + '\"');
            }
            String queryName = matcher.group(1);
            CMISPropertyDefinition propDef = this.cmisDictionaryService.findPropertyByQueryName(queryName);
            if (propDef == null) {
                throw new CMISInvalidArgumentException("No such property: \"" + queryName + '\"');
            }
            if (!propDef.isOrderable()) continue;
            params.addSort(propDef.getPropertyLuceneBuilder().getLuceneFieldName(), matcher.group(2).equals("ASC"));
        }
    }

    @Override
    public AssociationRef[] getRelationships(NodeRef node, CMISTypeDefinition relDef, boolean includeSubTypes, CMISRelationshipDirectionEnum direction) throws CMISInvalidArgumentException {
        if (relDef == null) {
            relDef = this.cmisDictionaryService.findType(CMISDictionaryModel.RELATIONSHIP_TYPE_ID);
        }
        if (!relDef.getBaseType().getTypeId().equals(CMISDictionaryModel.RELATIONSHIP_TYPE_ID)) {
            throw new AlfrescoRuntimeException("Type Id " + relDef.getTypeId() + " is not a relationship type");
        }
        ArrayList assocs = new ArrayList();
        if (direction == CMISRelationshipDirectionEnum.SOURCE || direction == CMISRelationshipDirectionEnum.BOTH) {
            assocs.addAll(this.nodeService.getTargetAssocs(node, RegexQNamePattern.MATCH_ALL));
        }
        if (direction == CMISRelationshipDirectionEnum.TARGET || direction == CMISRelationshipDirectionEnum.BOTH) {
            assocs.addAll(this.nodeService.getSourceAssocs(node, RegexQNamePattern.MATCH_ALL));
        }
        Collection<CMISTypeDefinition> subRelDefs = includeSubTypes ? relDef.getSubTypes(true) : null;
        ArrayList<AssociationRef> filteredAssocs = new ArrayList<AssociationRef>(assocs.size());
        for (AssociationRef assoc : assocs) {
            CMISTypeDefinition assocTypeDef = this.cmisDictionaryService.findTypeForClass(assoc.getTypeQName(), CMISScope.RELATIONSHIP);
            if (assocTypeDef == null || !assocTypeDef.equals(relDef) && (subRelDefs == null || !subRelDefs.contains(assocTypeDef))) continue;
            filteredAssocs.add(assoc);
        }
        AssociationRef[] assocArray = new AssociationRef[filteredAssocs.size()];
        filteredAssocs.toArray(assocArray);
        return assocArray;
    }

    @Override
    public Serializable getProperty(NodeRef nodeRef, String propertyName) throws CMISInvalidArgumentException {
        return this.getProperty(nodeRef, this.getTypeDefinition(nodeRef), propertyName);
    }

    @Override
    public Serializable getProperty(NodeRef nodeRef, CMISTypeDefinition typeDef, String propertyName) throws CMISInvalidArgumentException {
        CMISPropertyDefinition propDef = this.cmisDictionaryService.findProperty(propertyName, typeDef);
        if (propDef == null) {
            if (typeDef == null) {
                throw new CMISInvalidArgumentException("Property " + propertyName + " not found in CMIS Dictionary");
            }
            throw new CMISInvalidArgumentException("Property " + propertyName + " not found for type " + typeDef.getTypeId() + " in CMIS Dictionary");
        }
        return propDef.getPropertyAccessor().getValue(nodeRef);
    }

    @Override
    public CMISTypeDefinition getTypeDefinition(NodeRef nodeRef) throws CMISInvalidArgumentException {
        QName typeQName = this.nodeService.getType(nodeRef);
        CMISTypeDefinition typeDef = this.cmisDictionaryService.findTypeForClass(typeQName, new CMISScope[0]);
        if (typeDef == null) {
            throw new CMISInvalidArgumentException("Type " + typeQName + " not found in CMIS Dictionary");
        }
        return typeDef;
    }

    @Override
    public CMISTypeDefinition getTypeDefinition(AssociationRef associationRef) throws CMISInvalidArgumentException {
        QName typeQName = associationRef.getTypeQName();
        CMISTypeDefinition typeDef = this.cmisDictionaryService.findTypeForClass(typeQName, CMISScope.RELATIONSHIP);
        if (typeDef == null) {
            throw new CMISInvalidArgumentException("Association Type " + typeQName + " not found in CMIS Dictionary");
        }
        return typeDef;
    }

    @Override
    public CMISTypeDefinition getTypeDefinition(String typeId) throws CMISInvalidArgumentException {
        CMISTypeDefinition typeDef = null;
        try {
            typeDef = this.cmisDictionaryService.findType(typeId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (typeDef == null) {
            throw new CMISInvalidArgumentException("Invalid typeId " + typeId);
        }
        return typeDef;
    }

    @Override
    public CMISTypeDefinition getTypeDefinition(Object object) throws CMISInvalidArgumentException {
        if (object instanceof Version) {
            return this.getTypeDefinition(((Version)object).getFrozenStateNodeRef());
        }
        if (object instanceof NodeRef) {
            return this.getTypeDefinition((NodeRef)object);
        }
        if (object instanceof AssociationRef) {
            return this.getTypeDefinition((AssociationRef)object);
        }
        throw new CMISInvalidArgumentException("Invalid type " + object.getClass());
    }

    @Override
    public Collection<CMISTypeDefinition> getBaseTypes() {
        return this.cmisDictionaryService.getBaseTypes();
    }

    @Override
    public Serializable getProperty(AssociationRef assocRef, String propertyName) throws CMISInvalidArgumentException {
        CMISTypeDefinition typeDef = this.getTypeDefinition(assocRef);
        CMISPropertyDefinition propDef = this.cmisDictionaryService.findProperty(propertyName, typeDef);
        if (propDef == null) {
            throw new AlfrescoRuntimeException("Property " + propertyName + " not found for relationship type " + typeDef.getTypeId() + " in CMIS Dictionary");
        }
        return propDef.getPropertyAccessor().getValue(assocRef);
    }

    @Override
    public Map<String, Serializable> getProperties(NodeRef nodeRef) throws CMISInvalidArgumentException {
        return this.getProperties(nodeRef, this.getTypeDefinition(nodeRef));
    }

    @Override
    public Map<String, Serializable> getProperties(AssociationRef assocRef) throws CMISInvalidArgumentException {
        CMISTypeDefinition typeDef = this.getTypeDefinition(assocRef);
        Map<String, CMISPropertyDefinition> propDefs = typeDef.getPropertyDefinitions();
        HashMap<String, Serializable> values = new HashMap<String, Serializable>(propDefs.size() * 2);
        for (CMISPropertyDefinition propDef : propDefs.values()) {
            values.put(propDef.getPropertyId().getId(), propDef.getPropertyAccessor().getValue(assocRef));
        }
        return values;
    }

    @Override
    public Map<String, Serializable> getProperties(NodeRef nodeRef, CMISTypeDefinition typeDef) throws CMISInvalidArgumentException {
        Map<String, CMISPropertyDefinition> propDefs = typeDef.getPropertyDefinitions();
        HashMap<String, Serializable> values = new HashMap<String, Serializable>(propDefs.size() * 2);
        for (CMISPropertyDefinition propDef : propDefs.values()) {
            values.put(propDef.getPropertyId().getId(), propDef.getPropertyAccessor().getValue(nodeRef));
        }
        return values;
    }

    @Override
    public Set<CMISTypeDefinition> getAspects(NodeRef nodeRef) {
        Set aspects = this.nodeService.getAspects(nodeRef);
        HashSet<CMISTypeDefinition> result = new HashSet<CMISTypeDefinition>(aspects.size() * 2);
        for (QName aspect : aspects) {
            CMISTypeDefinition typeDef = this.cmisDictionaryService.findTypeForClass(aspect, CMISScope.POLICY);
            if (typeDef == null) continue;
            result.add(typeDef);
        }
        return result;
    }

    @Override
    public void setProperty(NodeRef nodeRef, String propertyName, Serializable value) throws CMISInvalidArgumentException, CMISConstraintException {
        this.setProperty(nodeRef, this.getTypeDefinition(nodeRef), propertyName, value);
    }

    @Override
    public void setProperty(NodeRef nodeRef, CMISTypeDefinition typeDef, String propertyName, Serializable value) throws CMISInvalidArgumentException, CMISConstraintException {
        CMISPropertyDefinition propDef = this.cmisDictionaryService.findProperty(propertyName, typeDef);
        if (propDef == null) {
            if (typeDef == null) {
                throw new CMISInvalidArgumentException("Property " + propertyName + " not found in CMIS Dictionary");
            }
            throw new CMISInvalidArgumentException("Property " + propertyName + " not found for type " + typeDef.getTypeId() + " in CMIS Dictionary");
        }
        CMISUpdatabilityEnum updatability = propDef.getUpdatability();
        if (updatability == CMISUpdatabilityEnum.READ_ONLY || updatability == CMISUpdatabilityEnum.READ_AND_WRITE_WHEN_CHECKED_OUT && !this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            throw new CMISConstraintException("Unable to update read-only property " + propertyName);
        }
        if (propDef.isRequired() && value == null) {
            throw new CMISConstraintException("Property " + propertyName + " is required");
        }
        if (propDef.getDataType() == CMISDataTypeEnum.STRING && propDef.getMaximumLength() > 0 && value != null && value.toString().length() > propDef.getMaximumLength()) {
            throw new CMISConstraintException("Value is too long for property " + propertyName);
        }
        QName property = propDef.getPropertyAccessor().getMappedProperty();
        if (property == null) {
            throw new CMISConstraintException("Unable to set property " + propertyName);
        }
        if (property.equals((Object)ContentModel.PROP_NAME)) {
            try {
                this.fileFolderService.rename(nodeRef, value.toString());
            }
            catch (FileExistsException e) {
                throw new CMISConstraintException("Object already exists with name " + value.toString());
            }
            catch (FileNotFoundException e) {
                throw new CMISInvalidArgumentException("Object with id " + nodeRef.toString() + " not found");
            }
        } else {
            this.nodeService.setProperty(nodeRef, property, value);
        }
    }

    @Override
    public void setAspects(NodeRef node, Iterable<String> aspectsToRemove, Iterable<String> aspectsToAdd) throws CMISInvalidArgumentException {
        for (String aspectType : aspectsToRemove) {
            try {
                this.nodeService.removeAspect(node, this.getTypeDefinition(aspectType).getTypeId().getQName());
            }
            catch (InvalidAspectException e) {
                throw new CMISInvalidArgumentException("Invalid aspect " + aspectType);
            }
            catch (InvalidNodeRefException e) {
                throw new CMISInvalidArgumentException("Invalid node " + node);
            }
        }
        for (String aspectType : aspectsToAdd) {
            try {
                this.nodeService.addAspect(node, this.getTypeDefinition(aspectType).getTypeId().getQName(), Collections.emptyMap());
            }
            catch (InvalidAspectException e) {
                throw new CMISInvalidArgumentException("Invalid aspect " + aspectType);
            }
            catch (InvalidNodeRefException e) {
                throw new CMISInvalidArgumentException("Invalid node " + node);
            }
        }
    }

    @Override
    public NodeRef applyVersioningState(NodeRef source, CMISVersioningStateEnum versioningState) throws CMISConstraintException, CMISInvalidArgumentException {
        switch (versioningState) {
            case NONE: {
                return source;
            }
            case CHECKED_OUT: {
                this.validateVersionable(source);
                if (!this.nodeService.hasAspect(source, ContentModel.ASPECT_VERSIONABLE)) {
                    HashMap<QName, Boolean> props = new HashMap<QName, Boolean>();
                    props.put(ContentModel.PROP_INITIAL_VERSION, false);
                    props.put(ContentModel.PROP_AUTO_VERSION, false);
                    this.nodeService.addAspect(source, ContentModel.ASPECT_VERSIONABLE, props);
                }
                return this.checkOutCheckInService.checkout(source);
            }
        }
        this.validateVersionable(source);
        this.versionService.createVersion(source, this.createVersionProperties("Initial Version", versioningState != CMISVersioningStateEnum.MINOR));
        return source;
    }

    @Override
    public NodeRef checkOut(String objectId) throws CMISConstraintException, CMISVersioningException, CMISObjectNotFoundException, CMISInvalidArgumentException, CMISPermissionDeniedException {
        NodeRef nodeRef = this.getObject(objectId, NodeRef.class, true, true, false);
        try {
            return this.checkOutCheckInService.checkout(nodeRef);
        }
        catch (CheckOutCheckInServiceException e) {
            throw new CMISVersioningException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (AccessDeniedException e) {
            throw new CMISPermissionDeniedException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Override
    public NodeRef checkIn(String objectId, String checkinComment, boolean isMajor) throws CMISConstraintException, CMISVersioningException, CMISObjectNotFoundException, CMISInvalidArgumentException, CMISPermissionDeniedException {
        NodeRef nodeRef = this.getObject(objectId, NodeRef.class, true, true, true);
        try {
            if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
                HashMap<QName, Boolean> props = new HashMap<QName, Boolean>();
                props.put(ContentModel.PROP_INITIAL_VERSION, false);
                props.put(ContentModel.PROP_AUTO_VERSION, false);
                this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, props);
            }
            return this.checkOutCheckInService.checkin(nodeRef, this.createVersionProperties(checkinComment, isMajor));
        }
        catch (CheckOutCheckInServiceException e) {
            throw new CMISVersioningException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (AccessDeniedException e) {
            throw new CMISPermissionDeniedException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Override
    public void cancelCheckOut(String objectId) throws CMISConstraintException, CMISVersioningException, CMISObjectNotFoundException, CMISInvalidArgumentException, CMISPermissionDeniedException {
        NodeRef nodeRef = this.getObject(objectId, NodeRef.class, true, true, true);
        try {
            this.checkOutCheckInService.cancelCheckout(nodeRef);
        }
        catch (CheckOutCheckInServiceException e) {
            throw new CMISVersioningException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (AccessDeniedException e) {
            throw new CMISPermissionDeniedException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Override
    public List<NodeRef> getAllVersions(String objectId) throws CMISConstraintException, CMISVersioningException, CMISObjectNotFoundException, CMISInvalidArgumentException, CMISPermissionDeniedException {
        VersionHistory versionHistory;
        NodeRef nodeRef = this.getVersionSeries(objectId, NodeRef.class, true);
        LinkedList<NodeRef> objects = new LinkedList<NodeRef>();
        NodeRef pwc = this.checkOutCheckInService.getWorkingCopy(nodeRef);
        if (pwc != null) {
            objects.add(pwc);
        }
        if ((versionHistory = this.versionService.getVersionHistory(nodeRef)) != null) {
            Version current = this.versionService.getCurrentVersion(nodeRef);
            while (current != null) {
                objects.add(current.getFrozenStateNodeRef());
                current = versionHistory.getPredecessor(current);
            }
        } else if (pwc == null) {
            objects.add(nodeRef);
        }
        return objects;
    }

    @Override
    public <T> T getObject(String objectId, Class<T> requiredType, boolean forUpdate, boolean isVersionable, boolean isPwc) throws CMISConstraintException, CMISVersioningException, CMISObjectNotFoundException, CMISInvalidArgumentException, CMISPermissionDeniedException {
        block24: {
            try {
                String nodeRefString;
                int sepIndex = objectId.lastIndexOf(59);
                if (sepIndex != -1 && NodeRef.isNodeRef((String)(nodeRefString = objectId.substring(0, sepIndex)))) {
                    if (isPwc) {
                        throw new CMISVersioningException(objectId + " is not a working copy");
                    }
                    if (requiredType.isAssignableFrom(Version.class) || !forUpdate && requiredType.isAssignableFrom(NodeRef.class)) {
                        NodeRef nodeRef = new NodeRef(nodeRefString);
                        if (!this.nodeService.exists(nodeRef)) {
                            throw new CMISObjectNotFoundException("Unable to find object " + objectId);
                        }
                        VersionHistory versionHistory = this.versionService.getVersionHistory(nodeRef);
                        if (versionHistory == null) {
                            throw new CMISObjectNotFoundException("Unable to find object " + objectId);
                        }
                        try {
                            Version version = versionHistory.getVersion(objectId.substring(sepIndex + 1));
                            return (T)(requiredType.isAssignableFrom(Version.class) ? version : version.getFrozenStateNodeRef());
                        }
                        catch (VersionDoesNotExistException e) {
                            throw new CMISObjectNotFoundException("Unable to find object " + objectId);
                        }
                    }
                    if (requiredType.isAssignableFrom(NodeRef.class)) {
                        throw new CMISVersioningException(objectId + " is not a current node");
                    }
                    break block24;
                }
                if (NodeRef.isNodeRef((String)objectId)) {
                    if (requiredType.isAssignableFrom(NodeRef.class)) {
                        NodeRef nodeRef = new NodeRef(objectId);
                        if (!this.nodeService.exists(nodeRef)) {
                            throw new CMISObjectNotFoundException("Unable to find object " + objectId);
                        }
                        if (isVersionable) {
                            this.validateVersionable(nodeRef);
                            if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY)) {
                                if (!isPwc) {
                                    throw new CMISVersioningException(objectId + " is a working copy");
                                }
                            } else {
                                if (isPwc) {
                                    throw new CMISVersioningException(objectId + " is not a working copy");
                                }
                                if (forUpdate && this.checkOutCheckInService.getWorkingCopy(nodeRef) != null) {
                                    throw new CMISVersioningException("Can't update " + objectId + " while checked out");
                                }
                            }
                        }
                        return (T)new NodeRef(objectId);
                    }
                    break block24;
                }
                if (objectId.startsWith("assoc:")) {
                    if (isPwc) {
                        throw new CMISVersioningException(objectId + " is not a working copy");
                    }
                    if (isVersionable) {
                        throw new CMISConstraintException("Type " + CMISDictionaryModel.RELATIONSHIP_TYPE_ID + " is not versionable");
                    }
                    if (requiredType.isAssignableFrom(AssociationRef.class)) {
                        AssociationRef associationRef = this.nodeService.getAssoc(new Long(objectId.substring(ASSOC_ID_PREFIX_LENGTH)));
                        if (associationRef == null) {
                            throw new CMISObjectNotFoundException("Unable to find object " + objectId);
                        }
                        return (T)associationRef;
                    }
                    break block24;
                }
                throw new CMISInvalidArgumentException(objectId + " is not an object ID");
            }
            catch (AccessDeniedException e) {
                throw new CMISPermissionDeniedException((Throwable)((Object)e));
            }
        }
        throw new CMISConstraintException("Object " + objectId + " is not of required type");
    }

    @Override
    public <T> T getReadableObject(String objectId, Class<T> requiredType) throws CMISConstraintException, CMISVersioningException, CMISObjectNotFoundException, CMISInvalidArgumentException, CMISPermissionDeniedException {
        return this.getObject(objectId, requiredType, false, false, false);
    }

    @Override
    public NodeRef getFolder(String objectId) throws CMISConstraintException, CMISVersioningException, CMISObjectNotFoundException, CMISInvalidArgumentException, CMISPermissionDeniedException {
        NodeRef folderRef = this.getReadableObject(objectId, NodeRef.class);
        CMISTypeDefinition typeDef = this.getTypeDefinition(folderRef);
        if (typeDef.getTypeId().getBaseTypeId() != CMISDictionaryModel.FOLDER_TYPE_ID) {
            throw new CMISInvalidArgumentException("Object " + objectId + " is not a folder");
        }
        return folderRef;
    }

    @Override
    public NodeRef getFolderParent(String folderId) throws CMISConstraintException, CMISVersioningException, CMISObjectNotFoundException, CMISInvalidArgumentException, CMISPermissionDeniedException {
        NodeRef folderRef = this.getFolder(folderId);
        if (this.getDefaultRootNodeRef().equals((Object)folderRef)) {
            throw new CMISInvalidArgumentException("Root Folder has no parents");
        }
        return this.nodeService.getPrimaryParent(folderRef).getParentRef();
    }

    @Override
    public <T> T getVersionSeries(String objectId, Class<T> requiredType, boolean isVersionable) throws CMISConstraintException, CMISVersioningException, CMISObjectNotFoundException, CMISInvalidArgumentException, CMISPermissionDeniedException {
        Object result;
        if (!requiredType.isAssignableFrom(NodeRef.class)) {
            return this.getObject(objectId, requiredType, false, isVersionable, false);
        }
        Object object = this.getReadableObject(objectId, Object.class);
        if (object instanceof Version) {
            result = ((Version)object).getVersionedNodeRef();
        } else if (object instanceof NodeRef) {
            NodeRef nodeRef = (NodeRef)object;
            result = this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY) ? (NodeRef)this.nodeService.getProperty(nodeRef, ContentModel.PROP_COPY_REFERENCE) : nodeRef;
            if (isVersionable) {
                this.validateVersionable((NodeRef)result);
            }
        } else if (requiredType.isAssignableFrom(object.getClass())) {
            if (isVersionable) {
                throw new CMISConstraintException(objectId + " is not versionable");
            }
            result = object;
        } else {
            throw new CMISConstraintException("Object " + objectId + " is not of required type");
        }
        return (T)result;
    }

    @Override
    public NodeRef getLatestVersion(String objectId, boolean major) throws CMISConstraintException, CMISVersioningException, CMISObjectNotFoundException, CMISInvalidArgumentException, CMISPermissionDeniedException {
        NodeRef versionSeries = this.getVersionSeries(objectId, NodeRef.class, false);
        if (!major) {
            NodeRef nodeRef = this.checkOutCheckInService.getWorkingCopy(versionSeries);
            if (nodeRef != null) {
                return nodeRef;
            }
            return versionSeries;
        }
        VersionHistory versionHistory = this.versionService.getVersionHistory(versionSeries);
        if (versionHistory == null) {
            throw new CMISObjectNotFoundException(objectId + " has no major version");
        }
        Version current = this.versionService.getCurrentVersion(versionSeries);
        while (current != null && current.getVersionType() != VersionType.MAJOR) {
            current = versionHistory.getPredecessor(current);
        }
        if (current == null) {
            throw new CMISObjectNotFoundException(objectId + " has no major version");
        }
        return current.getFrozenStateNodeRef();
    }

    @Override
    public void deleteContentStream(String objectId) throws CMISConstraintException, CMISVersioningException, CMISObjectNotFoundException, CMISInvalidArgumentException, CMISPermissionDeniedException {
        NodeRef currentNode = this.getObject(objectId, NodeRef.class, true, false, false);
        CMISTypeDefinition typeDef = this.getTypeDefinition(currentNode);
        if (CMISContentStreamAllowedEnum.REQUIRED.equals(typeDef.getContentStreamAllowed())) {
            throw new CMISConstraintException("The 'contentStreamAllowed' attribute of the specified Object-Type definition is set to 'required'.");
        }
        try {
            this.nodeService.setProperty(currentNode, ContentModel.PROP_CONTENT, null);
        }
        catch (AccessDeniedException e) {
            throw new CMISPermissionDeniedException((Throwable)((Object)e));
        }
    }

    @Override
    public void deleteObject(String objectId, boolean allVersions) throws CMISConstraintException, CMISVersioningException, CMISObjectNotFoundException, CMISInvalidArgumentException, CMISPermissionDeniedException, CMISRuntimeException {
        try {
            List childAssociations;
            Object object;
            Object object2 = object = allVersions ? this.getVersionSeries(objectId, Object.class, false) : this.getObject(objectId, Object.class, true, false, false);
            if (object instanceof AssociationRef) {
                AssociationRef assocRef = (AssociationRef)object;
                this.nodeService.removeAssociation(assocRef.getSourceRef(), assocRef.getTargetRef(), assocRef.getTypeQName());
                return;
            }
            if (object instanceof Version) {
                Version version = (Version)object;
                this.versionService.deleteVersion(version.getVersionedNodeRef(), version);
                return;
            }
            NodeRef nodeRef = (NodeRef)object;
            if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY)) {
                this.checkOutCheckInService.cancelCheckout(nodeRef);
                return;
            }
            CMISTypeDefinition typeDef = this.getTypeDefinition(nodeRef);
            if (typeDef.getTypeId().getBaseTypeId() == CMISDictionaryModel.FOLDER_TYPE_ID) {
                if (this.nodeService.getChildAssocs(nodeRef).size() > 0) {
                    throw new CMISConstraintException("Could not delete folder with at least one Child");
                }
            } else if (typeDef.isVersionable() && allVersions) {
                NodeRef workingCopy = this.checkOutCheckInService.getWorkingCopy(nodeRef);
                if (workingCopy != null) {
                    this.checkOutCheckInService.cancelCheckout(workingCopy);
                }
                this.versionService.deleteVersionHistory(nodeRef);
            }
            if ((childAssociations = this.nodeService.getParentAssocs(nodeRef)) != null) {
                for (ChildAssociationRef childAssoc : childAssociations) {
                    if (childAssoc.isPrimary()) continue;
                    this.nodeService.removeChildAssociation(childAssoc);
                }
            }
            this.nodeService.deleteNode(nodeRef);
        }
        catch (AccessDeniedException e) {
            throw new CMISPermissionDeniedException((Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new CMISRuntimeException(e);
        }
    }

    @Override
    public List<String> deleteTree(String objectId, boolean continueOnFailure, boolean unfile, boolean deleteAllVersions) throws CMISConstraintException, CMISVersioningException, CMISObjectNotFoundException, CMISInvalidArgumentException, CMISPermissionDeniedException {
        NodeRef folderRef = this.getFolder(objectId);
        LinkedList<String> failedToDelete = new LinkedList<String>();
        this.deleteTree(this.nodeService.getPrimaryParent(folderRef), continueOnFailure, unfile, deleteAllVersions, failedToDelete);
        return failedToDelete;
    }

    @Override
    public void deleteTreeReportLastError(String objectId, boolean continueOnFailure, boolean unfile, boolean deleteAllVersions) throws CMISServiceException {
        NodeRef folderRef = this.getFolder(objectId);
        LinkedList<String> failedToDelete = new LinkedList<String>();
        CMISServiceException lastError = this.deleteTree(this.nodeService.getPrimaryParent(folderRef), continueOnFailure, unfile, deleteAllVersions, failedToDelete);
        if (lastError != null) {
            throw lastError;
        }
    }

    private CMISServiceException deleteTree(ChildAssociationRef parentRef, boolean continueOnFailure, boolean unfile, boolean deleteAllVersions, List<String> failedToDelete) throws CMISInvalidArgumentException {
        CMISServiceException lastError = null;
        NodeRef child = parentRef.getChildRef();
        if (!this.nodeService.exists(child)) {
            return lastError;
        }
        String objectId = (String)((Object)this.getProperty(child, "cmis:objectId"));
        for (ChildAssociationRef childRef : this.nodeService.getChildAssocs(child)) {
            CMISServiceException thisError = this.deleteTree(childRef, continueOnFailure, unfile, deleteAllVersions, failedToDelete);
            if (thisError == null) continue;
            lastError = thisError;
            if (continueOnFailure) continue;
            return lastError;
        }
        if (lastError != null) {
            failedToDelete.add(objectId);
            return lastError;
        }
        try {
            if (unfile && !parentRef.isPrimary()) {
                this.nodeService.removeChildAssociation(parentRef);
            } else {
                this.deleteObject(objectId, deleteAllVersions);
            }
        }
        catch (AccessDeniedException t) {
            failedToDelete.add(objectId);
            lastError = new CMISPermissionDeniedException((Throwable)((Object)t));
        }
        catch (Throwable t) {
            if (RetryingTransactionHelper.extractRetryCause(t) != null) {
                throw new AlfrescoRuntimeException("Transactional Error", t);
            }
            failedToDelete.add(objectId);
            lastError = t instanceof CMISServiceException ? (CMISServiceException)t : new CMISRuntimeException(t);
        }
        return lastError;
    }

    @Override
    public void addObjectToFolder(String objectId, String folderId) throws CMISConstraintException, CMISVersioningException, CMISObjectNotFoundException, CMISInvalidArgumentException, CMISPermissionDeniedException {
        try {
            NodeRef objectNodeRef = this.getObject(objectId, NodeRef.class, true, false, false);
            NodeRef parentFolderNodeRef = this.getFolder(folderId);
            CMISTypeDefinition objectType = this.getTypeDefinition(objectNodeRef);
            CMISTypeDefinition folderType = this.getTypeDefinition(parentFolderNodeRef);
            if (!folderType.getAllowedTargetTypes().isEmpty() && !folderType.getAllowedTargetTypes().contains(objectType)) {
                throw new CMISConstraintException("An object of type '" + objectType.getTypeId() + "' can't be a child of a folder of type '" + folderType.getTypeId() + "'");
            }
            QName name = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)((String)((Object)this.nodeService.getProperty(objectNodeRef, ContentModel.PROP_NAME)))));
            this.nodeService.addChild(parentFolderNodeRef, objectNodeRef, ContentModel.ASSOC_CONTAINS, name);
        }
        catch (AccessDeniedException e) {
            throw new CMISPermissionDeniedException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Override
    public void removeObjectFromFolder(String objectId, String folderId) throws CMISNotSupportedException, CMISConstraintException, CMISVersioningException, CMISObjectNotFoundException, CMISInvalidArgumentException, CMISPermissionDeniedException {
        try {
            if (folderId == null || folderId.length() == 0) {
                throw new CMISNotSupportedException("Unfiling from primary parent folder is not supported. Use deleteObject() instead");
            }
            NodeRef objectNodeRef = this.getObject(objectId, NodeRef.class, true, false, false);
            NodeRef parentFolderNodeRef = this.getFolder(folderId);
            if (this.nodeService.getPrimaryParent(objectNodeRef).getParentRef().equals((Object)parentFolderNodeRef)) {
                throw new CMISNotSupportedException("Unfiling from primary parent folder is not supported. Use deleteObject() instead");
            }
            this.nodeService.removeChild(parentFolderNodeRef, objectNodeRef);
        }
        catch (AccessDeniedException e) {
            throw new CMISPermissionDeniedException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Override
    public void moveObject(String objectId, String targetFolderId, String sourceFolderId) throws CMISConstraintException, CMISVersioningException, CMISObjectNotFoundException, CMISInvalidArgumentException, CMISPermissionDeniedException {
        try {
            NodeRef sourceFolderNodeRef;
            NodeRef objectNodeRef = this.getObject(objectId, NodeRef.class, true, false, false);
            try {
                sourceFolderNodeRef = this.getFolder(sourceFolderId);
            }
            catch (CMISObjectNotFoundException e) {
                throw new CMISInvalidArgumentException(e.getMessage(), e);
            }
            NodeRef targetFolderNodeRef = this.getFolder(targetFolderId);
            CMISFolderTypeDefinition targetTypeDef = (CMISFolderTypeDefinition)this.getTypeDefinition(targetFolderNodeRef);
            CMISTypeDefinition objectTypeDef = this.getTypeDefinition(objectNodeRef);
            if (!targetTypeDef.getAllowedTargetTypes().isEmpty() && !targetTypeDef.getAllowedTargetTypes().contains(objectTypeDef)) {
                throw new CMISConstraintException("Object with '" + objectTypeDef.getTypeId() + "' Type can't be moved to Folder with '" + targetTypeDef.getTypeId() + "' Type");
            }
            ChildAssociationRef primaryParentRef = this.nodeService.getPrimaryParent(objectNodeRef);
            if (!primaryParentRef.getParentRef().equals((Object)sourceFolderNodeRef)) {
                for (ChildAssociationRef parent : this.nodeService.getParentAssocs(objectNodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL)) {
                    if (!parent.getParentRef().equals((Object)sourceFolderNodeRef)) continue;
                    this.nodeService.removeChildAssociation(parent);
                    this.nodeService.addChild(targetFolderNodeRef, objectNodeRef, ContentModel.ASSOC_CONTAINS, parent.getQName());
                    return;
                }
                throw new CMISInvalidArgumentException("The Document is not a Child of the Source Folder that was specified");
            }
            this.nodeService.moveNode(objectNodeRef, targetFolderNodeRef, primaryParentRef.getTypeQName(), primaryParentRef.getQName());
        }
        catch (AccessDeniedException e) {
            throw new CMISPermissionDeniedException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Override
    public boolean setContentStream(String objectId, QName propertyQName, boolean overwriteFlag, InputStream contentStream, String mimeType) throws CMISConstraintException, CMISVersioningException, CMISObjectNotFoundException, CMISContentAlreadyExistsException, CMISStreamNotSupportedException, CMISInvalidArgumentException, CMISPermissionDeniedException {
        try {
            boolean existed;
            NodeRef nodeRef = this.getObject(objectId, NodeRef.class, true, false, false);
            CMISTypeDefinition typeDef = this.getTypeDefinition(nodeRef);
            if (CMISContentStreamAllowedEnum.NOT_ALLOWED.equals(typeDef.getContentStreamAllowed())) {
                throw new CMISStreamNotSupportedException(typeDef);
            }
            if (propertyQName == null) {
                propertyQName = ContentModel.PROP_CONTENT;
            }
            boolean bl = existed = this.contentService.getReader(nodeRef, propertyQName) != null;
            if (existed && !overwriteFlag) {
                throw new CMISContentAlreadyExistsException();
            }
            contentStream = contentStream.markSupported() ? contentStream : new BufferedInputStream(contentStream);
            ContentCharsetFinder charsetFinder = this.mimetypeService.getContentCharsetFinder();
            Charset encoding = charsetFinder.getCharset(contentStream, mimeType);
            ContentWriter writer = this.contentService.getWriter(nodeRef, propertyQName, true);
            writer.setMimetype(mimeType);
            writer.setEncoding(encoding.name());
            writer.putContent(contentStream);
            return existed;
        }
        catch (AccessDeniedException e) {
            throw new CMISPermissionDeniedException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Override
    public String createPolicy(Map<String, Serializable> properties, String folderId, List<String> policies) throws CMISConstraintException, CMISRuntimeException, CMISInvalidArgumentException {
        String typeId = (String)((Object)properties.get("cmis:objectTypeId"));
        if (typeId == null) {
            throw new CMISConstraintException("Policy type ID not specified");
        }
        CMISTypeDefinition typeDefinition = this.getTypeDefinition(typeId);
        if (typeDefinition.getBaseType().getTypeId() != CMISDictionaryModel.POLICY_TYPE_ID) {
            throw new CMISConstraintException(typeId + " is not a policy type");
        }
        if (!typeDefinition.isCreatable()) {
            throw new CMISConstraintException(typeId + " is not a creatable type");
        }
        throw new CMISRuntimeException("Internal error");
    }

    @Override
    public void applyPolicy(String policyId, String objectId) throws CMISConstraintException, CMISVersioningException, CMISObjectNotFoundException, CMISInvalidArgumentException, CMISPermissionDeniedException {
        CMISTypeDefinition typeDef = this.getTypeDefinition(this.getReadableObject(objectId, Object.class));
        if (!typeDef.isControllablePolicy()) {
            throw new CMISConstraintException("Type " + typeDef.getTypeId().getId() + " does not allow policies to be applied");
        }
        this.getReadableObject(policyId, CMISTypeDefinition.class);
    }

    @Override
    public List<CMISTypeDefinition> getAppliedPolicies(String objectId, String filter) throws CMISConstraintException, CMISVersioningException, CMISObjectNotFoundException, CMISInvalidArgumentException, CMISPermissionDeniedException, CMISFilterNotValidException {
        this.getReadableObject(objectId, Object.class);
        new PropertyFilter(filter);
        return Collections.emptyList();
    }

    @Override
    public void removePolicy(String policyId, String objectId) throws CMISConstraintException, CMISVersioningException, CMISObjectNotFoundException, CMISInvalidArgumentException, CMISPermissionDeniedException {
        CMISTypeDefinition typeDef = this.getTypeDefinition(this.getReadableObject(objectId, Object.class));
        if (!typeDef.isControllablePolicy()) {
            throw new CMISConstraintException("Type " + typeDef.getTypeId().getId() + " does not allow policies to be applied");
        }
        this.getReadableObject(policyId, CMISTypeDefinition.class);
    }

    private void validateVersionable(NodeRef source) throws CMISConstraintException, CMISInvalidArgumentException {
        CMISTypeDefinition typeDef = this.getTypeDefinition(source);
        if (!typeDef.isVersionable()) {
            throw new CMISConstraintException("Type " + typeDef.getTypeId() + " is not versionable");
        }
    }

    private Map<String, Serializable> createVersionProperties(String versionDescription, boolean isMajor) {
        HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>(5);
        versionProperties.put("versionType", (Serializable)((Object)(isMajor ? VersionType.MAJOR : VersionType.MINOR)));
        if (versionDescription != null) {
            versionProperties.put("description", (Serializable)((Object)versionDescription));
        }
        return versionProperties;
    }

    private class ProcessorLifecycle
    extends AbstractLifecycleBean {
        private ProcessorLifecycle() {
        }

        protected void onBootstrap(ApplicationEvent event) {
            CMISServicesImpl.this.init();
        }

        protected void onShutdown(ApplicationEvent event) {
        }
    }
}

