/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.mapping;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.alfresco.cmis.mapping.AbstractSimpleProperty;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.analysis.DateTimeAnalyser;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.apache.lucene.index.IndexReader;
import org.springframework.extensions.surf.util.I18NUtil;

public class DirectProperty
extends AbstractSimpleProperty {
    private QName alfrescoName;

    public String getLuceneSortField(LuceneQueryParser lqp) {
        DataTypeDefinition dataType;
        String analyserClassName;
        String field = this.getLuceneFieldName();
        Locale sortLocale = null;
        PropertyDefinition propertyDef = this.getServiceRegistry().getDictionaryService().getProperty(QName.createQName((String)field.substring(1)));
        if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT)) {
            throw new SearcherException("Order on content properties is not curently supported");
        }
        if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.MLTEXT) || propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.TEXT)) {
            List<Locale> locales = lqp.getSearchParameters().getLocales();
            if (locales == null || locales.size() == 0) {
                locales = Collections.singletonList(I18NUtil.getLocale());
            }
            if (locales.size() > 1) {
                throw new SearcherException("Order on text/mltext properties with more than one locale is not curently supported");
            }
            sortLocale = locales.get(0);
            HashSet<String> allowableLocales = new HashSet<String>();
            MLAnalysisMode analysisMode = lqp.getDefaultSearchMLAnalysisMode();
            for (Locale l : MLAnalysisMode.getLocales((MLAnalysisMode)analysisMode, (Locale)sortLocale, (boolean)false)) {
                allowableLocales.add(l.toString());
            }
            String sortField = field;
            for (Object current : lqp.getIndexReader().getFieldNames(IndexReader.FieldOption.INDEXED)) {
                String fieldLocale;
                String currentString = (String)current;
                if (!currentString.startsWith(field) || !currentString.endsWith(".sort") || !allowableLocales.contains(fieldLocale = currentString.substring(field.length() + 1, currentString.length() - 5))) continue;
                if (fieldLocale.equals(sortLocale.toString())) {
                    sortField = currentString;
                    break;
                }
                if (sortLocale.toString().startsWith(fieldLocale)) {
                    if (!sortField.equals(field) && currentString.length() >= sortField.length()) continue;
                    sortField = currentString;
                    continue;
                }
                if (!fieldLocale.startsWith(sortLocale.toString()) || !sortField.equals(field) && currentString.length() >= sortField.length()) continue;
                sortField = currentString;
            }
            field = sortField;
        } else if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.DATETIME) && (analyserClassName = (dataType = propertyDef.getDataType()).getAnalyserClassName()).equals(DateTimeAnalyser.class.getCanonicalName())) {
            field = field + ".sort";
        }
        return field;
    }

    public DirectProperty(ServiceRegistry serviceRegistry, String propertyName, QName alfrescoName) {
        super(serviceRegistry, propertyName);
        this.alfrescoName = alfrescoName;
    }

    public QName getMappedProperty() {
        return this.alfrescoName;
    }

    public Serializable getValue(NodeRef nodeRef) {
        return this.getServiceRegistry().getNodeService().getProperty(nodeRef, this.alfrescoName);
    }

    public Serializable getValue(AssociationRef assocRef) {
        return null;
    }

    public String getLuceneFieldName() {
        StringBuilder field = new StringBuilder(64);
        field.append("@");
        field.append(this.alfrescoName);
        return field.toString();
    }

    protected String getValueAsString(Serializable value) {
        PropertyDefinition pd = this.getServiceRegistry().getDictionaryService().getProperty(this.alfrescoName);
        Object converted = DefaultTypeConverter.INSTANCE.convert(pd.getDataType(), (Object)value);
        String asString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, converted);
        return asString;
    }

    protected QName getQNameForExists() {
        return this.alfrescoName;
    }

    protected DataTypeDefinition getInDataType() {
        PropertyDefinition pd = this.getServiceRegistry().getDictionaryService().getProperty(this.alfrescoName);
        return pd.getDataType();
    }
}

