/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.renditions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.cmis.CMISFilterNotValidException;
import org.alfresco.cmis.CMISRendition;
import org.alfresco.cmis.CMISRenditionService;
import org.alfresco.cmis.renditions.CMISRenditionImpl;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.content.transform.magick.ImageResizeOptions;
import org.alfresco.repo.content.transform.magick.ImageTransformationOptions;
import org.alfresco.repo.thumbnail.ThumbnailDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISRenditionServiceImpl
implements CMISRenditionService {
    private static final String FILTER_WILDCARD = "*";
    private static final String FILTER_NONE = "cmis:none";
    private static final String FILTER_DELIMITER = ",";
    private static final String SUBTYPES_POSTFIX = "/*";
    private static final String SUBTYPES_DELIMITER = "/";
    private ThumbnailService thumbnailService;
    private NodeService nodeService;
    private Map<String, List<String>> kindToThumbnailNames = new HashMap<String, List<String>>();
    private Map<String, String> thumbnailNamesToKind = new HashMap<String, String>();
    private CustomRenditionsCache customRenditionsCache;

    @Override
    public List<CMISRendition> getRenditions(NodeRef node, String renditionFilter) throws CMISFilterNotValidException {
        Set<CMISRendition> result = null;
        ThumbnailFilter thumbnailFilter = this.getThumbnailFilter(renditionFilter);
        if (thumbnailFilter != null) {
            result = this.getRenditions(node, thumbnailFilter);
        }
        return result != null ? new ArrayList<CMISRendition>(result) : null;
    }

    private Set<CMISRendition> getRenditions(NodeRef node, ThumbnailFilter thumbnailFilter) {
        HashSet<CMISRendition> result = new HashSet<CMISRendition>();
        if (thumbnailFilter.isAny()) {
            result.addAll(this.getAllRenditions(node));
        } else {
            for (String thumbnailName : thumbnailFilter.getThumbnailNames()) {
                CMISRendition rendition = this.getRenditionByThumbnailName(node, thumbnailName);
                if (rendition == null) continue;
                result.add(rendition);
            }
            for (String mimetype : thumbnailFilter.getMimetypes()) {
                result.addAll(this.getRenditionByMimetype(node, mimetype));
            }
        }
        result.addAll(this.getCustomRenditions(thumbnailFilter));
        return result;
    }

    private CMISRendition getRenditionByThumbnailName(NodeRef node, String thumbnailName) {
        CMISRendition result = null;
        NodeRef thumbnailNode = this.thumbnailService.getThumbnailByName(node, ContentModel.PROP_CONTENT, thumbnailName);
        if (thumbnailNode != null) {
            result = this.getRendition(thumbnailNode, node);
        }
        return result;
    }

    private List<CMISRendition> getRenditionByMimetype(NodeRef node, String mimetype) {
        ArrayList<CMISRendition> result = new ArrayList<CMISRendition>();
        List<NodeRef> thumbnails = this.thumbnailService.getThumbnails(node, ContentModel.PROP_CONTENT, mimetype, null);
        if (thumbnails != null) {
            for (NodeRef thumbnailNode : thumbnails) {
                CMISRendition rendition = this.getRendition(thumbnailNode, node);
                if (rendition == null) continue;
                result.add(rendition);
            }
        }
        return result;
    }

    private ThumbnailFilter getThumbnailFilter(String renditionFilter) throws CMISFilterNotValidException {
        ThumbnailFilter result = null;
        if (renditionFilter != null && !renditionFilter.equals(FILTER_NONE)) {
            int i = 0;
            while (i < renditionFilter.length()) {
                if (Character.isWhitespace(renditionFilter.codePointAt(i))) {
                    throw new CMISFilterNotValidException(renditionFilter);
                }
                i = renditionFilter.offsetByCodePoints(i, 1);
            }
            result = new ThumbnailFilter();
            if (renditionFilter.equals(FILTER_WILDCARD)) {
                result.setAny(true);
            } else {
                String[] filterElements = renditionFilter.split(FILTER_DELIMITER);
                if (filterElements == null || filterElements.length < 1) {
                    throw new AlfrescoRuntimeException("Invalid rendition filter");
                }
                for (String filterElement : filterElements) {
                    if ((filterElement = filterElement.trim()).indexOf(47) == -1) {
                        result.getKinds().add(filterElement);
                        List<String> thumbnails = this.kindToThumbnailNames.get(filterElement);
                        if (thumbnails == null) continue;
                        result.getThumbnailNames().addAll(thumbnails);
                        continue;
                    }
                    result.getMimetypes().add(filterElement);
                }
            }
        }
        return result;
    }

    private ThumbnailDefinition getThumbnailDefinition(String thumbnailName) {
        return this.thumbnailService.getThumbnailRegistry().getThumbnailDefinition(thumbnailName);
    }

    private ImageResizeOptions getImageAttributes(String thumbnailName) {
        ThumbnailDefinition thumbnailDefinition = this.getThumbnailDefinition(thumbnailName);
        if (thumbnailDefinition != null && thumbnailDefinition.getTransformationOptions() != null && thumbnailDefinition.getTransformationOptions() instanceof ImageTransformationOptions) {
            return ((ImageTransformationOptions)thumbnailDefinition.getTransformationOptions()).getResizeOptions();
        }
        return null;
    }

    private CMISRendition getRendition(NodeRef thumbnailNode, NodeRef documentNode) {
        CMISRenditionImpl rendition = null;
        String thumbnailName = this.getThumbnailName(thumbnailNode);
        String kind = this.thumbnailNamesToKind.get(thumbnailName);
        kind = kind == null ? thumbnailName : kind;
        rendition = new CMISRenditionImpl();
        ContentData contentData = (ContentData)this.nodeService.getProperty(thumbnailNode, ContentModel.PROP_CONTENT);
        rendition.setNodeRef(thumbnailNode);
        rendition.setStreamId(thumbnailNode.toString());
        rendition.setRenditionDocumentId(documentNode.toString());
        rendition.setTitle(thumbnailName);
        rendition.setKind(kind);
        rendition.setMimeType(contentData.getMimetype());
        rendition.setLength((int)contentData.getSize());
        ImageResizeOptions imageAttributes = this.getImageAttributes(thumbnailName);
        if (imageAttributes != null) {
            rendition.setWidth(imageAttributes.getWidth());
            rendition.setHeight(imageAttributes.getHeight());
        }
        return rendition;
    }

    private String getThumbnailName(NodeRef thumbnailNode) {
        String thumbnailName = null;
        List parentAssocs = this.nodeService.getParentAssocs(thumbnailNode, (QNamePattern)RenditionModel.ASSOC_RENDITION, RegexQNamePattern.MATCH_ALL);
        if (parentAssocs.size() == 1) {
            ChildAssociationRef parentAssoc = (ChildAssociationRef)parentAssocs.get(0);
            thumbnailName = parentAssoc.getQName().getLocalName();
        }
        return thumbnailName;
    }

    private List<CMISRendition> getCustomRenditions(ThumbnailFilter filter) {
        ArrayList<CMISRendition> result = new ArrayList<CMISRendition>();
        if (this.customRenditionsCache != null) {
            if (filter.isAny()) {
                result.addAll(this.customRenditionsCache.getAllRenditions());
            } else {
                List<CMISRendition> renditions;
                for (String kind : filter.getKinds()) {
                    renditions = this.customRenditionsCache.getRenditionsByKind(kind);
                    if (renditions == null) continue;
                    result.addAll(renditions);
                }
                for (String mimetype : filter.getMimetypes()) {
                    renditions = this.customRenditionsCache.getRenditionsByMimeType(mimetype);
                    if (renditions == null) continue;
                    result.addAll(renditions);
                }
            }
        }
        return result;
    }

    private List<CMISRendition> getAllRenditions(NodeRef node) {
        return this.getRenditionByMimetype(node, null);
    }

    public void setRenditionKindMapping(Map<String, List<String>> renditionKinds) {
        this.kindToThumbnailNames = renditionKinds;
        for (Map.Entry<String, List<String>> entry : renditionKinds.entrySet()) {
            for (String thumbnailName : entry.getValue()) {
                this.thumbnailNamesToKind.put(thumbnailName, entry.getKey());
            }
        }
    }

    public void setCustomRenditions(List<CMISRendition> renditions) {
        this.customRenditionsCache = new CustomRenditionsCache(renditions);
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setThumbnailService(ThumbnailService thumbnailService) {
        this.thumbnailService = thumbnailService;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ThumbnailFilter {
        private List<String> kinds = new ArrayList<String>();
        private List<String> thumbnailNames = new ArrayList<String>();
        private List<String> mimetypes = new ArrayList<String>();
        private boolean any = false;

        private ThumbnailFilter() {
        }

        public List<String> getThumbnailNames() {
            return this.thumbnailNames;
        }

        public List<String> getMimetypes() {
            return this.mimetypes;
        }

        public List<String> getKinds() {
            return this.kinds;
        }

        public boolean isAny() {
            return this.any;
        }

        public void setAny(boolean any) {
            this.any = any;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CustomRenditionsCache {
        private Map<String, List<CMISRendition>> renditionsByKind;
        private Map<String, List<CMISRendition>> renditionsByMimeType;
        private Map<String, List<CMISRendition>> renditionsByBaseMimeType;
        private List<CMISRendition> allRenditions;

        public CustomRenditionsCache(List<CMISRendition> renditions) {
            this.allRenditions = renditions;
            this.renditionsByKind = new HashMap<String, List<CMISRendition>>(renditions.size());
            this.renditionsByMimeType = new HashMap<String, List<CMISRendition>>(renditions.size());
            this.renditionsByBaseMimeType = new HashMap<String, List<CMISRendition>>(renditions.size());
            for (CMISRendition rendition : renditions) {
                String baseType = this.getBaseType(rendition.getMimeType());
                if (!this.renditionsByKind.containsKey(rendition.getKind())) {
                    this.renditionsByKind.put(rendition.getKind(), new ArrayList(1));
                }
                if (!this.renditionsByMimeType.containsKey(rendition.getMimeType())) {
                    this.renditionsByMimeType.put(rendition.getMimeType(), new ArrayList(1));
                }
                if (!this.renditionsByBaseMimeType.containsKey(baseType)) {
                    this.renditionsByBaseMimeType.put(baseType, new ArrayList(1));
                }
                this.renditionsByKind.get(rendition.getKind()).add(rendition);
                this.renditionsByMimeType.get(rendition.getMimeType()).add(rendition);
                this.renditionsByBaseMimeType.get(baseType).add(rendition);
            }
        }

        public List<CMISRendition> getRenditionsByKind(String kind) {
            return this.renditionsByKind.get(kind);
        }

        public List<CMISRendition> getRenditionsByMimeType(String mimetype) {
            if (mimetype.endsWith(CMISRenditionServiceImpl.SUBTYPES_POSTFIX)) {
                String baseMimetype = mimetype.substring(0, mimetype.length() - CMISRenditionServiceImpl.SUBTYPES_POSTFIX.length());
                return this.renditionsByBaseMimeType.get(baseMimetype);
            }
            return this.renditionsByMimeType.get(mimetype);
        }

        public Collection<CMISRendition> getAllRenditions() {
            return this.allRenditions;
        }

        private String getBaseType(String mimetype) {
            String baseMymetype = mimetype;
            int subTypeIndex = mimetype.indexOf(CMISRenditionServiceImpl.SUBTYPES_DELIMITER);
            if (subTypeIndex > 0 || subTypeIndex < mimetype.length()) {
                baseMymetype = mimetype.substring(0, subTypeIndex);
            }
            return baseMymetype;
        }
    }
}

