/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.alfresco;

import org.alfresco.service.cmr.repository.NodeRef;

public class DesktopTarget {
    public static final int TargetFile = 0;
    public static final int TargetFolder = 1;
    public static final int TargetCopiedFile = 2;
    public static final int TargetCopiedFolder = 3;
    public static final int TargetNodeRef = 4;
    private int m_type;
    private String m_target;
    private NodeRef m_noderef;

    public DesktopTarget(int typ, String path) {
        this.m_type = typ;
        this.m_target = path;
    }

    public final int isType() {
        return this.m_type;
    }

    public final String getTarget() {
        return this.m_target;
    }

    public final boolean hasNodeRef() {
        return this.m_noderef != null;
    }

    public final NodeRef getNode() {
        return this.m_noderef;
    }

    public final String getTypeAsString() {
        String str = null;
        switch (this.isType()) {
            case 0: {
                str = "File";
                break;
            }
            case 1: {
                str = "Folder";
                break;
            }
            case 2: {
                str = "File Copy";
                break;
            }
            case 3: {
                str = "Folder Copy";
                break;
            }
            case 4: {
                str = "NodeRef";
            }
        }
        return str;
    }

    public final void setNode(NodeRef node) {
        this.m_noderef = node;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.getTypeAsString());
        str.append(":");
        str.append(this.getTarget());
        if (this.hasNodeRef()) {
            str.append(":");
            str.append(this.getNode());
        }
        str.append("]");
        return str.toString();
    }
}

