/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.alfresco;

import java.util.Enumeration;
import org.alfresco.filesys.alfresco.DesktopAction;
import org.alfresco.filesys.alfresco.DesktopActionTable;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.filesys.FileName;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.pseudo.MemoryPseudoFile;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFile;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFileInterface;
import org.alfresco.jlan.smb.server.SMBSrvSession;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PseudoFileImpl
implements PseudoFileInterface {
    private static final Log logger = LogFactory.getLog(PseudoFileImpl.class);

    public boolean isPseudoFile(SrvSession sess, TreeConnection tree, String path) {
        ContentContext ctx = (ContentContext)tree.getContext();
        boolean isPseudo = false;
        String[] paths = FileName.splitPath((String)path);
        FileState fstate = this.getStateForPath(ctx, paths[0]);
        if (paths[1] != null) {
            if (fstate != null && fstate.hasPseudoFiles()) {
                PseudoFile pfile = fstate.getPseudoFileList().findFile(paths[1], false);
                if (pfile != null) {
                    isPseudo = true;
                }
            } else {
                DesktopActionTable actions;
                if (ctx.hasDesktopActions() && (actions = ctx.getDesktopActions()).getActionViaPseudoName(paths[1]) != null) {
                    isPseudo = true;
                }
                if (!isPseudo && ctx.hasURLFile() && ctx.getURLFileName().equals(paths[1])) {
                    isPseudo = true;
                }
            }
        }
        return isPseudo;
    }

    public PseudoFile getPseudoFile(SrvSession sess, TreeConnection tree, String path) {
        PseudoFile pfile;
        String[] paths;
        ContentContext ctx = (ContentContext)tree.getContext();
        FileState fstate = this.getStateForPath(ctx, (paths = FileName.splitPath((String)path))[0]);
        if (fstate != null && fstate.hasPseudoFiles() && (pfile = fstate.getPseudoFileList().findFile(paths[1], false)) != null) {
            return pfile;
        }
        return null;
    }

    public int addPseudoFilesToFolder(SrvSession sess, TreeConnection tree, String path) {
        int pseudoCnt = 0;
        ContentContext ctx = (ContentContext)tree.getContext();
        FileState fstate = this.getStateForPath(ctx, path);
        if (fstate.hasPseudoFiles()) {
            return 0;
        }
        boolean isCIFS = sess instanceof SMBSrvSession;
        if (isCIFS && ctx.numberOfDesktopActions() > 0 && !path.equals("\\")) {
            if (fstate == null) {
                ctx.getStateCache().findFileState(path, true);
            }
            DesktopActionTable actions = ctx.getDesktopActions();
            Enumeration<String> actionNames = actions.enumerateActionNames();
            while (actionNames.hasMoreElements()) {
                String name = actionNames.nextElement();
                DesktopAction action = actions.getAction(name);
                if (!action.hasPseudoFile()) continue;
                fstate.addPseudoFile(action.getPseudoFile());
                ++pseudoCnt;
                if (!logger.isInfoEnabled()) continue;
                logger.info((Object)("Added desktop action " + action.getName() + " for " + path));
            }
        }
        if (isCIFS && ctx.hasURLFile() && fstate.hasFilesystemObject()) {
            NodeRef nodeRef = (NodeRef)fstate.getFilesystemObject();
            StringBuilder urlStr = new StringBuilder();
            urlStr.append("[InternetShortcut]\r\n");
            urlStr.append("URL=");
            urlStr.append(ctx.getURLPrefix());
            urlStr.append("navigate/browse/workspace/SpacesStore/");
            urlStr.append(nodeRef.getId());
            urlStr.append("\r\n");
            byte[] urlData = urlStr.toString().getBytes();
            MemoryPseudoFile urlFile = new MemoryPseudoFile(ctx.getURLFileName(), urlData);
            fstate.addPseudoFile((PseudoFile)urlFile);
            ++pseudoCnt;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Added URL link pseudo file for " + path));
            }
        }
        return pseudoCnt;
    }

    public void deletePseudoFile(SrvSession sess, TreeConnection tree, String path) {
        String[] paths;
        ContentContext ctx = (ContentContext)tree.getContext();
        FileState fstate = this.getStateForPath(ctx, (paths = FileName.splitPath((String)path))[0]);
        if (fstate == null || !fstate.hasPseudoFiles()) {
            return;
        }
        fstate.getPseudoFileList().removeFile(paths[1], false);
    }

    private final FileState getStateForPath(ContentContext ctx, String path) {
        FileState fstate = null;
        if (ctx.hasStateCache()) {
            fstate = ctx.getStateCache().findFileState(path);
        }
        return fstate;
    }
}

