/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.alfresco.repo.action.ActionCancelledException;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.RuntimeActionService;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionStatus;
import org.alfresco.service.cmr.action.ActionTrackingService;
import org.alfresco.service.cmr.action.CancellableAction;
import org.alfresco.service.cmr.action.ExecutionDetails;
import org.alfresco.service.cmr.action.ExecutionSummary;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionTrackingServiceImpl
implements ActionTrackingService {
    private static Log logger = LogFactory.getLog(ActionTrackingServiceImpl.class);
    private SimpleCache<String, ExecutionDetails> executingActionsCache;
    private TransactionService transactionService;
    private RuntimeActionService runtimeActionService;
    private short nextExecutionId = 1;
    private short wrapExecutionIdAfter = (short)16383;
    private static final char cacheKeyPartSeparator = '=';
    private static String machineName = null;

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setRuntimeActionService(RuntimeActionService runtimeActionService) {
        this.runtimeActionService = runtimeActionService;
    }

    public void setExecutingActionsCache(SimpleCache<String, ExecutionDetails> executingActionsCache) {
        this.executingActionsCache = executingActionsCache;
    }

    protected void resetNextExecutionId() {
        this.nextExecutionId = 1;
    }

    @Override
    public void recordActionPending(Action action) {
        this.recordActionPending((ActionImpl)action);
    }

    public void recordActionPending(ActionImpl action) {
        action.setExecutionStatus(ActionStatus.Pending);
        action.setExecutionStartDate(null);
        this.placeActionInCache(action);
    }

    @Override
    public void recordActionComplete(Action action) {
        this.recordActionComplete((ActionImpl)action);
    }

    private void recordActionComplete(ActionImpl action) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Action " + action + " has completed execution"));
        }
        action.setExecutionEndDate(new Date());
        action.setExecutionStatus(ActionStatus.Completed);
        action.setExecutionFailureMessage(null);
        if (action.getNodeRef() != null) {
            final Date startedAt = action.getExecutionStartDate();
            final Date endedAt = action.getExecutionEndDate();
            final NodeRef actionNode = action.getNodeRef();
            AlfrescoTransactionSupport.bindListener(new TransactionListenerAdapter(){

                public void afterCommit() {
                    ActionTrackingServiceImpl.this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                        @Override
                        public Object execute() throws Throwable {
                            return AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Action>(){

                                public Action doWork() throws Exception {
                                    ActionImpl action = (ActionImpl)ActionTrackingServiceImpl.this.runtimeActionService.createAction(actionNode);
                                    action.setExecutionStatus(ActionStatus.Completed);
                                    action.setExecutionFailureMessage(null);
                                    action.setExecutionStartDate(startedAt);
                                    action.setExecutionEndDate(endedAt);
                                    ActionTrackingServiceImpl.this.runtimeActionService.saveActionImpl(actionNode, action);
                                    return action;
                                }
                            }, (String)"System");
                        }
                    }, false, true);
                }
            });
        }
        String key = ActionTrackingServiceImpl.generateCacheKey(action);
        this.executingActionsCache.remove((Serializable)((Object)key));
    }

    @Override
    public void recordActionExecuting(Action action) {
        this.recordActionExecuting((ActionImpl)action);
    }

    private void recordActionExecuting(ActionImpl action) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Action " + action + " with provisional key " + ActionTrackingServiceImpl.generateCacheKey(action) + " has begun exection"));
        }
        ActionStatus previousStatus = action.getExecutionStatus();
        action.setExecutionStartDate(new Date());
        action.setExecutionStatus(ActionStatus.Running);
        if (previousStatus != ActionStatus.Pending) {
            this.placeActionInCache(action);
        } else {
            String key = ActionTrackingServiceImpl.generateCacheKey(action);
            ExecutionDetails details = (ExecutionDetails)this.executingActionsCache.get((Serializable)((Object)key));
            if (details == null) {
                logger.warn((Object)("Went to mark the start of execution of " + action + " with key " + key + " but it wasn't in the running actions cache! " + "Your running actions cache is probably too small"));
            }
            details = ActionTrackingServiceImpl.buildExecutionDetails(action);
            this.executingActionsCache.put((Serializable)((Object)key), (Object)details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void placeActionInCache(ActionImpl action) {
        String key = null;
        boolean assigned = false;
        while (!assigned) {
            short s = this.nextExecutionId;
            this.nextExecutionId = (short)(s + 1);
            action.setExecutionInstance(s);
            key = ActionTrackingServiceImpl.generateCacheKey(action);
            if (this.executingActionsCache.get((Serializable)((Object)key)) == null) {
                assigned = true;
            }
            if (this.nextExecutionId <= this.wrapExecutionIdAfter) continue;
            ActionTrackingServiceImpl actionTrackingServiceImpl = this;
            synchronized (actionTrackingServiceImpl) {
                while (this.nextExecutionId > this.wrapExecutionIdAfter) {
                    this.nextExecutionId = (short)(this.nextExecutionId - this.wrapExecutionIdAfter);
                }
            }
        }
        ExecutionDetails details = ActionTrackingServiceImpl.buildExecutionDetails(action);
        this.executingActionsCache.put(key, (Object)details);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Action " + action + " with key " + key + " placed into execution cache"));
        }
    }

    @Override
    public void recordActionFailure(Action action, final Throwable exception) {
        if (logger.isDebugEnabled()) {
            if (exception instanceof ActionCancelledException) {
                logger.debug((Object)("Will shortly record completed cancellation of action " + action));
            } else {
                logger.debug((Object)("Will shortly record failure of action " + action + " due to " + exception.getMessage()));
            }
        }
        ((ActionImpl)action).setExecutionEndDate(new Date());
        if (exception instanceof ActionCancelledException) {
            ((ActionImpl)action).setExecutionStatus(ActionStatus.Cancelled);
            ((ActionImpl)action).setExecutionFailureMessage(null);
        } else {
            ((ActionImpl)action).setExecutionStatus(ActionStatus.Failed);
            ((ActionImpl)action).setExecutionFailureMessage(exception.getMessage());
        }
        String key = ActionTrackingServiceImpl.generateCacheKey(action);
        this.executingActionsCache.remove((Serializable)((Object)key));
        if (action.getNodeRef() != null) {
            final String actionId = action.getId();
            final Date startedAt = action.getExecutionStartDate();
            final Date endedAt = action.getExecutionEndDate();
            final String message = action.getExecutionFailureMessage();
            final NodeRef actionNode = action.getNodeRef();
            AlfrescoTransactionSupport.bindListener(new TransactionListenerAdapter(){

                public void afterRollback() {
                    ActionTrackingServiceImpl.this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                        @Override
                        public Object execute() throws Throwable {
                            return AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Action>(){

                                public Action doWork() throws Exception {
                                    ActionImpl action = (ActionImpl)ActionTrackingServiceImpl.this.runtimeActionService.createAction(actionNode);
                                    if (exception instanceof ActionCancelledException) {
                                        action.setExecutionStatus(ActionStatus.Cancelled);
                                        action.setExecutionFailureMessage(null);
                                    } else {
                                        action.setExecutionStatus(ActionStatus.Failed);
                                        action.setExecutionFailureMessage(exception.getMessage());
                                    }
                                    action.setExecutionStartDate(startedAt);
                                    action.setExecutionEndDate(endedAt);
                                    ActionTrackingServiceImpl.this.runtimeActionService.saveActionImpl(actionNode, action);
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("Recorded failure of action " + actionId + ", node " + actionNode + " due to " + message));
                                    }
                                    return action;
                                }
                            }, (String)"System");
                        }
                    }, false, true);
                }
            });
        }
    }

    @Override
    public boolean isCancellationRequested(CancellableAction action) {
        String key = ActionTrackingServiceImpl.generateCacheKey(action);
        ExecutionDetails details = this.getExecutionDetails(ActionTrackingServiceImpl.buildExecutionSummary(key));
        if (details == null) {
            Exception e = new Exception("Cancellation status missing from cache");
            e.fillInStackTrace();
            logger.warn((Object)("Unable to check cancellation status for running action " + action + " with execution key " + key + " as it wasn't in the running actions cache! " + "Your running actions cache is probably too small"), (Throwable)e);
            details = ActionTrackingServiceImpl.buildExecutionDetails(action);
            this.executingActionsCache.put((Serializable)((Object)key), (Object)details);
        }
        return details.isCancelRequested();
    }

    @Override
    public void requestActionCancellation(CancellableAction action) {
        this.requestActionCancellation(ActionTrackingServiceImpl.generateCacheKey(action));
    }

    @Override
    public void requestActionCancellation(ExecutionSummary executionSummary) {
        this.requestActionCancellation(ActionTrackingServiceImpl.generateCacheKey(executionSummary));
    }

    private void requestActionCancellation(String actionKey) {
        ExecutionDetails details = (ExecutionDetails)this.executingActionsCache.get((Serializable)((Object)actionKey));
        if (details == null) {
            return;
        }
        details = new ExecutionDetails(details.getExecutionSummary(), details.getPersistedActionRef(), details.getRunningOn(), details.getStartedAt(), true);
        this.executingActionsCache.put((Serializable)((Object)actionKey), (Object)details);
    }

    @Override
    public List<ExecutionSummary> getAllExecutingActions() {
        Collection actions = this.executingActionsCache.getKeys();
        ArrayList<ExecutionSummary> details = new ArrayList<ExecutionSummary>(actions.size());
        for (String key : actions) {
            details.add(ActionTrackingServiceImpl.buildExecutionSummary(key));
        }
        return details;
    }

    @Override
    public List<ExecutionSummary> getExecutingActions(Action action) {
        Collection actions = this.executingActionsCache.getKeys();
        ArrayList<ExecutionSummary> details = new ArrayList<ExecutionSummary>();
        String match = action.getActionDefinitionName() + '=' + action.getId() + '=';
        for (String key : actions) {
            if (!key.startsWith(match)) continue;
            details.add(ActionTrackingServiceImpl.buildExecutionSummary(key));
        }
        return details;
    }

    @Override
    public List<ExecutionSummary> getExecutingActions(String type) {
        Collection actions = this.executingActionsCache.getKeys();
        ArrayList<ExecutionSummary> details = new ArrayList<ExecutionSummary>();
        String match = type + '=';
        for (String key : actions) {
            if (!key.startsWith(match)) continue;
            details.add(ActionTrackingServiceImpl.buildExecutionSummary(key));
        }
        return details;
    }

    @Override
    public ExecutionDetails getExecutionDetails(ExecutionSummary executionSummary) {
        ExecutionDetails details = (ExecutionDetails)this.executingActionsCache.get((Serializable)((Object)ActionTrackingServiceImpl.generateCacheKey(executionSummary)));
        if (details != null) {
            details.setExecutionSummary(executionSummary);
        }
        return details;
    }

    protected static String generateCacheKey(Action action) {
        return action.getActionDefinitionName() + '=' + action.getId() + '=' + ((ActionImpl)action).getExecutionInstance();
    }

    protected static String generateCacheKey(ExecutionSummary summary) {
        return summary.getActionType() + '=' + summary.getActionId() + '=' + summary.getExecutionInstance();
    }

    protected static ExecutionDetails buildExecutionDetails(Action action) {
        if (machineName == null) {
            try {
                InetAddress localhost = InetAddress.getLocalHost();
                machineName = localhost.getHostAddress() + " : " + localhost.getHostName();
            }
            catch (UnknownHostException e) {
                machineName = "(machine details unavailable - server IP not known)";
            }
        }
        return new ExecutionDetails(ActionTrackingServiceImpl.buildExecutionSummary(action), action.getNodeRef(), machineName, action.getExecutionStartDate(), false);
    }

    protected static ExecutionSummary buildExecutionSummary(String key) {
        StringTokenizer st = new StringTokenizer(key, new String(new char[]{'='}));
        String actionType = st.nextToken();
        String actionId = st.nextToken();
        int executionInstance = Integer.parseInt(st.nextToken());
        return new ExecutionSummary(actionType, actionId, executionInstance);
    }

    protected static ExecutionSummary buildExecutionSummary(Action action) {
        return new ExecutionSummary(action.getActionDefinitionName(), action.getId(), ((ActionImpl)action).getExecutionInstance());
    }
}

