/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitionSimpleWorkflowActionExecuter
extends ActionExecuterAbstractBase {
    private NodeService nodeService;
    private CopyService copyService;
    private boolean isAcceptTransition = true;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setCopyService(CopyService copyService) {
        this.copyService = copyService;
    }

    public void setIsAcceptTransition(boolean value) {
        this.isAcceptTransition = value;
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
    }

    @Override
    protected void executeImpl(Action ruleAction, NodeRef actionedUponNodeRef) {
        if (this.nodeService.exists(actionedUponNodeRef) && this.nodeService.hasAspect(actionedUponNodeRef, ApplicationModel.ASPECT_SIMPLE_WORKFLOW)) {
            NodeRef destinationFolder = null;
            Boolean isMove = null;
            Map props = this.nodeService.getProperties(actionedUponNodeRef);
            if (this.isAcceptTransition) {
                destinationFolder = (NodeRef)props.get(ApplicationModel.PROP_APPROVE_FOLDER);
                isMove = (Boolean)props.get(ApplicationModel.PROP_APPROVE_MOVE);
            } else {
                destinationFolder = (NodeRef)props.get(ApplicationModel.PROP_REJECT_FOLDER);
                isMove = (Boolean)props.get(ApplicationModel.PROP_REJECT_MOVE);
            }
            if (destinationFolder == null) {
                throw new AlfrescoRuntimeException("No folder was specified for the simple workflow step.");
            }
            if (isMove == null) {
                isMove = Boolean.FALSE;
            }
            String name = (String)props.get(ContentModel.PROP_NAME);
            this.nodeService.removeAspect(actionedUponNodeRef, ApplicationModel.ASPECT_SIMPLE_WORKFLOW);
            if (Boolean.TRUE.equals(isMove)) {
                String qname = QName.createValidLocalName((String)name);
                this.nodeService.moveNode(actionedUponNodeRef, destinationFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)qname));
            } else {
                String qname = QName.createValidLocalName((String)name);
                NodeRef newNode = this.copyService.copy(actionedUponNodeRef, destinationFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)qname), true);
                this.nodeService.setProperty(newNode, ContentModel.PROP_NAME, (Serializable)((Object)name));
            }
        }
    }
}

