/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.sql.BatchUpdateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.admin.patch.PatchExecuter;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authority.UnknownAuthorityException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorityMigrationPatch
extends AbstractPatch {
    private static final String MSG_PROCESS_NAME = "patch.authorityMigration.process.name";
    private static final String MSG_WARNING_INVALID_ASSOC = "patch.authorityMigration.warning.assoc";
    private static final String MSG_SUCCESS = "patch.authorityMigration.result";
    private static Log progress_logger = LogFactory.getLog(PatchExecuter.class);
    private static final QName PROP_AUTHORITY_NAME = QName.createQName((String)"http://www.alfresco.org/model/user/1.0", (String)"authorityName");
    private static final QName PROP_AUTHORITY_DISPLAY_NAME = QName.createQName((String)"http://www.alfresco.org/model/user/1.0", (String)"authorityDisplayName");
    private static final QName PROP_MEMBERS = QName.createQName((String)"http://www.alfresco.org/model/user/1.0", (String)"members");
    private AuthorityService authorityService;
    private RuleService ruleService;
    private ImporterBootstrap userBootstrap;

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setUserBootstrap(ImporterBootstrap userBootstrap) {
        this.userBootstrap = userBootstrap;
    }

    private int retrieveAuthorities(String parentAuthority, NodeRef nodeRef, Map<String, String> authoritiesToCreate, Map<String, Set<String>> parentAssocs) {
        int assocCount = 0;
        List cars = this.nodeService.getChildAssocs(nodeRef);
        for (ChildAssociationRef car : cars) {
            Collection members;
            NodeRef current = car.getChildRef();
            String authorityName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(current, PROP_AUTHORITY_NAME));
            authoritiesToCreate.put(authorityName, (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(current, PROP_AUTHORITY_DISPLAY_NAME)));
            Set<String> parents = parentAssocs.get(authorityName);
            if (parents == null) {
                parents = new TreeSet<String>();
                parentAssocs.put(authorityName, parents);
            }
            if (parentAuthority != null) {
                parents.add(parentAuthority);
                ++assocCount;
            }
            if ((members = DefaultTypeConverter.INSTANCE.getCollection(String.class, (Object)this.nodeService.getProperty(current, PROP_MEMBERS))) != null) {
                String tenantDomain = null;
                if (this.tenantAdminService.isEnabled()) {
                    tenantDomain = this.tenantAdminService.getCurrentUserDomain();
                }
                for (String user : members) {
                    Set<String> propParents;
                    if (user == null) continue;
                    if (tenantDomain != null && !tenantDomain.equals("") && this.tenantAdminService.getUserDomain(user).equals("") && user.equals(this.tenantAdminService.getBaseNameUser(AuthenticationUtil.getAdminUserName()))) {
                        user = this.tenantAdminService.getDomainUser(user, tenantDomain);
                    }
                    if ((propParents = parentAssocs.get(user)) == null) {
                        propParents = new TreeSet<String>();
                        parentAssocs.put(user, propParents);
                    }
                    propParents.add(authorityName);
                    ++assocCount;
                }
            }
            assocCount += this.retrieveAuthorities(authorityName, current, authoritiesToCreate, parentAssocs);
        }
        return assocCount;
    }

    private void migrateAuthorities(final Map<String, String> authoritiesToCreate, Map<String, Set<String>> parentAssocs) {
        final String tenantDomain = this.tenantAdminService.getCurrentUserDomain();
        BatchProcessor.BatchProcessWorker<Map.Entry<String, Set<String>>> worker = new BatchProcessor.BatchProcessWorker<Map.Entry<String, Set<String>>>(){

            @Override
            public String getIdentifier(Map.Entry<String, Set<String>> entry) {
                return entry.getKey();
            }

            @Override
            public void beforeProcess() throws Throwable {
                AuthorityMigrationPatch.this.ruleService.disableRules();
                String systemUser = AuthenticationUtil.getSystemUserName();
                systemUser = AuthorityMigrationPatch.this.tenantAdminService.getDomainUser(systemUser, tenantDomain);
                AuthenticationUtil.setRunAsUser((String)systemUser);
            }

            @Override
            public void afterProcess() throws Throwable {
                AuthorityMigrationPatch.this.ruleService.enableRules();
                AuthenticationUtil.clearCurrentSecurityContext();
            }

            @Override
            public void process(Map.Entry<String, Set<String>> authority) throws Throwable {
                Set<Object> knownParents;
                String authorityName = authority.getKey();
                boolean existed = AuthorityMigrationPatch.this.authorityService.authorityExists(authorityName);
                if (existed) {
                    knownParents = AuthorityMigrationPatch.this.authorityService.getContainingAuthorities(AuthorityType.GROUP, authorityName, true);
                } else {
                    knownParents = Collections.emptySet();
                    AuthorityType authorityType = AuthorityType.getAuthorityType((String)authorityName);
                    if (authorityType == AuthorityType.USER) {
                        progress_logger.warn((Object)I18NUtil.getMessage((String)AuthorityMigrationPatch.MSG_WARNING_INVALID_ASSOC, (Object[])new Object[]{authorityName}));
                        return;
                    }
                    AuthorityMigrationPatch.this.authorityService.createAuthority(authorityType, AuthorityMigrationPatch.this.authorityService.getShortName(authorityName), (String)authoritiesToCreate.get(authorityName), null);
                }
                Set<String> parentAssocsToCreate = authority.getValue();
                parentAssocsToCreate.removeAll(knownParents);
                if (!parentAssocsToCreate.isEmpty()) {
                    try {
                        AuthorityMigrationPatch.this.authorityService.addAuthority(parentAssocsToCreate, authorityName);
                    }
                    catch (UnknownAuthorityException e) {
                        throw new BatchUpdateException().initCause((Throwable)((Object)e));
                    }
                }
            }
        };
        new BatchProcessor<Map.Entry<String, Set<String>>>(I18NUtil.getMessage((String)MSG_PROCESS_NAME), this.transactionService.getRetryingTransactionHelper(), parentAssocs.entrySet(), 2, 20, this.applicationEventPublisher, progress_logger, 100).process(worker, true);
    }

    private NodeRef getAuthorityContainer() {
        NodeRef rootNodeRef = this.nodeService.getRootNode(this.userBootstrap.getStoreRef());
        QName qnameAssocSystem = QName.createQName((String)"sys", (String)"system", (NamespacePrefixResolver)this.namespaceService);
        List results = this.nodeService.getChildAssocs(rootNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)qnameAssocSystem);
        NodeRef sysNodeRef = null;
        if (results.size() == 0) {
            return null;
        }
        sysNodeRef = ((ChildAssociationRef)results.get(0)).getChildRef();
        QName qnameAssocAuthorities = QName.createQName((String)"sys", (String)"authorities", (NamespacePrefixResolver)this.namespaceService);
        results = this.nodeService.getChildAssocs(sysNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)qnameAssocAuthorities);
        NodeRef authNodeRef = null;
        if (results.size() == 0) {
            return null;
        }
        authNodeRef = ((ChildAssociationRef)results.get(0)).getChildRef();
        return authNodeRef;
    }

    @Override
    protected String applyInternal() throws Exception {
        NodeRef authorityContainer = this.getAuthorityContainer();
        int authorities = 0;
        int assocs = 0;
        if (authorityContainer != null) {
            TreeMap<String, String> authoritiesToCreate = new TreeMap<String, String>();
            TreeMap<String, Set<String>> parentAssocs = new TreeMap<String, Set<String>>();
            assocs = this.retrieveAuthorities(null, authorityContainer, authoritiesToCreate, parentAssocs);
            LinkedHashMap<String, Set<String>> sortedParentAssocs = new LinkedHashMap<String, Set<String>>(parentAssocs.size() * 2);
            ArrayList<String> authorityPath = new ArrayList<String>(5);
            for (String authority : parentAssocs.keySet()) {
                authorityPath.add(authority);
                AuthorityMigrationPatch.visitGroupAssociations(authorityPath, parentAssocs, sortedParentAssocs);
                authorityPath.clear();
            }
            this.migrateAuthorities(authoritiesToCreate, sortedParentAssocs);
            authorities = authoritiesToCreate.size();
        }
        return I18NUtil.getMessage((String)MSG_SUCCESS, (Object[])new Object[]{authorities, assocs});
    }

    private static void visitGroupAssociations(List<String> authorityPath, Map<String, Set<String>> associationsOld, Map<String, Set<String>> associationsNew) {
        String authorityName = authorityPath.get(authorityPath.size() - 1);
        if (!associationsNew.containsKey(authorityName)) {
            Set<String> associations = associationsOld.get(authorityName);
            if (!associations.isEmpty()) {
                int insertIndex = authorityPath.size();
                for (String parentAuthority : associations) {
                    if (authorityPath.contains(parentAuthority)) continue;
                    authorityPath.add(parentAuthority);
                    AuthorityMigrationPatch.visitGroupAssociations(authorityPath, associationsOld, associationsNew);
                    authorityPath.remove(insertIndex);
                }
            }
            associationsNew.put(authorityName, associations);
        }
    }
}

