/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.replication;

import java.util.Date;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.AbstractContentStore;
import org.alfresco.repo.content.AbstractContentStreamListener;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentExistsException;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentStreamListener;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicatingContentStore
extends AbstractContentStore {
    private static Log logger = LogFactory.getLog(ReplicatingContentStore.class);
    private RetryingTransactionHelper transactionHelper;
    private ContentStore primaryStore;
    private List<ContentStore> secondaryStores;
    private boolean inbound = false;
    private boolean outbound = true;
    private ThreadPoolExecutor outboundThreadPoolExecutor;
    private Lock readLock;
    private Lock writeLock;

    public ReplicatingContentStore() {
        ReentrantReadWriteLock storeLock = new ReentrantReadWriteLock();
        this.readLock = storeLock.readLock();
        this.writeLock = storeLock.writeLock();
    }

    public void setTransactionService(TransactionService transactionService) {
        logger.warn((Object)"Property 'transactionService' has been replaced with 'retryingTransactionHelper'.");
    }

    public void setRetryingTransactionHelper(RetryingTransactionHelper helper) {
        this.transactionHelper = helper;
    }

    public void setPrimaryStore(ContentStore primaryStore) {
        this.primaryStore = primaryStore;
    }

    public void setSecondaryStores(List<ContentStore> secondaryStores) {
        this.secondaryStores = secondaryStores;
    }

    public void setInbound(boolean inbound) {
        this.inbound = inbound;
    }

    public void setOutbound(boolean outbound) {
        this.outbound = outbound;
    }

    public void setOutboundThreadPoolExecutor(ThreadPoolExecutor outboundThreadPoolExecutor) {
        this.outboundThreadPoolExecutor = outboundThreadPoolExecutor;
    }

    @Override
    public boolean isWriteSupported() {
        return this.primaryStore.isWriteSupported();
    }

    @Override
    public boolean isContentUrlSupported(String contentUrl) {
        return this.primaryStore.isContentUrlSupported(contentUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentReader getReader(String contentUrl) throws ContentIOException {
        ContentReader primaryContentReader;
        ContentReader existingContentReader;
        block13: {
            ContentReader secondaryContentReader;
            block12: {
                ContentReader i$;
                block11: {
                    ContentReader primaryReader;
                    block10: {
                        if (this.primaryStore == null) {
                            throw new AlfrescoRuntimeException("ReplicatingContentStore not initialised");
                        }
                        existingContentReader = null;
                        this.readLock.lock();
                        primaryReader = this.primaryStore.getReader(contentUrl);
                        if (!primaryReader.exists()) break block10;
                        ContentReader contentReader = primaryReader;
                        Object var9_6 = null;
                        this.readLock.unlock();
                        return contentReader;
                    }
                    try {
                        secondaryContentReader = null;
                        for (ContentStore store : this.secondaryStores) {
                            ContentReader reader = store.getReader(contentUrl);
                            if (!reader.exists()) continue;
                            secondaryContentReader = reader;
                            break;
                        }
                        if (secondaryContentReader != null) break block11;
                        i$ = primaryReader;
                        Object var9_7 = null;
                        this.readLock.unlock();
                        return i$;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        this.readLock.unlock();
                        throw throwable;
                    }
                }
                if (this.inbound) break block12;
                i$ = secondaryContentReader;
                Object var9_8 = null;
                this.readLock.unlock();
                return i$;
            }
            existingContentReader = secondaryContentReader;
            Object var9_9 = null;
            this.readLock.unlock();
            this.writeLock.lock();
            try {
                primaryContentReader = this.primaryStore.getReader(contentUrl);
                if (!primaryContentReader.exists()) break block13;
                secondaryContentReader = primaryContentReader;
                Object var11_15 = null;
                this.writeLock.unlock();
                return secondaryContentReader;
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }
        ContentContext ctx = new ContentContext(existingContentReader, contentUrl);
        ContentWriter primaryContentWriter = this.primaryStore.getWriter(ctx);
        primaryContentWriter.putContent(existingContentReader);
        ContentReader contentReader = primaryContentReader = primaryContentWriter.getReader();
        Object var11_16 = null;
        this.writeLock.unlock();
        return contentReader;
    }

    @Override
    public ContentWriter getWriter(ContentContext ctx) {
        ContentWriter writer = this.primaryStore.getWriter(ctx);
        if (this.outbound) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Attaching " + (this.outboundThreadPoolExecutor == null ? "" : "a") + "synchronous " + "replicating listener to local writer: \n" + "   primary store: " + this.primaryStore + "\n" + "   writer: " + writer));
            }
            ReplicatingWriteListener listener = new ReplicatingWriteListener(this.secondaryStores, writer, this.outboundThreadPoolExecutor);
            listener.setRetryingTransactionHelper(this.transactionHelper);
            writer.addListener((ContentStreamListener)listener);
        }
        return writer;
    }

    @Override
    public boolean delete(String contentUrl) throws ContentIOException {
        boolean deleted = this.primaryStore.delete(contentUrl);
        if (this.outbound) {
            for (ContentStore store : this.secondaryStores) {
                if (!store.isWriteSupported()) continue;
                store.delete(contentUrl);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Propagated content delete to " + this.secondaryStores.size() + " stores:" + contentUrl));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deleted content for URL: " + contentUrl));
        }
        return deleted;
    }

    @Override
    public void getUrls(Date createdAfter, Date createdBefore, ContentStore.ContentUrlHandler handler) throws ContentIOException {
        this.primaryStore.getUrls(createdAfter, createdBefore, handler);
        for (ContentStore secondaryStore : this.secondaryStores) {
            secondaryStore.getUrls(createdAfter, createdBefore, handler);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Iterated over content URLs: \n   created after: " + createdAfter + "\n" + "   created before: " + createdBefore));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReplicatingWriteListener
    extends AbstractContentStreamListener {
        private List<ContentStore> stores;
        private ContentWriter writer;
        private ThreadPoolExecutor threadPoolExecutor;

        public ReplicatingWriteListener(List<ContentStore> stores, ContentWriter writer, ThreadPoolExecutor threadPoolExecutor) {
            this.stores = stores;
            this.writer = writer;
            this.threadPoolExecutor = threadPoolExecutor;
        }

        @Override
        public void contentStreamClosedImpl() throws ContentIOException {
            ReplicateOnCloseRunnable runnable = new ReplicateOnCloseRunnable();
            if (this.threadPoolExecutor == null) {
                runnable.run();
            } else {
                this.threadPoolExecutor.execute(runnable);
            }
        }

        private class ReplicateOnCloseRunnable
        implements Runnable {
            private ReplicateOnCloseRunnable() {
            }

            public void run() {
                for (int i = 0; i < ReplicatingWriteListener.this.stores.size(); ++i) {
                    ContentStore store = (ContentStore)ReplicatingWriteListener.this.stores.get(i);
                    if (!store.isWriteSupported()) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Ignoring read-only store for content replication: \n   Content: " + ReplicatingWriteListener.this.writer + "\n" + "   Store:   " + store + "\n" + "   Number:  " + i));
                        continue;
                    }
                    try {
                        ContentReader reader = ReplicatingWriteListener.this.writer.getReader();
                        String contentUrl = reader.getContentUrl();
                        ContentContext ctx = new ContentContext(null, contentUrl);
                        ContentWriter replicatedWriter = store.getWriter(ctx);
                        replicatedWriter.putContent(reader);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Replicated content to store: \n   Content: " + ReplicatingWriteListener.this.writer + "\n" + "   Store:   " + store + "\n" + "   Number:  " + i));
                        continue;
                    }
                    catch (UnsupportedOperationException e) {
                        throw new ContentIOException("Unable to replicate content.  The target store doesn't support replication: \n   Content: " + ReplicatingWriteListener.this.writer + "\n" + "   Store:   " + store + "\n" + "   Number:  " + i, (Throwable)e);
                    }
                    catch (ContentExistsException e) {
                        throw new ContentIOException("Content replication failed.  The content URL already exists in the target (secondary) store: \n   Content: " + ReplicatingWriteListener.this.writer + "\n" + "   Store:   " + store + "\n" + "   Number:  " + i);
                    }
                    catch (Throwable e) {
                        throw new ContentIOException("Content replication failed: \n   Content: " + ReplicatingWriteListener.this.writer + "\n" + "   Store:   " + store + "\n" + "   Number:  " + i, e);
                    }
                }
            }
        }
    }
}

