/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ComplexContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.service.cmr.repository.TransformationOptions;

public class ComplexContentTransformerTest
extends AbstractContentTransformerTest {
    private ComplexContentTransformer transformer;
    private boolean isAvailable;

    public void setUp() throws Exception {
        super.setUp();
        ContentTransformer unoTransformer = (ContentTransformer)this.ctx.getBean("transformer.OpenOffice");
        ContentTransformer pdfBoxTransformer = (ContentTransformer)this.ctx.getBean("transformer.PdfBox");
        if (!unoTransformer.isTransformable("application/vnd.ms-powerpoint", "application/pdf", new TransformationOptions())) {
            this.isAvailable = false;
            return;
        }
        if (!pdfBoxTransformer.isTransformable("application/pdf", "text/plain", new TransformationOptions())) {
            this.isAvailable = false;
            return;
        }
        this.isAvailable = true;
        this.transformer = new ComplexContentTransformer();
        this.transformer.setMimetypeService(this.mimetypeService);
        ArrayList<ContentTransformer> transformers = new ArrayList<ContentTransformer>(2);
        transformers.add(unoTransformer);
        transformers.add(pdfBoxTransformer);
        this.transformer.setTransformers(transformers);
        List<String> intermediateMimetypes = Collections.singletonList("application/pdf");
        this.transformer.setIntermediateMimetypes(intermediateMimetypes);
    }

    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    public void testReliability() throws Exception {
        if (!this.isAvailable) {
            return;
        }
        boolean reliability = this.transformer.isTransformable("application/vnd.ms-powerpoint", "application/pdf", new TransformationOptions());
        ComplexContentTransformerTest.assertEquals((String)"Mimetype should not be supported", (boolean)false, (boolean)reliability);
        reliability = this.transformer.isTransformable("application/vnd.ms-powerpoint", "text/plain", new TransformationOptions());
        ComplexContentTransformerTest.assertEquals((String)"Mimetype should be supported", (boolean)true, (boolean)reliability);
    }
}

