/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.sf.jooreports.converter.DocumentFamily;
import net.sf.jooreports.converter.DocumentFormat;
import net.sf.jooreports.converter.DocumentFormatRegistry;
import net.sf.jooreports.converter.XmlDocumentFormatRegistry;
import net.sf.jooreports.openoffice.connection.OpenOfficeConnection;
import net.sf.jooreports.openoffice.connection.OpenOfficeException;
import net.sf.jooreports.openoffice.converter.AbstractOpenOfficeDocumentConverter;
import net.sf.jooreports.openoffice.converter.OpenOfficeDocumentConverter;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.transform.ContentTransformerWorker;
import org.alfresco.repo.content.transform.OOoContentTransformerHelper;
import org.alfresco.service.cmr.repository.ContentAccessor;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.TempFileProvider;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.DefaultResourceLoader;

public class OpenOfficeContentTransformerWorker
extends OOoContentTransformerHelper
implements ContentTransformerWorker,
InitializingBean {
    private OpenOfficeConnection connection;
    private AbstractOpenOfficeDocumentConverter converter;
    private String documentFormatsConfiguration;
    private DocumentFormatRegistry formatRegistry;

    public void setConnection(OpenOfficeConnection connection) {
        this.connection = connection;
    }

    public void setConverter(AbstractOpenOfficeDocumentConverter converter) {
        this.converter = converter;
    }

    public void setDocumentFormatsConfiguration(String path) {
        this.documentFormatsConfiguration = path;
    }

    public boolean isAvailable() {
        return this.connection.isConnected();
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)"OpenOfficeContentTransformerWorker", (String)"connection", (Object)this.connection);
        if (this.documentFormatsConfiguration != null) {
            DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
            try {
                InputStream is = resourceLoader.getResource(this.documentFormatsConfiguration).getInputStream();
                this.formatRegistry = new XmlDocumentFormatRegistry(is);
            }
            catch (IOException e) {
                throw new AlfrescoRuntimeException("Unable to load document formats configuration file: " + this.documentFormatsConfiguration);
            }
        } else {
            this.formatRegistry = new XmlDocumentFormatRegistry();
        }
        if (this.converter == null) {
            this.converter = new OpenOfficeDocumentConverter(this.connection);
        }
    }

    public boolean isTransformable(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        if (!this.isAvailable()) {
            return false;
        }
        if (this.isTransformationBlocked(sourceMimetype, targetMimetype)) {
            return false;
        }
        MimetypeService mimetypeService = this.getMimetypeService();
        String sourceExtension = mimetypeService.getExtension(sourceMimetype);
        String targetExtension = mimetypeService.getExtension(targetMimetype);
        DocumentFormat sourceFormat = this.formatRegistry.getFormatByFileExtension(sourceExtension);
        if (sourceFormat == null) {
            return false;
        }
        DocumentFormat targetFormat = this.formatRegistry.getFormatByFileExtension(targetExtension);
        if (targetFormat == null) {
            return false;
        }
        DocumentFamily sourceFamily = sourceFormat.getFamily();
        return targetFormat.isExportableFrom(sourceFamily);
    }

    public void transform(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        String sourceMimetype = this.getMimetype((ContentAccessor)reader);
        String targetMimetype = this.getMimetype((ContentAccessor)writer);
        MimetypeService mimetypeService = this.getMimetypeService();
        String sourceExtension = mimetypeService.getExtension(sourceMimetype);
        String targetExtension = mimetypeService.getExtension(targetMimetype);
        DocumentFormat sourceFormat = this.formatRegistry.getFormatByFileExtension(sourceExtension);
        if (sourceFormat == null) {
            throw new ContentIOException("No OpenOffice document format for source extension: " + sourceExtension);
        }
        DocumentFormat targetFormat = this.formatRegistry.getFormatByFileExtension(targetExtension);
        if (targetFormat == null) {
            throw new ContentIOException("No OpenOffice document format for target extension: " + targetExtension);
        }
        DocumentFamily sourceFamily = sourceFormat.getFamily();
        if (!targetFormat.isExportableFrom(sourceFamily)) {
            throw new ContentIOException("OpenOffice conversion not supported: \n   reader: " + reader + "\n" + "   writer: " + writer);
        }
        File tempFromFile = TempFileProvider.createTempFile((String)"OpenOfficeContentTransformer-source-", (String)("." + sourceExtension));
        File tempToFile = TempFileProvider.createTempFile((String)"OpenOfficeContentTransformer-target-", (String)("." + targetExtension));
        reader.getContent(tempFromFile);
        try {
            this.converter.convert(tempFromFile, sourceFormat, tempToFile, targetFormat);
        }
        catch (OpenOfficeException e) {
            throw new ContentIOException("OpenOffice server conversion failed: \n   reader: " + reader + "\n" + "   writer: " + writer + "\n" + "   from file: " + tempFromFile + "\n" + "   to file: " + tempToFile, (Throwable)e);
        }
        writer.putContent(tempToFile);
    }

    public String getVersionString() {
        return "";
    }
}

