/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform.magick;

import java.io.File;
import java.io.InputStream;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.ContentTransformerHelper;
import org.alfresco.repo.content.transform.ContentTransformerWorker;
import org.alfresco.service.cmr.repository.ContentAccessor;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractImageMagickContentTransformerWorker
extends ContentTransformerHelper
implements ContentTransformerWorker,
InitializingBean {
    public static final String MIMETYPE_IMAGE_PREFIX = "image/";
    private static final Log logger = LogFactory.getLog(AbstractImageMagickContentTransformerWorker.class);
    private boolean available = false;

    public boolean isAvailable() {
        return this.available;
    }

    protected void setAvailable(boolean available) {
        this.available = available;
    }

    public void afterPropertiesSet() {
        if (this.getMimetypeService() == null) {
            throw new AlfrescoRuntimeException("MimetypeMap not present");
        }
        try {
            String resourcePath = "org/alfresco/repo/content/transform/magick/alfresco.gif";
            InputStream imageStream = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
            if (imageStream == null) {
                throw new AlfrescoRuntimeException("Sample image not found: " + resourcePath);
            }
            File inputFile = TempFileProvider.createTempFile((String)(this.getClass().getSimpleName() + "_init_source_"), (String)".gif");
            FileContentWriter writer = new FileContentWriter(inputFile);
            writer.putContent(imageStream);
            File outputFile = TempFileProvider.createTempFile((String)(this.getClass().getSimpleName() + "_init_target_"), (String)".png");
            this.transformInternal(inputFile, outputFile, new TransformationOptions());
            if (!outputFile.exists()) {
                throw new Exception("Image conversion failed: \n   from: " + inputFile + "\n" + "   to: " + outputFile);
            }
            this.setAvailable(true);
        }
        catch (Throwable e) {
            logger.error((Object)(this.getClass().getSimpleName() + " not available: " + (e.getMessage() != null ? e.getMessage() : "")));
            logger.debug((Object)e);
        }
    }

    public static boolean isSupported(String mimetype) {
        if (mimetype.equals("application/eps")) {
            return true;
        }
        if (!mimetype.startsWith(MIMETYPE_IMAGE_PREFIX)) {
            return false;
        }
        if (mimetype.equals("image/x-rgb")) {
            return false;
        }
        return !mimetype.equals("image/svg");
    }

    public boolean isTransformable(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        if (!this.available) {
            return false;
        }
        return AbstractImageMagickContentTransformerWorker.isSupported(sourceMimetype) && AbstractImageMagickContentTransformerWorker.isSupported(targetMimetype);
    }

    public final void transform(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        String sourceMimetype = this.getMimetype((ContentAccessor)reader);
        String targetMimetype = this.getMimetype((ContentAccessor)writer);
        MimetypeService mimetypeService = this.getMimetypeService();
        String sourceExtension = mimetypeService.getExtension(sourceMimetype);
        String targetExtension = mimetypeService.getExtension(targetMimetype);
        if (sourceExtension == null || targetExtension == null) {
            throw new AlfrescoRuntimeException("Unknown extensions for mimetypes: \n   source mimetype: " + sourceMimetype + "\n" + "   source extension: " + sourceExtension + "\n" + "   target mimetype: " + targetMimetype + "\n" + "   target extension: " + targetExtension);
        }
        File sourceFile = TempFileProvider.createTempFile((String)(this.getClass().getSimpleName() + "_source_"), (String)("." + sourceExtension));
        File targetFile = TempFileProvider.createTempFile((String)(this.getClass().getSimpleName() + "_target_"), (String)("." + targetExtension));
        reader.getContent(sourceFile);
        this.transformInternal(sourceFile, targetFile, options);
        if (!targetFile.exists()) {
            throw new ContentIOException("JMagick transformation failed to write output file");
        }
        writer.putContent(targetFile);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Transformation completed: \n   source: " + reader + "\n" + "   target: " + writer + "\n" + "   options: " + options));
        }
    }

    protected abstract void transformInternal(File var1, File var2, TransformationOptions var3) throws Exception;
}

