/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.locale.ibatis;

import java.util.HashMap;
import org.alfresco.repo.domain.locale.AbstractLocaleDAOImpl;
import org.alfresco.repo.domain.locale.LocaleEntity;
import org.springframework.orm.ibatis.SqlMapClientTemplate;

public class LocaleDAOImpl
extends AbstractLocaleDAOImpl {
    private static final String SELECT_LOCALE_BY_ID = "alfresco.locale.select_LocaleById";
    private static final String SELECT_LOCALE_BY_NAME = "alfresco.locale.select_LocaleByName";
    private static final String INSERT_LOCALE = "alfresco.locale.insert_Locale";
    private SqlMapClientTemplate template;

    public void setSqlMapClientTemplate(SqlMapClientTemplate sqlMapClientTemplate) {
        this.template = sqlMapClientTemplate;
    }

    protected LocaleEntity getLocaleEntity(Long id) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", id);
        return (LocaleEntity)this.template.queryForObject(SELECT_LOCALE_BY_ID, params);
    }

    protected LocaleEntity getLocaleEntity(String localeStr) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("str", localeStr);
        return (LocaleEntity)this.template.queryForObject(SELECT_LOCALE_BY_NAME, params);
    }

    protected LocaleEntity createLocaleEntity(String localeStr) {
        LocaleEntity localeEntity = new LocaleEntity();
        localeEntity.setVersion(LocaleEntity.CONST_LONG_ZERO);
        localeEntity.setLocaleStr(localeStr);
        Long id = (Long)this.template.insert(INSERT_LOCALE, (Object)localeEntity);
        localeEntity.setId(id);
        return localeEntity;
    }
}

