/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.repo.forms.Form;
import org.alfresco.repo.forms.Item;
import org.alfresco.repo.forms.processor.FormProcessor;
import org.alfresco.repo.forms.processor.FormProcessorRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractFormProcessor
implements FormProcessor {
    private static final Log logger = LogFactory.getLog(AbstractFormProcessor.class);
    protected FormProcessorRegistry processorRegistry;
    protected String matchPattern;
    protected boolean active = true;
    protected Pattern patternMatcher;

    public void setProcessorRegistry(FormProcessorRegistry processorRegistry) {
        this.processorRegistry = processorRegistry;
    }

    public void setMatchPattern(String pattern) {
        this.matchPattern = pattern;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void register() {
        if (this.processorRegistry == null) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Property 'processorRegistry' has not been set.  Ignoring auto-registration of processor: " + this));
            }
            return;
        }
        if (this.matchPattern == null) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Property 'matchPattern' has not been set.  Ignoring auto-registration of processor: " + this));
            }
            return;
        }
        this.patternMatcher = Pattern.compile(this.matchPattern);
        this.processorRegistry.addProcessor(this);
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isApplicable(Item item) {
        Matcher matcher = this.patternMatcher.matcher(item.getKind());
        boolean matches = matcher.matches();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Checking processor " + this + " for applicability for item '" + item + "', result = " + matches));
        }
        return matches;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(super.toString());
        buffer.append(" (");
        buffer.append("active=").append(this.active);
        buffer.append(", matchPattern=").append(this.matchPattern);
        buffer.append(")");
        return buffer.toString();
    }

    protected void setFormItemType(Form form, String type) {
        form.getItem().setType(type);
    }

    protected void setFormItemUrl(Form form, String url) {
        form.getItem().setUrl(url);
    }
}

