/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.script;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.forms.FieldDefinition;
import org.alfresco.repo.forms.Form;
import org.alfresco.repo.forms.script.ScriptFormData;

public class ScriptForm
implements Serializable {
    private static final long serialVersionUID = 579853076546002023L;
    private Form form;
    private Map<String, FieldDefinition> fieldDefinitionData;

    ScriptForm(Form formObject) {
        this.form = formObject;
        this.fieldDefinitionData = new HashMap<String, FieldDefinition>();
        List<FieldDefinition> fieldDefs = this.form.getFieldDefinitions();
        if (fieldDefs != null) {
            for (FieldDefinition fd : fieldDefs) {
                this.fieldDefinitionData.put(fd.getName(), fd);
            }
        }
    }

    public String getItemKind() {
        return this.form.getItem().getKind();
    }

    public String getItemId() {
        return this.form.getItem().getId();
    }

    public String getItemType() {
        return this.form.getItem().getType();
    }

    public String getItemUrl() {
        return this.form.getItem().getUrl();
    }

    public String getSubmissionUrl() {
        return this.form.getSubmissionUrl();
    }

    public FieldDefinition[] getFieldDefinitions() {
        List<FieldDefinition> fieldDefs = this.form.getFieldDefinitions();
        if (fieldDefs == null) {
            fieldDefs = Collections.emptyList();
        }
        return fieldDefs.toArray(new FieldDefinition[fieldDefs.size()]);
    }

    public ScriptFormData getFormData() {
        return new ScriptFormData(this.form.getFormData());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ScriptForm:").append(this.form.getItem());
        return builder.toString();
    }
}

