/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.imap.ImapService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMimeMessage
extends MimeMessage {
    protected static final String DEFAULT_EMAIL_FROM = "alfresco@alfresco.org";
    protected static final String DEFAULT_EMAIL_TO = "alfresco@alfresco.org";
    protected static int MAX_RETRIES = 1;
    private Log logger = LogFactory.getLog(AbstractMimeMessage.class);
    protected boolean generateBody = true;
    protected ServiceRegistry serviceRegistry;
    protected ImapService imapService;
    protected FileInfo messageFileInfo;
    protected MimeMessage wrappedMessage;

    protected AbstractMimeMessage(Session session) {
        super(session);
    }

    protected AbstractMimeMessage(FileInfo fileInfo, ServiceRegistry serviceRegistry, boolean generateBody) throws MessagingException {
        super(Session.getDefaultInstance((Properties)new Properties()));
        this.generateBody = generateBody;
        this.buildMessage(fileInfo, serviceRegistry);
    }

    protected void buildMessage(FileInfo fileInfo, ServiceRegistry serviceRegistry) throws MessagingException {
        this.checkParameter(serviceRegistry, "ServiceRegistry");
        this.content = null;
        this.serviceRegistry = serviceRegistry;
        this.imapService = serviceRegistry.getImapService();
        this.messageFileInfo = fileInfo;
        RetryingTransactionHelper txHelper = serviceRegistry.getTransactionService().getRetryingTransactionHelper();
        txHelper.setMaxRetries(MAX_RETRIES);
        txHelper.setReadOnly(false);
        txHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                AbstractMimeMessage.this.buildMessageInternal();
                return null;
            }
        }, false);
    }

    public abstract void buildMessageInternal() throws MessagingException;

    protected void checkParameter(Object parameter, String name) {
        if (parameter == null) {
            throw new IllegalArgumentException(name + " parameter is null.");
        }
    }

    protected void setMessageHeaders() throws MessagingException {
        this.setHeader("MIME-Version", "1.0");
        this.setHeader("X-Alfresco-NodeRef-ID", this.messageFileInfo.getNodeRef().getId());
    }

    protected InternetAddress[] buildSenderFromAddress() throws AddressException {
        InternetAddress[] addressList;
        block4: {
            addressList = null;
            Map<QName, Serializable> properties = this.messageFileInfo.getProperties();
            String prop = (String)((Object)properties.get(ContentModel.PROP_AUTHOR));
            String defaultFromAddress = this.imapService.getDefaultFromAddress();
            defaultFromAddress = defaultFromAddress == null ? "alfresco@alfresco.org" : defaultFromAddress;
            try {
                if (prop != null) {
                    StringBuilder contentAuthor = new StringBuilder();
                    contentAuthor.append("\"").append(prop).append("\" <").append(defaultFromAddress).append(">");
                    addressList = InternetAddress.parse((String)contentAuthor.toString());
                    break block4;
                }
                prop = (String)((Object)properties.get(ContentModel.PROP_CREATOR));
                if (prop != null) {
                    StringBuilder creator = new StringBuilder();
                    creator.append("\"").append(prop).append("\" <").append(defaultFromAddress).append(">");
                    addressList = InternetAddress.parse((String)creator.toString());
                    break block4;
                }
                throw new AddressException(I18NUtil.getMessage((String)"imap.server.error.properties_dont_exist"));
            }
            catch (AddressException e) {
                addressList = InternetAddress.parse((String)"alfresco@alfresco.org");
            }
        }
        return addressList;
    }

    public FileInfo getMessageInfo() {
        return this.messageFileInfo;
    }

    public Flags getFlags() {
        return this.imapService.getFlags(this.messageFileInfo);
    }

    public void setFlags(Flags flags, boolean value) throws MessagingException {
        this.imapService.setFlags(this.messageFileInfo, flags, value);
    }

    public String getEmailBodyText(ImapService.EmailBodyType type) {
        return this.serviceRegistry.getTemplateService().processTemplate(this.imapService.getDefaultEmailBodyTemplate(type), this.createEmailTemplateModel(this.messageFileInfo.getNodeRef()));
    }

    protected InternetAddress[] buildRecipientToAddress() throws AddressException {
        InternetAddress[] result = null;
        String defaultEmailTo = null;
        String escapedUserName = AuthenticationUtil.getFullyAuthenticatedUser().replaceAll("[/,\\,@]", ".");
        String userDomain = "alfresco@alfresco.org".split("@")[1];
        defaultEmailTo = escapedUserName + "@" + userDomain;
        try {
            result = InternetAddress.parse((String)defaultEmailTo);
        }
        catch (AddressException e) {
            this.logger.error((Object)String.format("Wrong email address '%s'.", defaultEmailTo), (Throwable)e);
            result = InternetAddress.parse((String)"alfresco@alfresco.org");
        }
        return result;
    }

    protected void addFromInternal(String addressesString) throws MessagingException {
        if (addressesString != null) {
            this.addFrom((Address[])InternetAddress.parse((String)addressesString));
        } else {
            this.addFrom(new Address[]{new InternetAddress("alfresco@alfresco.org")});
        }
    }

    private Map<String, Object> createEmailTemplateModel(NodeRef ref) {
        HashMap<String, Object> model = new HashMap<String, Object>(8, 1.0f);
        TemplateNode tn = new TemplateNode(ref, this.serviceRegistry, null);
        model.put("document", tn);
        NodeRef parent = this.serviceRegistry.getNodeService().getPrimaryParent(ref).getParentRef();
        model.put("space", new TemplateNode(parent, this.serviceRegistry, null));
        model.put("date", new Date());
        model.put("contextUrl", new String(this.imapService.getWebApplicationContextUrl()));
        model.put("alfTicket", new String(this.serviceRegistry.getAuthenticationService().getCurrentTicket()));
        return model;
    }

    protected void updateMessageID() throws MessagingException {
        this.setHeader("Message-ID", this.messageFileInfo.getNodeRef().getId());
    }
}

