/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.importer.view;

import java.util.HashSet;
import java.util.Map;
import org.alfresco.repo.importer.ImportParent;
import org.alfresco.repo.importer.Importer;
import org.alfresco.repo.importer.view.ElementContext;
import org.alfresco.repo.importer.view.NodeContext;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.view.ImporterException;
import org.alfresco.service.namespace.QName;

public class ParentContext
extends ElementContext
implements ImportParent {
    private NodeRef parentRef;
    private QName assocType;

    public ParentContext(QName elementName, DictionaryService dictionary, Importer importer) {
        super(elementName, dictionary, importer);
        this.parentRef = importer.getRootRef();
        this.assocType = importer.getRootAssocType();
    }

    public ParentContext(QName elementName, NodeContext parent) {
        super(elementName, parent.getDictionaryService(), parent.getImporter());
        this.parentRef = parent.getNodeRef();
    }

    public ParentContext(QName elementName, NodeContext parent, AssociationDefinition assocDef) {
        this(elementName, parent);
        TypeDefinition typeDef = parent.getTypeDefinition();
        if (typeDef != null) {
            HashSet<QName> allAspects = new HashSet<QName>();
            for (AspectDefinition typeAspect : parent.getTypeDefinition().getDefaultAspects()) {
                allAspects.add(typeAspect.getName());
            }
            allAspects.addAll(parent.getNodeAspects());
            TypeDefinition anonymousType = this.getDictionaryService().getAnonymousType(parent.getTypeDefinition().getName(), allAspects);
            Map nodeAssociations = anonymousType.getAssociations();
            if (!nodeAssociations.containsKey(assocDef.getName())) {
                throw new ImporterException("Association " + assocDef.getName() + " is not valid for node " + parent.getTypeDefinition().getName());
            }
        }
        this.parentRef = parent.getNodeRef();
        this.assocType = assocDef.getName();
    }

    public NodeRef getParentRef() {
        return this.parentRef;
    }

    public void setParentRef(NodeRef parentRef) {
        this.parentRef = parentRef;
    }

    public QName getAssocType() {
        return this.assocType;
    }

    public void setAssocType(QName assocType) {
        this.assocType = assocType;
    }

    public String toString() {
        return "ParentContext[parent=" + this.parentRef + ",assocType=" + this.getAssocType() + "]";
    }
}

