/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder.loader;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.EhCacheAdapter;
import org.alfresco.repo.model.filefolder.loader.LoaderClientException;
import org.alfresco.repo.model.filefolder.loader.LoaderServerProxy;
import org.alfresco.repo.model.filefolder.loader.LoaderSession;
import org.alfresco.repo.model.filefolder.loader.LoaderUploadThread;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLoaderThread
extends Thread {
    protected final LoaderSession session;
    protected final String loaderName;
    protected final long testPeriod;
    protected final long testTotal;
    protected final long testLoadDepth;
    protected final boolean verbose;
    private AtomicBoolean mustStop;
    private Random random;
    private int statCount;
    private double statTotalMs;
    private static EhCacheAdapter<String, NodeRef> pathCache;

    public AbstractLoaderThread(LoaderSession session, String loaderName, long testPeriod, long testTotal, long testLoadDepth, boolean verbose) {
        super(LoaderSession.THREAD_GROUP, "LoaderThread-" + loaderName);
        this.session = session;
        this.loaderName = loaderName;
        this.testPeriod = testPeriod;
        this.testTotal = testTotal < 1L ? Integer.MAX_VALUE : testTotal;
        this.testLoadDepth = testLoadDepth;
        this.verbose = verbose;
        this.mustStop = new AtomicBoolean(false);
        this.random = new Random();
        this.statCount = 0;
        this.statTotalMs = 0.0;
        if (this.testLoadDepth < 1L || this.testLoadDepth > (long)this.session.getFolderProfiles().length) {
            throw new AlfrescoRuntimeException("The load depth must be [1," + this.session.getFolderProfiles().length);
        }
    }

    public void setStop() {
        this.mustStop.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int testCount = 0;
        while (!this.mustStop.get()) {
            try {
                int serverCount = this.session.getRemoteServers().size();
                int serverIndex = this.random.nextInt(serverCount);
                LoaderServerProxy serverProxy = this.session.getRemoteServers().get(serverIndex);
                int nodeCount = this.session.getWorkingRootNodeRefs().size();
                int nodeIndex = this.random.nextInt(nodeCount);
                NodeRef workingRootNodeRef = this.session.getWorkingRootNodeRefs().get(nodeIndex);
                this.doBefore(serverProxy, workingRootNodeRef);
                long startTime = System.nanoTime();
                String msg = this.doLoading(serverProxy, workingRootNodeRef);
                long endTime = System.nanoTime();
                this.updateStats(startTime, endTime);
                this.logVerbose(startTime, endTime, msg);
                if ((long)(++testCount) > this.testTotal) break;
                long duration = endTime - startTime;
                long mustWait = this.testPeriod - (long)((double)duration / 1000.0 / 1000.0);
                if (mustWait >= 5L) {
                    AbstractLoaderThread abstractLoaderThread = this;
                    synchronized (abstractLoaderThread) {
                        this.wait(mustWait);
                    }
                }
                this.doAfter(serverProxy, workingRootNodeRef);
            }
            catch (Throwable e) {
                this.session.logError("Loading error on '" + this.loaderName + "': " + e.getMessage(), e);
            }
        }
    }

    private synchronized void updateStats(long startTime, long endTime) {
        ++this.statCount;
        double delta = (double)(endTime - startTime) / 1000.0 / 1000.0;
        this.statTotalMs += delta;
    }

    private void logVerbose(long startTime, long endTime, String msg) {
        double delta = (double)(endTime - startTime) / 1000.0 / 1000.0 / 1000.0;
        double statTotalSec = this.statTotalMs / 1000.0;
        double statPerSec = (double)this.statCount / statTotalSec;
        double statAveSec = statTotalSec / (double)this.statCount;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%40s", this.loaderName)).append("\t").append(String.format("%15.0f", Float.valueOf(this.statCount))).append("\t").append(String.format("%15.3f", delta)).append("\t").append(String.format("%15.3f", statPerSec)).append("\t").append(String.format("%15.3f", statAveSec)).append("\t").append(msg);
        this.session.logVerbose(sb.toString(), this.verbose);
    }

    public String getSummary() {
        double statTotalSec = this.statTotalMs / 1000.0;
        double statPerSec = (double)this.statCount / statTotalSec;
        double statAveSec = statTotalSec / (double)this.statCount;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%40s", this.loaderName)).append("\t").append(String.format("%15.0f", Float.valueOf(this.statCount))).append("\t").append(String.format("%15.3f", statTotalSec)).append("\t").append(String.format("%15.3f", statAveSec)).append("\t").append(String.format("%15.3f", statPerSec)).append("\t").append("");
        return sb.toString();
    }

    protected abstract String doLoading(LoaderServerProxy var1, NodeRef var2) throws Exception;

    protected List<String> chooseFolderPath() {
        int[] folderProfiles = this.session.getFolderProfiles();
        ArrayList<String> path = new ArrayList<String>((int)this.testLoadDepth);
        int i = 1;
        while ((long)i < this.testLoadDepth) {
            int folderProfile = folderProfiles[i];
            int randomFolderId = this.random.nextInt(folderProfile);
            String name = String.format("folder-%05d", randomFolderId);
            path.add(name);
            ++i;
        }
        return path;
    }

    protected File getFile() throws Exception {
        File[] files = this.session.getSourceFiles();
        File file = files[this.random.nextInt(files.length)];
        if (!file.exists() || file.isDirectory()) {
            throw new LoaderClientException("Cannot find loading file: " + file);
        }
        return file;
    }

    protected NodeRef makeFolders(String ticket, LoaderServerProxy serverProxy, NodeRef workingRootNodeRef, List<String> folderPath) throws Exception {
        NodeRef currentParentNodeRef = workingRootNodeRef;
        String currentKey = workingRootNodeRef.toString();
        for (String aFolderPath : folderPath) {
            NodeRef nodeRef = pathCache.get(currentKey = currentKey + "/" + aFolderPath);
            if (nodeRef != null) {
                currentParentNodeRef = nodeRef;
                continue;
            }
            try {
                FileInfo folderInfo = serverProxy.fileFolderRemote.makeFolders(serverProxy.ticket, currentParentNodeRef, Collections.singletonList(aFolderPath), ContentModel.TYPE_FOLDER);
                currentParentNodeRef = folderInfo.getNodeRef();
            }
            catch (FileExistsException e) {
                currentParentNodeRef = pathCache.get(currentKey);
            }
            pathCache.put(currentKey, currentParentNodeRef);
        }
        return currentParentNodeRef;
    }

    protected void doBefore(LoaderServerProxy loaderServerProxy, NodeRef nodeRef) throws Exception {
    }

    protected void doAfter(LoaderServerProxy loaderServerProxy, NodeRef nodeRef) throws Exception {
    }

    static {
        System.setProperty("net.sf.ehcache.enableShutdownHook", "TRUE");
        URL url = LoaderUploadThread.class.getResource("/org/alfresco/repo/model/filefolder/loader/loader-ehcache.xml");
        CacheManager cacheManager = CacheManager.create((URL)url);
        Cache cache = cacheManager.getCache("org.alfresco.LoaderUploadThread.PathCache");
        pathCache = new EhCacheAdapter();
        pathCache.setCache(cache);
    }
}

