/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.ml;

import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MLContainerType
implements NodeServicePolicies.OnUpdatePropertiesPolicy {
    private PolicyComponent policyComponent;
    private NodeService nodeService;
    private MultilingualContentService multilingualContentService;

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateProperties"), ContentModel.TYPE_MULTILINGUAL_CONTAINER, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setMultilingualContentService(MultilingualContentService multilingualContentService) {
        this.multilingualContentService = multilingualContentService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        Locale localeAfter = (Locale)after.get(ContentModel.PROP_LOCALE);
        Locale localeBefore = (Locale)before.get(ContentModel.PROP_LOCALE);
        if (localeAfter == null && this.nodeService.getChildAssocs(nodeRef).size() != 0) {
            throw new IllegalArgumentException("A Locale property must be defined for a Multilingual Container and can't be null");
        }
        if (localeAfter != null && !localeAfter.equals(localeBefore)) {
            Map<Locale, NodeRef> translations = this.multilingualContentService.getTranslations(nodeRef);
            NodeRef pivot = translations.get(localeAfter);
            if (pivot == null) {
                throw new IllegalArgumentException("The pivot translation must be an existing translation");
            }
            if (this.nodeService.hasAspect(pivot, ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION)) {
                throw new IllegalArgumentException("The pivot translation can't be an empty translation");
            }
        }
    }
}

