/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module.tool;

import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.FileOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.module.tool.ModuleManagementTool;
import org.alfresco.repo.module.tool.ModuleManagementToolException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstalledFiles {
    private static final String MOD_ADD_FILE = "add";
    private static final String MOD_UPDATE_FILE = "update";
    private static final String MOD_MK_DIR = "mkdir";
    private static final String DELIMITER = "|";
    private String warLocation;
    private String moduleId;
    private List<String> adds = new ArrayList<String>();
    private Map<String, String> updates = new HashMap<String, String>();
    private List<String> mkdirs = new ArrayList<String>();

    public InstalledFiles(String warLocation, String moduleId) {
        this.warLocation = warLocation;
        this.moduleId = moduleId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        de.schlichtherle.io.File file = new de.schlichtherle.io.File(this.getFileLocation(), ModuleManagementTool.DETECTOR_AMP_AND_WAR);
        if (file.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)file)));
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        String[] modification = line.split("\\|");
                        String mod = modification[0];
                        String location = modification[1];
                        if (mod.equals(MOD_ADD_FILE)) {
                            this.adds.add(location);
                        } else if (mod.equals(MOD_MK_DIR)) {
                            this.mkdirs.add(location);
                        } else if (mod.equals(MOD_UPDATE_FILE)) {
                            this.updates.put(location, modification[2]);
                        }
                        line = reader.readLine();
                    }
                    Object var8_9 = null;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    reader.close();
                    throw throwable;
                }
                reader.close();
                {
                }
            }
            catch (FileNotFoundException exception) {
                throw new ModuleManagementToolException("The module file install file '" + this.getFileLocation() + "' does not exist", exception);
            }
            catch (IOException exception) {
                throw new ModuleManagementToolException("Error whilst reading file '" + this.getFileLocation(), exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        try {
            de.schlichtherle.io.File file = new de.schlichtherle.io.File(this.getFileLocation(), ModuleManagementTool.DETECTOR_AMP_AND_WAR);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream os = new FileOutputStream((File)file);
            try {
                String output;
                for (String string : this.adds) {
                    output = "add|" + string + "\n";
                    os.write(output.getBytes());
                }
                for (Map.Entry entry : this.updates.entrySet()) {
                    output = "update|" + (String)entry.getKey() + DELIMITER + (String)entry.getValue() + "\n";
                    os.write(output.getBytes());
                }
                for (String string : this.mkdirs) {
                    output = "mkdir|" + string + "\n";
                    os.write(output.getBytes());
                }
                Object var7_11 = null;
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                os.close();
                throw throwable;
            }
            os.close();
            {
            }
        }
        catch (IOException exception) {
            throw new ModuleManagementToolException("Error whilst saving modifications file.", exception);
        }
    }

    public String getFileLocation() {
        return this.warLocation + this.getFilePathInWar();
    }

    public String getFilePathInWar() {
        return "/WEB-INF/classes/alfresco/module/" + this.moduleId + "/modifications.install";
    }

    public List<String> getAdds() {
        return this.adds;
    }

    public Map<String, String> getUpdates() {
        return this.updates;
    }

    public List<String> getMkdirs() {
        return this.mkdirs;
    }

    public void addAdd(String location) {
        this.adds.add(location);
    }

    public void addUpdate(String location, String backup) {
        this.updates.put(location, backup);
    }

    public void addMkdir(String location) {
        this.mkdirs.add(location);
    }
}

