/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MLPropertyInterceptor
implements MethodInterceptor {
    private static Log logger = LogFactory.getLog(MLPropertyInterceptor.class);
    private static ThreadLocal<Boolean> mlAware = new ThreadLocal();
    private NodeService nodeService;
    private MultilingualContentService multilingualContentService;
    private DictionaryService dictionaryService;

    public static boolean setMLAware(boolean mlAwareVal) {
        boolean wasMLAware = MLPropertyInterceptor.isMLAware();
        mlAware.set(mlAwareVal);
        return wasMLAware;
    }

    public static boolean isMLAware() {
        if (mlAware.get() == null) {
            return false;
        }
        return mlAware.get();
    }

    public void setNodeService(NodeService bean) {
        this.nodeService = bean;
    }

    public void setMultilingualContentService(MultilingualContentService multilingualContentService) {
        this.multilingualContentService = multilingualContentService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Intercepting method " + invocation.getMethod().getName() + " using content filter " + I18NUtil.getContentLocale()));
        }
        if (MLPropertyInterceptor.isMLAware()) {
            return invocation.proceed();
        }
        ChildAssociationRef ret = null;
        String methodName = invocation.getMethod().getName();
        Object[] args = invocation.getArguments();
        Locale contentLocale = I18NUtil.getContentLocale();
        if (methodName.equals("getProperty")) {
            NodeRef nodeRef = (NodeRef)args[0];
            QName propertyQName = (QName)args[1];
            NodeRef pivotNodeRef = this.getPivotNodeRef(nodeRef);
            Serializable value = (Serializable)invocation.proceed();
            ret = this.convertOutboundProperty(contentLocale, nodeRef, pivotNodeRef, propertyQName, value);
        } else if (methodName.equals("getProperties")) {
            NodeRef nodeRef = (NodeRef)args[0];
            NodeRef pivotNodeRef = this.getPivotNodeRef(nodeRef);
            Map properties = (Map)invocation.proceed();
            ChildAssociationRef convertedProperties = new HashMap(properties.size() * 2);
            for (Map.Entry entry : properties.entrySet()) {
                QName propertyQName = (QName)entry.getKey();
                Serializable value = (Serializable)entry.getValue();
                Serializable convertedValue = this.convertOutboundProperty(contentLocale, nodeRef, pivotNodeRef, propertyQName, value);
                convertedProperties.put(propertyQName, convertedValue);
            }
            ret = convertedProperties;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Converted getProperties return value: \n   initial:   " + properties + "\n" + "   converted: " + convertedProperties));
            }
        } else if (methodName.equals("setProperties")) {
            NodeRef nodeRef = (NodeRef)args[0];
            Map newProperties = (Map)args[1];
            NodeRef pivotNodeRef = this.getPivotNodeRef(nodeRef);
            Map currentProperties = this.nodeService.getProperties(nodeRef);
            Map<QName, Serializable> convertedProperties = this.convertInboundProperties(currentProperties, newProperties, contentLocale, nodeRef, pivotNodeRef);
            this.nodeService.setProperties(nodeRef, convertedProperties);
        } else if (methodName.equals("addProperties")) {
            NodeRef nodeRef = (NodeRef)args[0];
            Map newProperties = (Map)args[1];
            NodeRef pivotNodeRef = this.getPivotNodeRef(nodeRef);
            Map currentProperties = this.nodeService.getProperties(nodeRef);
            Map<QName, Serializable> convertedProperties = this.convertInboundProperties(currentProperties, newProperties, contentLocale, nodeRef, pivotNodeRef);
            this.nodeService.addProperties(nodeRef, convertedProperties);
        } else if (methodName.equals("setProperty")) {
            NodeRef nodeRef = (NodeRef)args[0];
            QName propertyQName = (QName)args[1];
            Serializable inboundValue = (Serializable)args[2];
            NodeRef pivotNodeRef = this.getPivotNodeRef(nodeRef);
            inboundValue = this.convertInboundProperty(contentLocale, nodeRef, pivotNodeRef, propertyQName, inboundValue, null);
            this.nodeService.setProperty(nodeRef, propertyQName, inboundValue);
        } else if (methodName.equals("createNode") && args.length > 4) {
            NodeRef parentNodeRef = (NodeRef)args[0];
            QName assocTypeQName = (QName)args[1];
            QName assocQName = (QName)args[2];
            QName nodeTypeQName = (QName)args[3];
            Map<QName, Serializable> newProperties = (Map<QName, Serializable>)args[4];
            if (newProperties == null) {
                newProperties = Collections.emptyMap();
            }
            NodeRef nodeRef = null;
            NodeRef pivotNodeRef = null;
            Map<QName, Serializable> convertedProperties = this.convertInboundProperties(null, newProperties, contentLocale, nodeRef, pivotNodeRef);
            ret = this.nodeService.createNode(parentNodeRef, assocTypeQName, assocQName, nodeTypeQName, convertedProperties);
        } else if (methodName.equals("addAspect") && args[2] != null) {
            NodeRef nodeRef = (NodeRef)args[0];
            QName aspectTypeQName = (QName)args[1];
            NodeRef pivotNodeRef = this.getPivotNodeRef(nodeRef);
            Map newProperties = (Map)args[2];
            Map currentProperties = this.nodeService.getProperties(nodeRef);
            Map<QName, Serializable> convertedProperties = this.convertInboundProperties(currentProperties, newProperties, contentLocale, nodeRef, pivotNodeRef);
            this.nodeService.addAspect(nodeRef, aspectTypeQName, convertedProperties);
        } else {
            ret = invocation.proceed();
        }
        return ret;
    }

    private NodeRef getPivotNodeRef(NodeRef nodeRef) {
        if (nodeRef == null) {
            throw new IllegalArgumentException("NodeRef may not be null for calls to NodeService.  Check client code.");
        }
        if (!nodeRef.getStoreRef().getProtocol().equals("avm") && this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION)) {
            return this.multilingualContentService.getPivotTranslation(nodeRef);
        }
        return null;
    }

    private Serializable convertOutboundProperty(Locale contentLocale, NodeRef nodeRef, NodeRef pivotNodeRef, QName propertyQName, Serializable outboundValue) {
        Serializable ret = null;
        if (outboundValue == null) {
            ret = null;
        }
        if (outboundValue instanceof MLText) {
            MLText mlText = (MLText)outboundValue;
            ret = mlText.getClosestValue(contentLocale);
        } else if (this.isCollectionOfMLText(outboundValue)) {
            Collection col = (Collection)((Object)outboundValue);
            ArrayList<String> answer = new ArrayList<String>(col.size());
            Locale closestLocale = this.getClosestLocale(col, contentLocale);
            for (Object o : col) {
                MLText mlText = (MLText)o;
                String value = (String)mlText.get((Object)closestLocale);
                if (value == null) continue;
                answer.add(value);
            }
            ret = answer;
        } else {
            Date pivotLastModified;
            Date emptyLastModified;
            ret = pivotNodeRef != null ? (propertyQName.equals((Object)ContentModel.PROP_MODIFIED) ? ((emptyLastModified = (Date)outboundValue).compareTo(pivotLastModified = (Date)this.nodeService.getProperty(pivotNodeRef, ContentModel.PROP_MODIFIED)) < 0 ? pivotLastModified : emptyLastModified) : (propertyQName.equals((Object)ContentModel.PROP_CONTENT) ? this.nodeService.getProperty(pivotNodeRef, ContentModel.PROP_CONTENT) : outboundValue)) : outboundValue;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Converted outbound property: \n   NodeRef:        " + nodeRef + "\n" + "   Property:       " + propertyQName + "\n" + "   Before:         " + outboundValue + "\n" + "   After:          " + ret));
        }
        return ret;
    }

    public Locale getClosestLocale(Collection<?> collection, Locale locale) {
        if (collection.size() == 0) {
            return null;
        }
        HashSet locales = new HashSet();
        for (Object o : collection) {
            MLText mlText = (MLText)o;
            locales.addAll(mlText.keySet());
        }
        Locale match = I18NUtil.getNearestLocale((Locale)locale, locales);
        if (match == null && (match = I18NUtil.getNearestLocale((Locale)(locale = I18NUtil.getLocale()), locales)) == null) {
            match = I18NUtil.getNearestLocale(null, locales);
        }
        return match;
    }

    private boolean isCollectionOfMLText(Serializable outboundValue) {
        if (outboundValue instanceof Collection) {
            for (Object o : (Collection)((Object)outboundValue)) {
                if (o instanceof MLText) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Map<QName, Serializable> convertInboundProperties(Map<QName, Serializable> currentProperties, Map<QName, Serializable> newProperties, Locale contentLocale, NodeRef nodeRef, NodeRef pivotNodeRef) {
        HashMap<QName, Serializable> convertedProperties = new HashMap<QName, Serializable>(newProperties.size() * 2);
        for (Map.Entry<QName, Serializable> entry : newProperties.entrySet()) {
            QName propertyQName = entry.getKey();
            Serializable inboundValue = entry.getValue();
            Serializable currentValue = currentProperties == null ? null : currentProperties.get(propertyQName);
            inboundValue = this.convertInboundProperty(contentLocale, nodeRef, pivotNodeRef, propertyQName, inboundValue, currentValue);
            convertedProperties.put(propertyQName, inboundValue);
        }
        return convertedProperties;
    }

    private Serializable convertInboundProperty(Locale contentLocale, NodeRef nodeRef, NodeRef pivotNodeRef, QName propertyQName, Serializable inboundValue, Serializable currentValue) {
        ArrayList<Object> ret = null;
        PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyQName);
        if (propertyDef == null) {
            ret = inboundValue;
        } else if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.MLTEXT)) {
            if (inboundValue instanceof MLText) {
                ret = inboundValue;
            } else if (propertyDef.isMultiValued()) {
                if (this.isCollectionOfMLText(inboundValue)) {
                    ret = inboundValue;
                } else {
                    MLText newMLValue;
                    if (currentValue == null && nodeRef != null) {
                        currentValue = this.nodeService.getProperty(nodeRef, propertyQName);
                    }
                    ArrayList<MLText> returnMLList = new ArrayList<MLText>();
                    if (currentValue != null) {
                        Collection currentCollection = DefaultTypeConverter.INSTANCE.getCollection(MLText.class, (Object)currentValue);
                        returnMLList.addAll(currentCollection);
                    }
                    Collection inboundCollection = DefaultTypeConverter.INSTANCE.getCollection(String.class, (Object)inboundValue);
                    int count = 0;
                    for (String current : inboundCollection) {
                        if (count < returnMLList.size()) {
                            MLText currentMLValue = (MLText)returnMLList.get(count);
                            newMLValue = new MLText();
                            if (currentMLValue != null) {
                                newMLValue.putAll((Map)currentMLValue);
                            }
                        } else {
                            newMLValue = new MLText();
                        }
                        newMLValue.addValue(contentLocale, current);
                        if (count < returnMLList.size()) {
                            returnMLList.set(count, newMLValue);
                        } else {
                            returnMLList.add(newMLValue);
                        }
                        ++count;
                    }
                    for (int i = count; i < returnMLList.size(); ++i) {
                        MLText currentMLValue = (MLText)returnMLList.get(i);
                        newMLValue = new MLText();
                        if (currentMLValue != null) {
                            newMLValue.putAll((Map)currentMLValue);
                        }
                        newMLValue.remove((Object)contentLocale);
                        returnMLList.set(i, newMLValue);
                    }
                    ArrayList<MLText> tidy = new ArrayList<MLText>();
                    for (MLText mlText : returnMLList) {
                        if (mlText.keySet().size() <= 0) continue;
                        tidy.add(mlText);
                    }
                    ret = tidy;
                }
            } else {
                if (currentValue == null && nodeRef != null) {
                    currentValue = this.nodeService.getProperty(nodeRef, propertyQName);
                }
                MLText returnMLValue = new MLText();
                if (currentValue != null) {
                    MLText currentMLValue = (MLText)DefaultTypeConverter.INSTANCE.convert(MLText.class, (Object)currentValue);
                    returnMLValue.putAll((Map)currentMLValue);
                }
                String inboundValueStr = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)inboundValue);
                returnMLValue.put((Object)contentLocale, (Object)inboundValueStr);
                ret = returnMLValue;
            }
        } else if (pivotNodeRef != null && propertyQName.equals((Object)ContentModel.PROP_CONTENT)) {
            String emptyContentUrl;
            ContentData pivotContentData = (ContentData)this.nodeService.getProperty(pivotNodeRef, ContentModel.PROP_CONTENT);
            ContentData emptyContentData = (ContentData)inboundValue;
            String pivotContentUrl = pivotContentData == null ? null : pivotContentData.getContentUrl();
            String string = emptyContentUrl = emptyContentData == null ? null : emptyContentData.getContentUrl();
            ret = EqualsHelper.nullSafeEquals((Object)pivotContentUrl, (Object)emptyContentUrl) ? (ContentData)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT) : inboundValue;
        } else {
            ret = inboundValue;
        }
        if (logger.isDebugEnabled() && ret != inboundValue) {
            logger.debug((Object)("Converted inbound property: \n   NodeRef:    " + nodeRef + "\n" + "   Property:   " + propertyQName + "\n" + "   Before:     " + inboundValue + "\n" + "   After:      " + ret));
        }
        return ret;
    }
}

