/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AspectDetails {
    protected Map<QName, Serializable> properties = new HashMap<QName, Serializable>();
    protected List<ChildAssociationRef> childAssocs = new ArrayList<ChildAssociationRef>();
    protected List<AssociationRef> targetAssocs = new ArrayList<AssociationRef>();
    protected QName classRef;
    protected Map<ChildAssociationRef, ChildAssociationRef> alwaysTraverseMap = new HashMap<ChildAssociationRef, ChildAssociationRef>();

    public AspectDetails(QName classRef) {
        this.classRef = classRef;
    }

    public void addProperty(QName qName, Serializable value) {
        this.properties.put(qName, value);
    }

    public void removeProperty(QName qName) {
        this.properties.remove(qName);
    }

    public Map<QName, Serializable> getProperties() {
        return this.properties;
    }

    protected void addChildAssociation(ChildAssociationRef childAssocRef) {
        this.childAssocs.add(childAssocRef);
    }

    protected void addChildAssociation(ChildAssociationRef childAssocRef, boolean alwaysTraverseAssociation) {
        this.addChildAssociation(childAssocRef);
        if (alwaysTraverseAssociation) {
            this.alwaysTraverseMap.put(childAssocRef, childAssocRef);
        }
    }

    protected boolean isChildAssociationRefAlwaysTraversed(ChildAssociationRef childAssocRef) {
        return this.alwaysTraverseMap.containsKey(childAssocRef);
    }

    public List<ChildAssociationRef> getChildAssociations() {
        return this.childAssocs;
    }

    protected void addAssociation(AssociationRef nodeAssocRef) {
        this.targetAssocs.add(nodeAssocRef);
    }

    public List<AssociationRef> getAssociations() {
        return this.targetAssocs;
    }
}

