/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.preference;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.ClasspathScriptLocation;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.preference.PreferenceService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.TestWithUserUtils;

public class PreferenceServiceImplTest
extends BaseAlfrescoSpringTest {
    private static final String USER_ONE = "userOne";
    private static final String USER_BAD = "userBad";
    private ScriptService scriptService;
    private NodeService nodeService;
    private AuthenticationComponent authenticationComponent;
    private PreferenceService preferenceService;
    private PersonService personService;
    private ContentService contentService;

    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.scriptService = (ScriptService)this.applicationContext.getBean("ScriptService");
        this.nodeService = (NodeService)this.applicationContext.getBean("NodeService");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.preferenceService = (PreferenceService)this.applicationContext.getBean("PreferenceService");
        this.personService = (PersonService)this.applicationContext.getBean("PersonService");
        this.contentService = (ContentService)this.applicationContext.getBean("ContentService");
        TestWithUserUtils.authenticateUser(USER_ONE, "PWD", this.authenticationService, this.authenticationComponent);
    }

    public void testPreferences() throws Exception {
        Map<String, Serializable> prefs = this.preferenceService.getPreferences(USER_ONE);
        PreferenceServiceImplTest.assertNotNull(prefs);
        PreferenceServiceImplTest.assertEquals((int)0, (int)prefs.size());
        prefs = new HashMap<String, Serializable>(5);
        prefs.put("alfresco.one.alpha", (Serializable)((Object)"string"));
        prefs.put("alfresco.one.beta", Integer.valueOf(100));
        prefs.put("alfresco.two.alpha", Double.valueOf(3.142));
        prefs.put("alfresco.two.beta", (Serializable)this.rootNodeRef);
        prefs.put("alfresco.two.gamma", new Date());
        prefs.put("atTheRoot", (Serializable)((Object)"thisIsAtTheRoot"));
        this.preferenceService.setPreferences(USER_ONE, prefs);
        NodeRef personNodeRef = this.personService.getPerson(USER_ONE);
        ContentReader reader = this.contentService.getReader(personNodeRef, ContentModel.PROP_PREFERENCE_VALUES);
        System.out.println("JSON: " + reader.getContentString());
        prefs = this.preferenceService.getPreferences(USER_ONE, null);
        PreferenceServiceImplTest.assertNotNull(prefs);
        PreferenceServiceImplTest.assertEquals((int)6, (int)prefs.size());
        prefs = this.preferenceService.getPreferences(USER_ONE, "alfresco.two");
        PreferenceServiceImplTest.assertNotNull(prefs);
        PreferenceServiceImplTest.assertEquals((int)3, (int)prefs.size());
        this.preferenceService.clearPreferences(USER_ONE, "alfresco.two");
        prefs = this.preferenceService.getPreferences(USER_ONE, null);
        PreferenceServiceImplTest.assertNotNull(prefs);
        PreferenceServiceImplTest.assertEquals((int)3, (int)prefs.size());
        this.preferenceService.clearPreferences(USER_ONE);
        prefs = this.preferenceService.getPreferences(USER_ONE);
        PreferenceServiceImplTest.assertNotNull(prefs);
        PreferenceServiceImplTest.assertEquals((int)0, (int)prefs.size());
    }

    public void xtestBadUser() {
        PreferenceServiceImplTest.assertEquals((String)USER_ONE, (String)this.authenticationComponent.getCurrentUserName());
        try {
            HashMap<String, Serializable> prefs = new HashMap<String, Serializable>(5);
            prefs.put("alfresco.one.alpha", (Serializable)((Object)"string"));
            prefs.put("alfresco.one.beta", Integer.valueOf(100));
            prefs.put("alfresco.two.alpha", Double.valueOf(3.142));
            prefs.put("alfresco.two.beta", (Serializable)this.rootNodeRef);
            prefs.put("alfresco.two.gamma", new Date());
            prefs.put("atTheRoot", (Serializable)((Object)"thisIsAtTheRoot"));
            this.preferenceService.setPreferences(USER_BAD, prefs);
            PreferenceServiceImplTest.fail((String)"This should have raised an exception since we are trying to update preferences that are not our own!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testJSAPI() throws Exception {
        ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/preference/script/test_preferenceService.js");
        this.scriptService.executeScript(location, new HashMap<String, Object>(0));
    }
}

