/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition;

import java.util.List;
import org.alfresco.repo.action.ActionListImpl;
import org.alfresco.repo.rendition.RenditionDefinitionImpl;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionList;
import org.alfresco.service.cmr.action.CompositeAction;
import org.alfresco.service.cmr.rendition.CompositeRenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeRenditionDefinitionImpl
extends RenditionDefinitionImpl
implements CompositeRenditionDefinition {
    private static final long serialVersionUID = -770880495976834168L;
    private final ActionList<RenditionDefinition> actions = new ActionListImpl<RenditionDefinition>();

    public CompositeRenditionDefinitionImpl(String id, QName renditionName) {
        super(id, renditionName, "compositeRenderingEngine");
    }

    public CompositeRenditionDefinitionImpl(CompositeAction compositeAction) {
        super(compositeAction, "compositeRenderingEngine");
        for (Action action : compositeAction.getActions()) {
            RenditionDefinitionImpl subDefinition;
            if (action instanceof CompositeAction) {
                CompositeAction compAction = (CompositeAction)action;
                subDefinition = new CompositeRenditionDefinitionImpl(compAction);
            } else {
                subDefinition = new RenditionDefinitionImpl(action);
            }
            this.addAction(subDefinition);
        }
    }

    @Override
    public void addAction(int index, RenditionDefinition action) {
        this.actions.addAction(index, action);
    }

    @Override
    public void addAction(RenditionDefinition action) {
        this.actions.addAction(action);
    }

    @Override
    public RenditionDefinition getAction(int index) {
        return this.actions.getAction(index);
    }

    @Override
    public List<RenditionDefinition> getActions() {
        return this.actions.getActions();
    }

    @Override
    public boolean hasActions() {
        return this.actions.hasActions();
    }

    @Override
    public int indexOfAction(RenditionDefinition action) {
        return this.actions.indexOfAction(action);
    }

    @Override
    public void removeAction(RenditionDefinition action) {
        this.actions.removeAction(action);
    }

    @Override
    public void removeAllActions() {
        this.actions.removeAllActions();
    }

    @Override
    public void setAction(int index, RenditionDefinition action) {
        this.actions.setAction(index, action);
    }
}

