/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition;

import java.util.List;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RenditionAspect
implements NodeServicePolicies.BeforeDeleteNodePolicy {
    private static final Log log = LogFactory.getLog(RenditionAspect.class);
    private PolicyComponent policyComponent;
    private NodeService nodeService;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"beforeDeleteNode"), RenditionModel.ASPECT_RENDITION, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode", Behaviour.NotificationFrequency.EVERY_EVENT));
    }

    public void beforeDeleteNode(NodeRef nodeRef) {
        if (!this.nodeService.exists(nodeRef)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Predeleting rendition assoc to " + nodeRef));
        }
        List parents = this.nodeService.getParentAssocs(nodeRef, (QNamePattern)RenditionModel.ASSOC_RENDITION, RegexQNamePattern.MATCH_ALL);
        int parentCount = parents.size();
        if (parents.size() > 1 && log.isDebugEnabled()) {
            log.debug((Object)("Unexpectedly found " + parentCount + " source nodes. Removing all parent assocs."));
        }
        for (ChildAssociationRef chAssRef : parents) {
            if (chAssRef.isPrimary()) continue;
            this.nodeService.removeChildAssociation(chAssRef);
        }
    }
}

