/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.rule.BaseRuleTest;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.repo.rule.RuntimeRuleService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.CompositeAction;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CyclicChildRelationshipException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleType;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;

public class RuleServiceImplTest
extends BaseRuleTest {
    private String ASSOC_NAME_RULES_PREFIX = "rules";
    private RegexQNamePattern ASSOC_NAME_RULES_REGEX = new RegexQNamePattern("http://www.alfresco.org/model/rule/1.0", "^" + this.ASSOC_NAME_RULES_PREFIX + ".*");
    MutableAuthenticationService authenticationService;
    PermissionService permissionService;
    SearchService searchService;
    NamespaceService namespaceService;

    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.permissionService = (PermissionService)this.applicationContext.getBean("permissionService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        this.searchService = (SearchService)this.applicationContext.getBean("SearchService");
        this.namespaceService = (NamespaceService)this.applicationContext.getBean("NamespaceService");
    }

    public void testGetRuleType() {
        List<RuleType> ruleTypes = this.ruleService.getRuleTypes();
        RuleServiceImplTest.assertNotNull(ruleTypes);
        for (RuleType type : ruleTypes) {
            System.out.println(type.getDisplayLabel());
        }
    }

    public void testAddRule() {
        Rule newRule = this.createTestRule();
        this.ruleService.saveRule(this.nodeRef, newRule);
        RuleServiceImplTest.assertNotNull((Object)newRule.getNodeRef());
        RuleServiceImplTest.assertNotNull((Object)this.ruleService.getOwningNodeRef(newRule));
        RuleServiceImplTest.assertEquals((Object)this.nodeRef, (Object)this.ruleService.getOwningNodeRef(newRule));
        Rule savedRule = this.ruleService.getRule(newRule.getNodeRef());
        RuleServiceImplTest.assertNotNull((Object)savedRule);
        RuleServiceImplTest.assertFalse((boolean)savedRule.isAppliedToChildren());
        savedRule.applyToChildren(true);
        this.ruleService.saveRule(this.nodeRef, savedRule);
        Rule savedRule2 = this.ruleService.getRule(savedRule.getNodeRef());
        RuleServiceImplTest.assertNotNull((Object)savedRule2);
        RuleServiceImplTest.assertTrue((boolean)savedRule2.isAppliedToChildren());
    }

    public void testRemoveAllRules() {
        this.ruleService.removeAllRules(this.nodeRef);
        List<Rule> rules1 = this.ruleService.getRules(this.nodeRef);
        RuleServiceImplTest.assertNotNull(rules1);
        RuleServiceImplTest.assertEquals((int)0, (int)rules1.size());
        Rule newRule = this.createTestRule();
        this.ruleService.saveRule(this.nodeRef, newRule);
        Rule newRule2 = this.createTestRule();
        this.ruleService.saveRule(this.nodeRef, newRule2);
        List<Rule> rules2 = this.ruleService.getRules(this.nodeRef);
        RuleServiceImplTest.assertNotNull(rules2);
        RuleServiceImplTest.assertEquals((int)2, (int)rules2.size());
        this.ruleService.removeAllRules(this.nodeRef);
        List<Rule> rules3 = this.ruleService.getRules(this.nodeRef);
        RuleServiceImplTest.assertNotNull(rules3);
        RuleServiceImplTest.assertEquals((int)0, (int)rules3.size());
    }

    public void testGetRules() {
        List<Rule> noRules = this.ruleService.getRules(this.nodeRef);
        RuleServiceImplTest.assertNotNull(noRules);
        RuleServiceImplTest.assertEquals((int)0, (int)noRules.size());
        List<Rule> noRulesAfterCache = this.ruleService.getRules(this.nodeRef);
        RuleServiceImplTest.assertNotNull(noRulesAfterCache);
        RuleServiceImplTest.assertEquals((int)0, (int)noRulesAfterCache.size());
        this.testAddRule();
        List<Rule> rules = this.ruleService.getRules(this.nodeRef);
        RuleServiceImplTest.assertNotNull(rules);
        RuleServiceImplTest.assertEquals((int)1, (int)rules.size());
        Rule rule = rules.get(0);
        RuleServiceImplTest.assertEquals((String)"title", (String)rule.getTitle());
        RuleServiceImplTest.assertEquals((String)"description", (String)rule.getDescription());
        RuleServiceImplTest.assertNotNull((Object)this.nodeService.getProperty(rule.getNodeRef(), ContentModel.PROP_CREATED));
        RuleServiceImplTest.assertNotNull((Object)this.nodeService.getProperty(rule.getNodeRef(), ContentModel.PROP_CREATOR));
        Action action = rule.getAction();
        RuleServiceImplTest.assertNotNull((Object)action);
        List<ActionCondition> conditions = action.getActionConditions();
        RuleServiceImplTest.assertNotNull(conditions);
        RuleServiceImplTest.assertEquals((int)1, (int)conditions.size());
    }

    public void testGetRulesOrder() {
        Rule rule5;
        for (int index = 0; index < 10; ++index) {
            Rule newRule = this.createTestRule(true, Integer.toString(index));
            this.ruleService.saveRule(this.nodeRef, newRule);
        }
        List<Rule> rules = this.ruleService.getRules(this.nodeRef);
        int index = 0;
        for (Rule rule2 : rules) {
            RuleServiceImplTest.assertEquals((String)Integer.toString(index), (String)rule2.getTitle());
            ++index;
        }
        NodeRef level1 = this.createNewNode(this.nodeRef);
        for (int index2 = 10; index2 < 20; ++index2) {
            Rule newRule = this.createTestRule(true, Integer.toString(index2));
            this.ruleService.saveRule(level1, newRule);
        }
        List<Rule> rules2 = this.ruleService.getRules(level1);
        int index2 = 0;
        for (Rule rule3 : rules2) {
            RuleServiceImplTest.assertEquals((String)Integer.toString(index2), (String)rule3.getTitle());
            ++index2;
        }
        NodeRef level2 = this.createNewNode(level1);
        for (int index3 = 20; index3 < 30; ++index3) {
            Rule newRule = this.createTestRule(true, Integer.toString(index3));
            this.ruleService.saveRule(level2, newRule);
        }
        List<Rule> rules3 = this.ruleService.getRules(level2);
        int index3 = 0;
        for (Rule rule4 : rules3) {
            RuleServiceImplTest.assertEquals((String)Integer.toString(index3), (String)rule4.getTitle());
            ++index3;
        }
        Rule rule1 = rules3.get(2);
        rule1.setDescription("This has been changed");
        this.ruleService.saveRule(this.nodeRef, rule1);
        Rule rule2 = rules3.get(12);
        rule2.setDescription("This has been changed");
        this.ruleService.saveRule(level1, rule2);
        Rule rule3 = rules3.get(22);
        rule3.setDescription("This has been changed");
        this.ruleService.saveRule(level2, rule3);
        List<Rule> rules4 = this.ruleService.getRules(level2);
        int index4 = 0;
        for (Rule rule5 : rules4) {
            RuleServiceImplTest.assertEquals((String)Integer.toString(index4), (String)rule5.getTitle());
            ++index4;
        }
        NodeRef ruleFolder = ((RuntimeRuleService)((Object)this.ruleService)).getSavedRuleFolderAssoc(this.nodeRef).getChildRef();
        if (ruleFolder != null) {
            List ruleChildAssocRefs = this.nodeService.getChildAssocs(ruleFolder, RegexQNamePattern.MATCH_ALL, (QNamePattern)this.ASSOC_NAME_RULES_REGEX);
            System.out.println("Association Nth Sibling values ...");
            for (ChildAssociationRef ruleChildAssocRef : ruleChildAssocRefs) {
                System.out.println(" - Assoc index = " + ruleChildAssocRef.getNthSibling() + ", name = " + this.nodeService.getProperty(ruleChildAssocRef.getChildRef(), ContentModel.PROP_TITLE));
            }
        }
        rules = this.ruleService.getRules(this.nodeRef);
        rule5 = rules.get(3);
        this.ruleService.setRulePosition(this.nodeRef, rule5, 1);
        if (ruleFolder != null) {
            List ruleChildAssocRefs = this.nodeService.getChildAssocs(ruleFolder, RegexQNamePattern.MATCH_ALL, (QNamePattern)this.ASSOC_NAME_RULES_REGEX);
            System.out.println("After change of index ...");
            for (ChildAssociationRef ruleChildAssocRef : ruleChildAssocRefs) {
                System.out.println(" - Assoc index = " + ruleChildAssocRef.getNthSibling() + ", name = " + this.nodeService.getProperty(ruleChildAssocRef.getChildRef(), ContentModel.PROP_TITLE));
            }
        }
        ArrayList<NodeRef> ruleNodeRefs = new ArrayList<NodeRef>(rules.size());
        for (Rule tempRule : rules) {
            ruleNodeRefs.add(0, tempRule.getNodeRef());
        }
        Action action = this.actionService.createAction("reorder-rules");
        action.setParameterValue("rules", ruleNodeRefs);
        this.actionService.executeAction(action, this.nodeRef);
        List ruleChildAssocRefs = this.nodeService.getChildAssocs(ruleFolder, RegexQNamePattern.MATCH_ALL, (QNamePattern)this.ASSOC_NAME_RULES_REGEX);
        System.out.println("After execution of action ...");
        for (ChildAssociationRef ruleChildAssocRef : ruleChildAssocRefs) {
            System.out.println(" - Assoc index = " + ruleChildAssocRef.getNthSibling() + ", name = " + this.nodeService.getProperty(ruleChildAssocRef.getChildRef(), ContentModel.PROP_TITLE));
        }
    }

    public void testIgnoreInheritedRules() {
        this.ruleService.saveRule(this.nodeRef, this.createTestRule(true, "rule1"));
        this.ruleService.saveRule(this.nodeRef, this.createTestRule(false, "rule2"));
        NodeRef nodeRef1 = this.createNewNode(this.nodeRef);
        this.ruleService.saveRule(nodeRef1, this.createTestRule(true, "rule3"));
        this.ruleService.saveRule(nodeRef1, this.createTestRule(false, "rule4"));
        NodeRef nodeRef2 = this.createNewNode(nodeRef1);
        this.ruleService.saveRule(nodeRef2, this.createTestRule(true, "rule5"));
        this.ruleService.saveRule(nodeRef2, this.createTestRule(false, "rule6"));
        this.nodeService.addAspect(nodeRef1, RuleModel.ASPECT_IGNORE_INHERITED_RULES, null);
        List<Rule> rules1 = this.ruleService.getRules(nodeRef2);
        RuleServiceImplTest.assertNotNull(rules1);
        RuleServiceImplTest.assertEquals((int)3, (int)rules1.size());
        RuleServiceImplTest.assertEquals((String)"rule3", (String)rules1.get(0).getTitle());
        RuleServiceImplTest.assertEquals((String)"rule5", (String)rules1.get(1).getTitle());
        RuleServiceImplTest.assertEquals((String)"rule6", (String)rules1.get(2).getTitle());
        this.nodeService.addAspect(nodeRef2, RuleModel.ASPECT_IGNORE_INHERITED_RULES, null);
        List<Rule> rules2 = this.ruleService.getRules(nodeRef2);
        RuleServiceImplTest.assertNotNull(rules2);
        RuleServiceImplTest.assertEquals((int)2, (int)rules2.size());
        RuleServiceImplTest.assertEquals((String)"rule5", (String)rules2.get(0).getTitle());
        RuleServiceImplTest.assertEquals((String)"rule6", (String)rules2.get(1).getTitle());
        this.nodeService.removeAspect(nodeRef1, RuleModel.ASPECT_IGNORE_INHERITED_RULES);
        this.nodeService.removeAspect(nodeRef2, RuleModel.ASPECT_IGNORE_INHERITED_RULES);
        List<Rule> rules3 = this.ruleService.getRules(nodeRef2);
        RuleServiceImplTest.assertNotNull(rules3);
        RuleServiceImplTest.assertEquals((int)4, (int)rules3.size());
        RuleServiceImplTest.assertEquals((String)"rule1", (String)rules3.get(0).getTitle());
        RuleServiceImplTest.assertEquals((String)"rule3", (String)rules3.get(1).getTitle());
        RuleServiceImplTest.assertEquals((String)"rule5", (String)rules3.get(2).getTitle());
        RuleServiceImplTest.assertEquals((String)"rule6", (String)rules3.get(3).getTitle());
    }

    public void testRulesDisabled() {
        this.testAddRule();
        RuleServiceImplTest.assertTrue((boolean)this.ruleService.rulesEnabled(this.nodeRef));
        this.ruleService.disableRules(this.nodeRef);
        RuleServiceImplTest.assertFalse((boolean)this.ruleService.rulesEnabled(this.nodeRef));
        this.ruleService.enableRules(this.nodeRef);
        RuleServiceImplTest.assertTrue((boolean)this.ruleService.rulesEnabled(this.nodeRef));
    }

    private NodeRef createNewNode(NodeRef parent) {
        return this.nodeService.createNode(parent, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), ContentModel.TYPE_CONTAINER).getChildRef();
    }

    public void testRuleServicePermissionsConsumer() {
        this.authenticationService.createAuthentication("conUser", "password".toCharArray());
        this.permissionService.setPermission(this.nodeRef, "conUser", "Consumer", true);
        this.permissionService.setInheritParentPermissions(this.nodeRef, true);
        this.authenticationService.authenticate("conUser", "password".toCharArray());
        Rule rule = this.createTestRule();
        try {
            this.ruleService.saveRule(this.nodeRef, rule);
            RuleServiceImplTest.fail((String)"Consumers cannot create rules.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testRuleServicePermissionsEditor() {
        this.authenticationService.createAuthentication("editorUser", "password".toCharArray());
        this.permissionService.setPermission(this.nodeRef, "editorUser", "Editor", true);
        this.permissionService.setInheritParentPermissions(this.nodeRef, true);
        this.authenticationService.authenticate("editorUser", "password".toCharArray());
        Rule rule = this.createTestRule();
        try {
            this.ruleService.saveRule(this.nodeRef, rule);
            RuleServiceImplTest.fail((String)"Editors cannot create rules.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testRuleServicePermissionsCoordinator() {
        this.authenticationService.createAuthentication("coordUser", "password".toCharArray());
        this.permissionService.setPermission(this.nodeRef, "coordUser", "Coordinator", true);
        this.permissionService.setInheritParentPermissions(this.nodeRef, true);
        this.authenticationService.authenticate(AuthenticationUtil.getAdminUserName(), "admin".toCharArray());
        Rule rule2 = this.createTestRule();
        this.ruleService.saveRule(this.nodeRef, rule2);
        this.authenticationService.clearCurrentSecurityContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRuleInheritance() {
        NodeRef rootWithRules = this.createNewNode(this.rootNodeRef);
        Rule rule1 = this.createTestRule();
        this.ruleService.saveRule(rootWithRules, rule1);
        Rule rule2 = this.createTestRule(true);
        this.ruleService.saveRule(rootWithRules, rule2);
        NodeRef nonActionableChild = this.createNewNode(rootWithRules);
        NodeRef childWithRules = this.createNewNode(nonActionableChild);
        Rule rule3 = this.createTestRule();
        this.ruleService.saveRule(childWithRules, rule3);
        Rule rule4 = this.createTestRule(true);
        this.ruleService.saveRule(childWithRules, rule4);
        NodeRef rootWithRules2 = this.createNewNode(this.rootNodeRef);
        this.nodeService.addChild(rootWithRules2, childWithRules, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"));
        Rule rule5 = this.createTestRule();
        this.ruleService.saveRule(rootWithRules2, rule5);
        Rule rule6 = this.createTestRule(true);
        this.ruleService.saveRule(rootWithRules2, rule6);
        List<Rule> allRules = this.ruleService.getRules(childWithRules);
        RuleServiceImplTest.assertNotNull(allRules);
        RuleServiceImplTest.assertEquals((int)4, (int)allRules.size());
        RuleServiceImplTest.assertTrue((boolean)allRules.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules.contains(rule3));
        RuleServiceImplTest.assertTrue((boolean)allRules.contains(rule4));
        RuleServiceImplTest.assertTrue((boolean)allRules.contains(rule6));
        int count = 0;
        for (Rule rule : allRules) {
            NodeRef owningNodeRef = this.ruleService.getOwningNodeRef(rule);
            RuleServiceImplTest.assertNotNull((Object)owningNodeRef);
            if (!owningNodeRef.equals((Object)childWithRules)) continue;
            ++count;
        }
        RuleServiceImplTest.assertEquals((int)2, (int)count);
        List<Rule> myRules = this.ruleService.getRules(childWithRules, false);
        RuleServiceImplTest.assertNotNull(myRules);
        RuleServiceImplTest.assertEquals((int)2, (int)myRules.size());
        RuleServiceImplTest.assertTrue((boolean)myRules.contains(rule3));
        RuleServiceImplTest.assertTrue((boolean)myRules.contains(rule4));
        List<Rule> allRules2 = this.ruleService.getRules(nonActionableChild, true);
        RuleServiceImplTest.assertNotNull(allRules2);
        RuleServiceImplTest.assertEquals((int)1, (int)allRules2.size());
        RuleServiceImplTest.assertTrue((boolean)allRules2.contains(rule2));
        List<Rule> myRules2 = this.ruleService.getRules(nonActionableChild, false);
        RuleServiceImplTest.assertNotNull(myRules2);
        RuleServiceImplTest.assertEquals((int)0, (int)myRules2.size());
        List<Rule> allRules3 = this.ruleService.getRules(rootWithRules, true);
        RuleServiceImplTest.assertNotNull(allRules3);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules3.size());
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule2));
        List<Rule> myRules3 = this.ruleService.getRules(rootWithRules, false);
        RuleServiceImplTest.assertNotNull(myRules3);
        RuleServiceImplTest.assertEquals((int)2, (int)myRules3.size());
        RuleServiceImplTest.assertTrue((boolean)myRules3.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)myRules3.contains(rule2));
        List<Rule> allRules4 = this.ruleService.getRules(rootWithRules2, true);
        RuleServiceImplTest.assertNotNull(allRules4);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules4.size());
        RuleServiceImplTest.assertTrue((boolean)allRules4.contains(rule5));
        RuleServiceImplTest.assertTrue((boolean)allRules4.contains(rule6));
        List<Rule> myRules4 = this.ruleService.getRules(rootWithRules2, false);
        RuleServiceImplTest.assertNotNull(myRules4);
        RuleServiceImplTest.assertEquals((int)2, (int)myRules4.size());
        RuleServiceImplTest.assertTrue((boolean)myRules4.contains(rule5));
        RuleServiceImplTest.assertTrue((boolean)myRules4.contains(rule6));
        Rule rule7 = this.createTestRule(true);
        this.ruleService.saveRule(rootWithRules, rule7);
        List<Rule> allRules5 = this.ruleService.getRules(childWithRules, true);
        RuleServiceImplTest.assertNotNull(allRules5);
        RuleServiceImplTest.assertEquals((int)5, (int)allRules5.size());
        RuleServiceImplTest.assertTrue((boolean)allRules5.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules5.contains(rule3));
        RuleServiceImplTest.assertTrue((boolean)allRules5.contains(rule4));
        RuleServiceImplTest.assertTrue((boolean)allRules5.contains(rule6));
        RuleServiceImplTest.assertTrue((boolean)allRules5.contains(rule7));
        List<Rule> allRules6 = this.ruleService.getRules(nonActionableChild, true);
        RuleServiceImplTest.assertNotNull(allRules6);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules6.size());
        RuleServiceImplTest.assertTrue((boolean)allRules6.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules6.contains(rule7));
        List<Rule> allRules7 = this.ruleService.getRules(rootWithRules, true);
        RuleServiceImplTest.assertNotNull(allRules7);
        RuleServiceImplTest.assertEquals((int)3, (int)allRules7.size());
        RuleServiceImplTest.assertTrue((boolean)allRules7.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules7.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules7.contains(rule7));
        List<Rule> allRules8 = this.ruleService.getRules(rootWithRules2, true);
        RuleServiceImplTest.assertNotNull(allRules8);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules8.size());
        RuleServiceImplTest.assertTrue((boolean)allRules8.contains(rule5));
        RuleServiceImplTest.assertTrue((boolean)allRules8.contains(rule6));
        this.ruleService.removeRule(rootWithRules, rule7);
        List<Rule> allRules9 = this.ruleService.getRules(childWithRules, true);
        RuleServiceImplTest.assertNotNull(allRules9);
        RuleServiceImplTest.assertEquals((int)4, (int)allRules9.size());
        RuleServiceImplTest.assertTrue((boolean)allRules9.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules9.contains(rule3));
        RuleServiceImplTest.assertTrue((boolean)allRules9.contains(rule4));
        RuleServiceImplTest.assertTrue((boolean)allRules9.contains(rule6));
        List<Rule> allRules10 = this.ruleService.getRules(nonActionableChild, true);
        RuleServiceImplTest.assertNotNull(allRules10);
        RuleServiceImplTest.assertEquals((int)1, (int)allRules10.size());
        RuleServiceImplTest.assertTrue((boolean)allRules10.contains(rule2));
        List<Rule> allRules11 = this.ruleService.getRules(rootWithRules, true);
        RuleServiceImplTest.assertNotNull(allRules11);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules11.size());
        RuleServiceImplTest.assertTrue((boolean)allRules11.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules11.contains(rule2));
        List<Rule> allRules12 = this.ruleService.getRules(rootWithRules2, true);
        RuleServiceImplTest.assertNotNull(allRules12);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules12.size());
        RuleServiceImplTest.assertTrue((boolean)allRules12.contains(rule5));
        RuleServiceImplTest.assertTrue((boolean)allRules12.contains(rule6));
        this.nodeService.removeChild(rootWithRules2, childWithRules);
        List<Rule> allRules13 = this.ruleService.getRules(childWithRules, true);
        RuleServiceImplTest.assertNotNull(allRules13);
        RuleServiceImplTest.assertEquals((int)3, (int)allRules13.size());
        RuleServiceImplTest.assertTrue((boolean)allRules13.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules13.contains(rule3));
        RuleServiceImplTest.assertTrue((boolean)allRules13.contains(rule4));
        List<Rule> allRules14 = this.ruleService.getRules(nonActionableChild, true);
        RuleServiceImplTest.assertNotNull(allRules14);
        RuleServiceImplTest.assertEquals((int)1, (int)allRules14.size());
        RuleServiceImplTest.assertTrue((boolean)allRules14.contains(rule2));
        List<Rule> allRules15 = this.ruleService.getRules(rootWithRules, true);
        RuleServiceImplTest.assertNotNull(allRules15);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules15.size());
        RuleServiceImplTest.assertTrue((boolean)allRules15.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules15.contains(rule2));
        List<Rule> allRules16 = this.ruleService.getRules(rootWithRules2, true);
        RuleServiceImplTest.assertNotNull(allRules16);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules16.size());
        RuleServiceImplTest.assertTrue((boolean)allRules16.contains(rule5));
        RuleServiceImplTest.assertTrue((boolean)allRules16.contains(rule6));
        this.ruleService.disableRules(rootWithRules2);
        try {
            this.nodeService.addChild(rootWithRules2, childWithRules, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"));
            Object var34_33 = null;
            this.ruleService.enableRules(rootWithRules2);
        }
        catch (Throwable throwable) {
            Object var34_34 = null;
            this.ruleService.enableRules(rootWithRules2);
            throw throwable;
        }
        List<Rule> allRules17 = this.ruleService.getRules(childWithRules, true);
        RuleServiceImplTest.assertNotNull(allRules17);
        RuleServiceImplTest.assertEquals((int)4, (int)allRules17.size());
        RuleServiceImplTest.assertTrue((boolean)allRules17.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules17.contains(rule3));
        RuleServiceImplTest.assertTrue((boolean)allRules17.contains(rule4));
        RuleServiceImplTest.assertTrue((boolean)allRules17.contains(rule6));
        List<Rule> allRules18 = this.ruleService.getRules(nonActionableChild, true);
        RuleServiceImplTest.assertNotNull(allRules18);
        RuleServiceImplTest.assertEquals((int)1, (int)allRules18.size());
        RuleServiceImplTest.assertTrue((boolean)allRules18.contains(rule2));
        List<Rule> allRules19 = this.ruleService.getRules(rootWithRules, true);
        RuleServiceImplTest.assertNotNull(allRules19);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules19.size());
        RuleServiceImplTest.assertTrue((boolean)allRules19.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules19.contains(rule2));
        List<Rule> allRules20 = this.ruleService.getRules(rootWithRules2, true);
        RuleServiceImplTest.assertNotNull(allRules20);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules20.size());
        RuleServiceImplTest.assertTrue((boolean)allRules20.contains(rule5));
        RuleServiceImplTest.assertTrue((boolean)allRules20.contains(rule6));
        this.nodeService.deleteNode(rootWithRules2);
        List<Rule> allRules21 = this.ruleService.getRules(childWithRules, true);
        RuleServiceImplTest.assertNotNull(allRules21);
        RuleServiceImplTest.assertEquals((int)3, (int)allRules21.size());
        RuleServiceImplTest.assertTrue((boolean)allRules21.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules21.contains(rule3));
        RuleServiceImplTest.assertTrue((boolean)allRules21.contains(rule4));
        List<Rule> allRules22 = this.ruleService.getRules(nonActionableChild, true);
        RuleServiceImplTest.assertNotNull(allRules22);
        RuleServiceImplTest.assertEquals((int)1, (int)allRules22.size());
        RuleServiceImplTest.assertTrue((boolean)allRules22.contains(rule2));
        List<Rule> allRules23 = this.ruleService.getRules(rootWithRules, true);
        RuleServiceImplTest.assertNotNull(allRules23);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules23.size());
        RuleServiceImplTest.assertTrue((boolean)allRules23.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules23.contains(rule2));
    }

    public void testCyclicGraphWithInheritedRules() throws Exception {
        NodeRef nodeRef1 = this.createNewNode(this.rootNodeRef);
        NodeRef nodeRef2 = this.createNewNode(nodeRef1);
        NodeRef nodeRef3 = this.createNewNode(nodeRef2);
        try {
            this.nodeService.addChild(nodeRef3, nodeRef1, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}loop"));
            RuleServiceImplTest.fail((String)"Expected detection of cyclic relationship");
        }
        catch (CyclicChildRelationshipException e) {
            // empty catch block
        }
        Rule rule1 = this.createTestRule(true);
        this.ruleService.saveRule(nodeRef1, rule1);
        Rule rule2 = this.createTestRule(true);
        this.ruleService.saveRule(nodeRef2, rule2);
        Rule rule3 = this.createTestRule(true);
        this.ruleService.saveRule(nodeRef3, rule3);
        List<Rule> allRules1 = this.ruleService.getRules(nodeRef1, true);
        RuleServiceImplTest.assertNotNull(allRules1);
        RuleServiceImplTest.assertEquals((int)3, (int)allRules1.size());
        RuleServiceImplTest.assertTrue((boolean)allRules1.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules1.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules1.contains(rule3));
        List<Rule> allRules2 = this.ruleService.getRules(nodeRef2, true);
        RuleServiceImplTest.assertNotNull(allRules2);
        RuleServiceImplTest.assertEquals((int)3, (int)allRules2.size());
        RuleServiceImplTest.assertTrue((boolean)allRules2.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules2.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules2.contains(rule3));
        List<Rule> allRules3 = this.ruleService.getRules(nodeRef3, true);
        RuleServiceImplTest.assertNotNull(allRules3);
        RuleServiceImplTest.assertEquals((int)3, (int)allRules3.size());
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule3));
    }

    public void testRuleDuplication() {
        NodeRef nodeRef1 = this.createNewNode(this.rootNodeRef);
        NodeRef nodeRef2 = this.createNewNode(nodeRef1);
        NodeRef nodeRef3 = this.createNewNode(nodeRef2);
        NodeRef nodeRef4 = this.createNewNode(nodeRef1);
        this.nodeService.addChild(nodeRef4, nodeRef3, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}test"));
        Rule rule1 = this.createTestRule(true);
        this.ruleService.saveRule(nodeRef1, rule1);
        Rule rule2 = this.createTestRule(true);
        this.ruleService.saveRule(nodeRef2, rule2);
        Rule rule3 = this.createTestRule(true);
        this.ruleService.saveRule(nodeRef3, rule3);
        Rule rule4 = this.createTestRule(true);
        this.ruleService.saveRule(nodeRef4, rule4);
        List<Rule> allRules1 = this.ruleService.getRules(nodeRef1, true);
        RuleServiceImplTest.assertNotNull(allRules1);
        RuleServiceImplTest.assertEquals((int)1, (int)allRules1.size());
        RuleServiceImplTest.assertTrue((boolean)allRules1.contains(rule1));
        List<Rule> allRules2 = this.ruleService.getRules(nodeRef2, true);
        RuleServiceImplTest.assertNotNull(allRules2);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules2.size());
        RuleServiceImplTest.assertTrue((boolean)allRules2.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules2.contains(rule2));
        List<Rule> allRules3 = this.ruleService.getRules(nodeRef3, true);
        RuleServiceImplTest.assertNotNull(allRules3);
        RuleServiceImplTest.assertEquals((int)4, (int)allRules3.size());
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule3));
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule4));
        List<Rule> allRules4 = this.ruleService.getRules(nodeRef4, true);
        RuleServiceImplTest.assertNotNull(allRules4);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules4.size());
        RuleServiceImplTest.assertTrue((boolean)allRules4.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules4.contains(rule4));
    }

    public void testCyclicRules() {
    }

    public void testCyclicAsyncRules() throws Exception {
        NodeRef nodeRef = this.createNewNode(this.rootNodeRef);
        HashMap<String, Serializable> conditionProps = new HashMap<String, Serializable>();
        conditionProps.put("value", (Serializable)((Object)"*.jpg"));
        HashMap<String, Serializable> actionProps = new HashMap<String, Serializable>();
        actionProps.put("mime-type", (Serializable)((Object)"image/gif"));
        actionProps.put("destination-folder", (Serializable)nodeRef);
        actionProps.put("assoc-type", (Serializable)ContentModel.ASSOC_CHILDREN);
        actionProps.put("assoc-name", (Serializable)ContentModel.ASSOC_CHILDREN);
        Rule rule = new Rule();
        rule.setRuleType(this.ruleType.getName());
        rule.setTitle("Convert from *.jpg to *.gif");
        rule.setExecuteAsynchronously(true);
        Action action = this.actionService.createAction("transform-image");
        action.setParameterValues(actionProps);
        ActionCondition actionCondition = this.actionService.createActionCondition("compare-property-value");
        actionCondition.setParameterValues(conditionProps);
        action.addActionCondition(actionCondition);
        rule.setAction(action);
        HashMap<String, Serializable> conditionProps2 = new HashMap<String, Serializable>();
        conditionProps2.put("value", (Serializable)((Object)"*.gif"));
        HashMap<String, Serializable> actionProps2 = new HashMap<String, Serializable>();
        actionProps2.put("mime-type", (Serializable)((Object)"image/jpeg"));
        actionProps2.put("destination-folder", (Serializable)nodeRef);
        actionProps2.put("assoc-name", (Serializable)ContentModel.ASSOC_CHILDREN);
        Rule rule2 = new Rule();
        rule2.setRuleType(this.ruleType.getName());
        rule2.setTitle("Convert from *.gif to *.jpg");
        rule2.setExecuteAsynchronously(true);
        Action action2 = this.actionService.createAction("transform-image");
        action2.setParameterValues(actionProps2);
        ActionCondition actionCondition2 = this.actionService.createActionCondition("compare-property-value");
        actionCondition2.setParameterValues(conditionProps2);
        action2.addActionCondition(actionCondition2);
        rule2.setAction(action2);
        this.ruleService.saveRule(nodeRef, rule);
        this.ruleService.saveRule(nodeRef, rule);
        NodeRef contentNode = this.nodeService.createNode(nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), ContentModel.TYPE_CONTENT).getChildRef();
        this.nodeService.setProperty(contentNode, ContentModel.PROP_NAME, (Serializable)((Object)"myFile.jpg"));
        File file = AbstractContentTransformerTest.loadQuickTestFile("jpg");
        ContentWriter writer = this.contentService.getWriter(contentNode, ContentModel.PROP_CONTENT, true);
        writer.setEncoding("UTF-8");
        writer.setMimetype("image/jpeg");
        writer.putContent(file);
        this.setComplete();
        this.endTransaction();
    }

    public void testDeleteSpaceWithExecuteScriptRule() throws Exception {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() {
                NodeRef storeRootNodeRef = RuleServiceImplTest.this.nodeService.getRootNode(new StoreRef("workspace://SpacesStore"));
                NodeRef companyHomeNodeRef = (NodeRef)RuleServiceImplTest.this.searchService.selectNodes(storeRootNodeRef, "/app:company_home", null, (NamespacePrefixResolver)RuleServiceImplTest.this.namespaceService, false).get(0);
                Assert.assertNotNull((String)"NodeRef company_home is null", (Object)companyHomeNodeRef);
                QName testFolderName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("ISSUE_ETWOTWO_738_" + System.currentTimeMillis()));
                ChildAssociationRef childAssocRef = RuleServiceImplTest.this.nodeService.createNode(companyHomeNodeRef, ContentModel.ASSOC_CONTAINS, testFolderName, ContentModel.TYPE_FOLDER);
                NodeRef testFolderNodeRef = childAssocRef.getChildRef();
                NodeRef scriptRef = (NodeRef)RuleServiceImplTest.this.searchService.selectNodes(storeRootNodeRef, "/app:company_home/app:dictionary/app:scripts/cm:backup.js", null, (NamespacePrefixResolver)RuleServiceImplTest.this.namespaceService, false).get(0);
                Assert.assertNotNull((String)"NodeRef script is null", (Object)scriptRef);
                Rule rule = new Rule();
                rule.setRuleType("inbound");
                rule.setTitle("rule title " + System.currentTimeMillis());
                CompositeAction compositeAction = RuleServiceImplTest.this.actionService.createCompositeAction();
                rule.setAction(compositeAction);
                ActionCondition condition = RuleServiceImplTest.this.actionService.createActionCondition("no-condition");
                condition.setParameterValues(new HashMap<String, Serializable>());
                condition.setInvertCondition(false);
                compositeAction.addActionCondition(condition);
                Action action = RuleServiceImplTest.this.actionService.createAction("script");
                HashMap<String, Serializable> repoActionParams = new HashMap<String, Serializable>();
                repoActionParams.put("script-ref", (Serializable)scriptRef);
                action.setParameterValues(repoActionParams);
                compositeAction.addAction(action);
                RuleServiceImplTest.this.ruleService.saveRule(testFolderNodeRef, rule);
                RuleServiceImplTest.this.nodeService.deleteNode(testFolderNodeRef);
                return null;
            }
        }, false, true);
    }
}

