/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.node.NodeBulkLoader;
import org.alfresco.repo.search.IndexerException;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.QueryRegisterComponent;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.search.impl.lucene.LuceneIndexer;
import org.alfresco.repo.search.impl.lucene.LuceneIndexerAndSearcher;
import org.alfresco.repo.search.impl.lucene.LuceneQueryLanguageSPI;
import org.alfresco.repo.search.impl.lucene.LuceneSearcher;
import org.alfresco.repo.search.impl.lucene.index.IndexInfo;
import org.alfresco.repo.search.transaction.SimpleTransaction;
import org.alfresco.repo.search.transaction.SimpleTransactionManager;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.store.Lock;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.transaction.support.TransactionSynchronizationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLuceneIndexerAndSearcherFactory
implements LuceneIndexerAndSearcher,
XAResource,
ApplicationContextAware {
    private static Log logger = LogFactory.getLog(AbstractLuceneIndexerAndSearcherFactory.class);
    private int queryMaxClauses;
    private int indexerBatchSize;
    protected Map<String, LuceneQueryLanguageSPI> queryLanguages = new HashMap<String, LuceneQueryLanguageSPI>();
    private Map<Xid, Map<StoreRef, LuceneIndexer>> activeIndexersInGlobalTx = new HashMap<Xid, Map<StoreRef, LuceneIndexer>>();
    private Map<Xid, Map<StoreRef, LuceneIndexer>> suspendedIndexersInGlobalTx = new HashMap<Xid, Map<StoreRef, LuceneIndexer>>();
    private final String indexersKey = "AbstractLuceneIndexerAndSearcherFactory." + GUID.generate();
    private int timeout = 600000;
    private static final int DEFAULT_TIMEOUT = 600000;
    protected TenantService tenantService;
    private String indexRootLocation;
    private QueryRegisterComponent queryRegister;
    private long maxAtomicTransformationTime = 20L;
    private int indexerMaxFieldLength = 10000;
    private long writeLockTimeout;
    private long commitLockTimeout;
    private String lockDirectory;
    private MLAnalysisMode defaultMLIndexAnalysisMode = MLAnalysisMode.EXACT_LANGUAGE_AND_ALL;
    private MLAnalysisMode defaultMLSearchAnalysisMode = MLAnalysisMode.EXACT_LANGUAGE_AND_ALL;
    private ThreadPoolExecutor threadPoolExecutor;
    private NodeBulkLoader bulkLoader;
    private int maxDocIdCacheSize = 10000;
    private int maxDocsForInMemoryMerge = 10000;
    private int maxDocsForInMemoryIndex = 10000;
    private double maxRamInMbForInMemoryMerge = 16.0;
    private double maxRamInMbForInMemoryIndex = 16.0;
    private int maxDocumentCacheSize = 100;
    private int maxIsCategoryCacheSize = -1;
    private int maxLinkAspectCacheSize = 10000;
    private int maxParentCacheSize = 10000;
    private int maxPathCacheSize = 10000;
    private int maxTypeCacheSize = 10000;
    private int mergerMaxMergeDocs = 1000000;
    private int mergerMergeFactor = 5;
    private int mergerMergeBlockingFactor = 1;
    private int mergerMaxBufferedDocs = -1;
    private double mergerRamBufferSizeMb = 16.0;
    private int mergerTargetIndexCount = 5;
    private int mergerTargetOverlayCount = 5;
    private int mergerTargetOverlaysBlockingFactor = 1;
    private boolean fairLocking;
    private int termIndexInterval = 128;
    private boolean useNioMemoryMapping = true;
    private int writerMaxMergeDocs = 1000000;
    private int writerMergeFactor = 5;
    private int writerMaxBufferedDocs = -1;
    private double writerRamBufferSizeMb = 16.0;
    private boolean cacheEnabled = true;
    private boolean postSortDateTime;
    private ConfigurableApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    @Override
    public ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setIndexRootLocation(String indexRootLocation) {
        this.indexRootLocation = indexRootLocation;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setQueryRegister(QueryRegisterComponent queryRegister) {
        this.queryRegister = queryRegister;
    }

    public QueryRegisterComponent getQueryRegister() {
        return this.queryRegister;
    }

    public void setMaxAtomicTransformationTime(long maxAtomicTransformationTime) {
        this.maxAtomicTransformationTime = maxAtomicTransformationTime;
    }

    public long getMaxTransformationTime() {
        return this.maxAtomicTransformationTime;
    }

    @Override
    public NodeBulkLoader getBulkLoader() {
        return this.bulkLoader;
    }

    public void setBulkLoader(NodeBulkLoader bulkLoader) {
        this.bulkLoader = bulkLoader;
    }

    private boolean inGlobalTransaction() {
        try {
            return SimpleTransactionManager.getInstance().getTransaction() != null;
        }
        catch (SystemException e) {
            return false;
        }
    }

    private SimpleTransaction getTransaction() throws IndexerException {
        try {
            return SimpleTransactionManager.getInstance().getTransaction();
        }
        catch (SystemException e) {
            throw new IndexerException("Failed to get transaction", e);
        }
    }

    @Override
    public LuceneIndexer getIndexer(StoreRef storeRef) throws IndexerException {
        storeRef = this.tenantService.getName(storeRef);
        AlfrescoTransactionSupport.bindLucene(this);
        if (this.inGlobalTransaction()) {
            LuceneIndexer indexer;
            SimpleTransaction tx = this.getTransaction();
            Map<StoreRef, LuceneIndexer> indexers = this.activeIndexersInGlobalTx.get(tx);
            if (indexers == null) {
                if (this.suspendedIndexersInGlobalTx.containsKey(tx)) {
                    throw new IndexerException("Trying to obtain an index for a suspended transaction.");
                }
                indexers = new HashMap<StoreRef, LuceneIndexer>();
                this.activeIndexersInGlobalTx.put(tx, indexers);
                try {
                    tx.enlistResource(this);
                }
                catch (IllegalStateException e) {
                    throw new IndexerException("", e);
                }
                catch (RollbackException e) {
                    throw new IndexerException("", e);
                }
                catch (SystemException e) {
                    throw new IndexerException("", e);
                }
            }
            if ((indexer = indexers.get(storeRef)) == null) {
                indexer = this.createIndexer(storeRef, this.getTransactionId(tx, storeRef));
                indexers.put(storeRef, indexer);
            }
            return indexer;
        }
        return this.getThreadLocalIndexer(storeRef);
    }

    private LuceneIndexer getThreadLocalIndexer(StoreRef storeRef) {
        LuceneIndexer indexer;
        HashMap<StoreRef, LuceneIndexer> indexers = (HashMap<StoreRef, LuceneIndexer>)AlfrescoTransactionSupport.getResource(this.indexersKey);
        if (indexers == null) {
            indexers = new HashMap<StoreRef, LuceneIndexer>();
            AlfrescoTransactionSupport.bindResource(this.indexersKey, indexers);
        }
        if ((indexer = (LuceneIndexer)indexers.get(storeRef)) == null) {
            indexer = this.createIndexer(storeRef, GUID.generate());
            indexers.put(storeRef, indexer);
        }
        return indexer;
    }

    private String getTransactionId(Transaction tx, StoreRef storeRef) {
        LuceneIndexer indexer;
        Map indexers;
        if (tx instanceof SimpleTransaction) {
            SimpleTransaction simpleTx = (SimpleTransaction)tx;
            return simpleTx.getGUID();
        }
        if (TransactionSynchronizationManager.isSynchronizationActive() && (indexers = (Map)AlfrescoTransactionSupport.getResource(this.indexersKey)) != null && (indexer = (LuceneIndexer)indexers.get(storeRef)) != null) {
            return indexer.getDeltaId();
        }
        return null;
    }

    protected abstract LuceneIndexer createIndexer(StoreRef var1, String var2);

    @Override
    public LuceneSearcher getSearcher(StoreRef storeRef, boolean searchDelta) throws SearcherException {
        storeRef = this.tenantService.getName(storeRef);
        String deltaId = null;
        LuceneIndexer indexer = null;
        if (searchDelta && (deltaId = this.getTransactionId(this.getTransaction(), storeRef)) != null) {
            indexer = this.getIndexer(storeRef);
        }
        LuceneSearcher searcher = this.getSearcher(storeRef, indexer);
        return searcher;
    }

    protected abstract SearchService getNodeSearcher() throws SearcherException;

    protected abstract LuceneSearcher getSearcher(StoreRef var1, LuceneIndexer var2) throws SearcherException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        block10: {
            block9: {
                block8: {
                    try {
                        Map<StoreRef, LuceneIndexer> indexers = this.activeIndexersInGlobalTx.get(xid);
                        if (indexers == null) {
                            if (this.suspendedIndexersInGlobalTx.containsKey(xid)) {
                                throw new XAException("Trying to commit indexes for a suspended transaction.");
                            }
                            Object var7_4 = null;
                            this.activeIndexersInGlobalTx.remove(xid);
                            return;
                        }
                        if (onePhase) {
                            if (indexers.size() == 0) {
                                break block8;
                            }
                            if (indexers.size() != 1) throw new XAException("Trying to do one phase commit on more than one index");
                            for (LuceneIndexer indexer : indexers.values()) {
                                indexer.commit();
                            }
                            break block9;
                        }
                        for (LuceneIndexer indexer : indexers.values()) {
                            indexer.commit();
                        }
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        this.activeIndexersInGlobalTx.remove(xid);
                        throw throwable;
                    }
                }
                Object var7_5 = null;
                this.activeIndexersInGlobalTx.remove(xid);
                return;
            }
            Object var7_6 = null;
            this.activeIndexersInGlobalTx.remove(xid);
            return;
        }
        Object var7_7 = null;
        this.activeIndexersInGlobalTx.remove(xid);
    }

    @Override
    public void end(Xid xid, int flag) throws XAException {
        Map<StoreRef, LuceneIndexer> indexers = this.activeIndexersInGlobalTx.get(xid);
        if (indexers == null) {
            if (this.suspendedIndexersInGlobalTx.containsKey(xid)) {
                throw new XAException("Trying to commit indexes for a suspended transaction.");
            }
            return;
        }
        if (flag == 0x2000000) {
            this.activeIndexersInGlobalTx.remove(xid);
            this.suspendedIndexersInGlobalTx.put(xid, indexers);
        } else if (flag == 0x20000000) {
            this.activeIndexersInGlobalTx.remove(xid);
            this.suspendedIndexersInGlobalTx.remove(xid);
        } else if (flag == 0x4000000) {
            this.activeIndexersInGlobalTx.remove(xid);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.activeIndexersInGlobalTx.remove(xid);
        this.suspendedIndexersInGlobalTx.remove(xid);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    @Override
    public boolean isSameRM(XAResource xar) throws XAException {
        return xar instanceof AbstractLuceneIndexerAndSearcherFactory;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        Map<StoreRef, LuceneIndexer> indexers = this.activeIndexersInGlobalTx.get(xid);
        if (indexers == null) {
            if (this.suspendedIndexersInGlobalTx.containsKey(xid)) {
                throw new XAException("Trying to commit indexes for a suspended transaction.");
            }
            return 0;
        }
        boolean isPrepared = true;
        boolean isModified = false;
        for (LuceneIndexer indexer : indexers.values()) {
            try {
                isModified |= indexer.isModified();
                indexer.prepare();
            }
            catch (IndexerException e) {
                isPrepared = false;
            }
        }
        if (isPrepared) {
            if (isModified) {
                return 0;
            }
            return 3;
        }
        throw new XAException("Failed to prepare: requires rollback");
    }

    @Override
    public Xid[] recover(int arg0) throws XAException {
        return new Xid[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            Map<StoreRef, LuceneIndexer> indexers = this.activeIndexersInGlobalTx.get(xid);
            if (indexers == null) {
                if (this.suspendedIndexersInGlobalTx.containsKey(xid)) {
                    throw new XAException("Trying to commit indexes for a suspended transaction.");
                }
                Object var6_3 = null;
                this.activeIndexersInGlobalTx.remove(xid);
                return;
            }
            for (LuceneIndexer indexer : indexers.values()) {
                indexer.rollback();
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.activeIndexersInGlobalTx.remove(xid);
            throw throwable;
        }
        Object var6_4 = null;
        this.activeIndexersInGlobalTx.remove(xid);
    }

    @Override
    public boolean setTransactionTimeout(int timeout) throws XAException {
        this.timeout = timeout;
        return true;
    }

    @Override
    public void start(Xid xid, int flag) throws XAException {
        Map<StoreRef, LuceneIndexer> active = this.activeIndexersInGlobalTx.get(xid);
        Map<StoreRef, LuceneIndexer> suspended = this.suspendedIndexersInGlobalTx.get(xid);
        if (flag == 0x200000) {
            if (active != null && suspended == null) {
                return;
            }
            throw new XAException("Trying to rejoin transaction in an invalid state");
        }
        if (flag == 0x8000000) {
            if (active == null && suspended != null) {
                this.suspendedIndexersInGlobalTx.remove(xid);
                this.activeIndexersInGlobalTx.put(xid, suspended);
                return;
            }
            throw new XAException("Trying to rejoin transaction in an invalid state");
        }
        if (flag == 0) {
            if (active == null && suspended == null) {
                return;
            }
            throw new XAException("Trying to start an existing or suspended transaction");
        }
        throw new XAException("Unkown flags for start " + flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws IndexerException {
        block7: {
            Map indexers = null;
            try {
                indexers = (Map)AlfrescoTransactionSupport.getResource(this.indexersKey);
                if (indexers != null) {
                    for (LuceneIndexer indexer : indexers.values()) {
                        try {
                            indexer.commit();
                        }
                        catch (IndexerException e) {
                            this.rollback();
                            throw e;
                        }
                    }
                }
                Object var6_5 = null;
                if (indexers == null) break block7;
                indexers.clear();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (indexers != null) {
                    indexers.clear();
                    AlfrescoTransactionSupport.unbindResource(this.indexersKey);
                }
                throw throwable;
            }
            AlfrescoTransactionSupport.unbindResource(this.indexersKey);
            {
            }
        }
    }

    @Override
    public int prepare() throws IndexerException {
        boolean isPrepared = true;
        boolean isModified = false;
        Map indexers = (Map)AlfrescoTransactionSupport.getResource(this.indexersKey);
        if (indexers != null) {
            for (LuceneIndexer indexer : indexers.values()) {
                try {
                    isModified |= indexer.isModified();
                    indexer.prepare();
                }
                catch (IndexerException e) {
                    isPrepared = false;
                    throw new IndexerException("Failed to prepare: requires rollback", (Throwable)((Object)e));
                }
            }
        }
        if (isPrepared) {
            if (isModified) {
                return 0;
            }
            return 3;
        }
        throw new IndexerException("Failed to prepare: requires rollback");
    }

    @Override
    public void rollback() {
        Map indexers = (Map)AlfrescoTransactionSupport.getResource(this.indexersKey);
        if (indexers != null) {
            for (LuceneIndexer indexer : indexers.values()) {
                try {
                    indexer.rollback();
                }
                catch (IndexerException e) {}
            }
            indexers.clear();
            AlfrescoTransactionSupport.unbindResource(this.indexersKey);
        }
    }

    @Override
    public void flush() {
        Map indexers = (Map)AlfrescoTransactionSupport.getResource(this.indexersKey);
        if (indexers != null) {
            for (LuceneIndexer indexer : indexers.values()) {
                indexer.flushPending();
            }
        }
    }

    @Override
    public String getIndexRootLocation() {
        return this.indexRootLocation;
    }

    @Override
    public int getIndexerBatchSize() {
        return this.indexerBatchSize;
    }

    public void setIndexerBatchSize(int indexerBatchSize) {
        this.indexerBatchSize = indexerBatchSize;
    }

    public String getLockDirectory() {
        return this.lockDirectory;
    }

    @Override
    public void setLockDirectory(String lockDirectory) {
        File[] children;
        this.lockDirectory = lockDirectory;
        System.setProperty("org.apache.lucene.lockDir", lockDirectory);
        File lockDir = new File(lockDirectory);
        if (!lockDir.exists()) {
            lockDir.mkdirs();
        }
        if ((children = lockDir.listFiles()) != null) {
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                if (!child.isFile() || !child.exists() || child.delete() || !child.exists()) continue;
                throw new IllegalStateException("Failed to delete " + child);
            }
        }
    }

    @Override
    public int getQueryMaxClauses() {
        return this.queryMaxClauses;
    }

    public void setQueryMaxClauses(int queryMaxClauses) {
        this.queryMaxClauses = queryMaxClauses;
        BooleanQuery.setMaxClauseCount((int)this.queryMaxClauses);
    }

    public void setWriteLockTimeout(long timeout) {
        this.writeLockTimeout = timeout;
    }

    public void setCommitLockTimeout(long timeout) {
        this.commitLockTimeout = timeout;
    }

    public long getCommitLockTimeout() {
        return this.commitLockTimeout;
    }

    public long getWriteLockTimeout() {
        return this.writeLockTimeout;
    }

    public void setLockPollInterval(long time) {
        Lock.LOCK_POLL_INTERVAL = time;
    }

    @Override
    public int getIndexerMaxFieldLength() {
        return this.indexerMaxFieldLength;
    }

    public void setIndexerMaxFieldLength(int indexerMaxFieldLength) {
        this.indexerMaxFieldLength = indexerMaxFieldLength;
    }

    @Override
    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    @Override
    public MLAnalysisMode getDefaultMLIndexAnalysisMode() {
        return this.defaultMLIndexAnalysisMode;
    }

    public void setDefaultMLIndexAnalysisMode(MLAnalysisMode mode) {
        this.defaultMLIndexAnalysisMode = mode;
    }

    @Override
    public MLAnalysisMode getDefaultMLSearchAnalysisMode() {
        return this.defaultMLSearchAnalysisMode;
    }

    public void setDefaultMLSearchAnalysisMode(MLAnalysisMode mode) {
        this.defaultMLSearchAnalysisMode = mode;
    }

    @Override
    public int getMaxDocIdCacheSize() {
        return this.maxDocIdCacheSize;
    }

    public void setMaxDocIdCacheSize(int maxDocIdCacheSize) {
        this.maxDocIdCacheSize = maxDocIdCacheSize;
    }

    @Override
    public int getMaxDocsForInMemoryMerge() {
        return this.maxDocsForInMemoryMerge;
    }

    public void setMaxDocsForInMemoryMerge(int maxDocsForInMemoryMerge) {
        this.maxDocsForInMemoryMerge = maxDocsForInMemoryMerge;
    }

    @Override
    public int getMaxDocumentCacheSize() {
        return this.maxDocumentCacheSize;
    }

    public void setMaxDocumentCacheSize(int maxDocumentCacheSize) {
        this.maxDocumentCacheSize = maxDocumentCacheSize;
    }

    @Override
    public int getMaxIsCategoryCacheSize() {
        return this.maxIsCategoryCacheSize;
    }

    public void setMaxIsCategoryCacheSize(int maxIsCategoryCacheSize) {
        this.maxIsCategoryCacheSize = maxIsCategoryCacheSize;
    }

    @Override
    public int getMaxLinkAspectCacheSize() {
        return this.maxLinkAspectCacheSize;
    }

    public void setMaxLinkAspectCacheSize(int maxLinkAspectCacheSize) {
        this.maxLinkAspectCacheSize = maxLinkAspectCacheSize;
    }

    @Override
    public int getMaxParentCacheSize() {
        return this.maxParentCacheSize;
    }

    public void setMaxParentCacheSize(int maxParentCacheSize) {
        this.maxParentCacheSize = maxParentCacheSize;
    }

    @Override
    public int getMaxPathCacheSize() {
        return this.maxPathCacheSize;
    }

    public void setMaxPathCacheSize(int maxPathCacheSize) {
        this.maxPathCacheSize = maxPathCacheSize;
    }

    @Override
    public int getMaxTypeCacheSize() {
        return this.maxTypeCacheSize;
    }

    public void setMaxTypeCacheSize(int maxTypeCacheSize) {
        this.maxTypeCacheSize = maxTypeCacheSize;
    }

    @Override
    public int getMergerMaxMergeDocs() {
        return this.mergerMaxMergeDocs;
    }

    public void setMergerMaxMergeDocs(int mergerMaxMergeDocs) {
        this.mergerMaxMergeDocs = mergerMaxMergeDocs;
    }

    @Override
    public int getMergerMergeFactor() {
        return this.mergerMergeFactor;
    }

    public void setMergerMergeFactor(int mergerMergeFactor) {
        this.mergerMergeFactor = mergerMergeFactor;
    }

    @Override
    public int getMergerMergeBlockingFactor() {
        return this.mergerMergeBlockingFactor;
    }

    public void setMergerMergeBlockingFactor(int mergerMergeBlockingFactor) {
        this.mergerMergeBlockingFactor = mergerMergeBlockingFactor;
    }

    @Override
    public int getMergerMaxBufferedDocs() {
        return this.mergerMaxBufferedDocs;
    }

    public void setMergerMaxBufferedDocs(int mergerMaxBufferedDocs) {
        this.mergerMaxBufferedDocs = mergerMaxBufferedDocs;
    }

    @Override
    public int getMergerTargetIndexCount() {
        return this.mergerTargetIndexCount;
    }

    public void setMergerTargetIndexCount(int mergerTargetIndexCount) {
        this.mergerTargetIndexCount = mergerTargetIndexCount;
    }

    @Override
    public int getMergerTargetOverlayCount() {
        return this.mergerTargetOverlayCount;
    }

    public void setMergerTargetOverlayCount(int mergerTargetOverlayCount) {
        this.mergerTargetOverlayCount = mergerTargetOverlayCount;
    }

    @Override
    public int getMergerTargetOverlaysBlockingFactor() {
        return this.mergerTargetOverlaysBlockingFactor;
    }

    public void setMergerTargetOverlaysBlockingFactor(int mergerTargetOverlaysBlockingFactor) {
        this.mergerTargetOverlaysBlockingFactor = mergerTargetOverlaysBlockingFactor;
    }

    @Override
    public boolean getFairLocking() {
        return this.fairLocking;
    }

    public void setFairLocking(boolean fairLocking) {
        this.fairLocking = fairLocking;
    }

    @Override
    public int getTermIndexInterval() {
        return this.termIndexInterval;
    }

    public void setTermIndexInterval(int termIndexInterval) {
        this.termIndexInterval = termIndexInterval;
    }

    @Override
    public boolean getUseNioMemoryMapping() {
        return this.useNioMemoryMapping;
    }

    public void setUseNioMemoryMapping(boolean useNioMemoryMapping) {
        this.useNioMemoryMapping = useNioMemoryMapping;
    }

    @Override
    public int getWriterMaxMergeDocs() {
        return this.writerMaxMergeDocs;
    }

    public void setWriterMaxMergeDocs(int writerMaxMergeDocs) {
        this.writerMaxMergeDocs = writerMaxMergeDocs;
    }

    @Override
    public int getWriterMergeFactor() {
        return this.writerMergeFactor;
    }

    public void setWriterMergeFactor(int writerMergeFactor) {
        this.writerMergeFactor = writerMergeFactor;
    }

    @Override
    public int getWriterMaxBufferedDocs() {
        return this.writerMaxBufferedDocs;
    }

    public void setWriterMaxBufferedDocs(int writerMaxBufferedDocs) {
        this.writerMaxBufferedDocs = writerMaxBufferedDocs;
    }

    @Override
    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    @Override
    public boolean getPostSortDateTime() {
        return this.postSortDateTime;
    }

    public void setPostSortDateTime(boolean postSortDateTime) {
        this.postSortDateTime = postSortDateTime;
    }

    public void registerQueryLanguage(LuceneQueryLanguageSPI queryLanguage) {
        this.queryLanguages.put(queryLanguage.getName().toLowerCase(), queryLanguage);
    }

    @Override
    public int getMaxDocsForInMemoryIndex() {
        return this.maxDocsForInMemoryIndex;
    }

    public void setMaxDocsForInMemoryIndex(int maxDocsForInMemoryIndex) {
        this.maxDocsForInMemoryIndex = maxDocsForInMemoryIndex;
    }

    @Override
    public double getMaxRamInMbForInMemoryMerge() {
        return this.maxRamInMbForInMemoryMerge;
    }

    public void setMaxRamInMbForInMemoryMerge(double maxRamInMbForInMemoryMerge) {
        this.maxRamInMbForInMemoryMerge = maxRamInMbForInMemoryMerge;
    }

    @Override
    public double getMaxRamInMbForInMemoryIndex() {
        return this.maxRamInMbForInMemoryIndex;
    }

    public void setMaxRamInMbForInMemoryIndex(double maxRamInMbForInMemoryIndex) {
        this.maxRamInMbForInMemoryIndex = maxRamInMbForInMemoryIndex;
    }

    @Override
    public double getMergerRamBufferSizeMb() {
        return this.mergerRamBufferSizeMb;
    }

    public void setMergerRamBufferSizeMb(double mergerRamBufferSizeMb) {
        this.mergerRamBufferSizeMb = mergerRamBufferSizeMb;
    }

    @Override
    public double getWriterRamBufferSizeMb() {
        return this.writerRamBufferSizeMb;
    }

    public void setWriterRamBufferSizeMb(double writerRamBufferSizeMb) {
        this.writerRamBufferSizeMb = writerRamBufferSizeMb;
    }

    protected LuceneQueryLanguageSPI getQueryLanguage(String name) {
        return this.queryLanguages.get(name);
    }

    protected abstract List<StoreRef> getAllStores();

    @Override
    public <R> R doReadOnly(LuceneIndexerAndSearcher.ReadOnlyWork<R> lockWork) {
        List<StoreRef> storeRefs = this.getAllStores();
        IndexInfo.LockWork<R> currentLockWork = null;
        for (int i = storeRefs.size() - 1; i >= 0; --i) {
            currentLockWork = currentLockWork == null ? new CoreReadOnlyWork<R>(this.getIndexer(storeRefs.get(i)), lockWork) : new NestingReadOnlyWork(this.getIndexer(storeRefs.get(i)), currentLockWork);
        }
        if (currentLockWork != null) {
            try {
                return (R)currentLockWork.doWork();
            }
            catch (Throwable exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new RuntimeException("Error during run with lock.", exception);
            }
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            return;
        }
        File file = new File(args[0]);
        AbstractLuceneIndexerAndSearcherFactory.deleteDirectory(file);
    }

    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Not a directory " + directory);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Failed to delete director - no access" + directory);
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            System.out.println(".");
            if (file.isDirectory()) {
                AbstractLuceneIndexerAndSearcherFactory.deleteDirectory(file);
                continue;
            }
            if (file.delete()) continue;
            throw new IOException("Unable to delete file: " + file);
        }
        if (!directory.delete()) {
            throw new IOException("Unable to delete directory " + directory);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CoreReadOnlyWork<R>
    implements IndexInfo.LockWork<R> {
        LuceneIndexerAndSearcher.ReadOnlyWork<R> lockWork;
        LuceneIndexer indexer;

        CoreReadOnlyWork(LuceneIndexer indexer, LuceneIndexerAndSearcher.ReadOnlyWork<R> lockWork) {
            this.indexer = indexer;
            this.lockWork = lockWork;
        }

        @Override
        public R doWork() throws Exception {
            return this.indexer.doReadOnly(new IndexInfo.LockWork<R>(){

                @Override
                public R doWork() {
                    try {
                        return CoreReadOnlyWork.this.lockWork.doWork();
                    }
                    catch (Throwable exception) {
                        if (exception instanceof RuntimeException) {
                            throw (RuntimeException)exception;
                        }
                        throw new RuntimeException("Error during run with lock.", exception);
                    }
                }

                @Override
                public boolean canRetry() {
                    return false;
                }
            });
        }

        @Override
        public boolean canRetry() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NestingReadOnlyWork<R>
    implements IndexInfo.LockWork<R> {
        IndexInfo.LockWork<R> lockWork;
        LuceneIndexer indexer;

        NestingReadOnlyWork(LuceneIndexer indexer, IndexInfo.LockWork<R> lockWork) {
            this.indexer = indexer;
            this.lockWork = lockWork;
        }

        @Override
        public R doWork() throws Exception {
            return this.indexer.doReadOnly(this.lockWork);
        }

        @Override
        public boolean canRetry() {
            return false;
        }
    }

    public static class LuceneIndexBackupJob
    implements Job {
        public static final String KEY_LUCENE_INDEX_BACKUP_COMPONENT = "luceneIndexBackupComponent";

        public void execute(JobExecutionContext context) throws JobExecutionException {
            JobDataMap jobData = context.getJobDetail().getJobDataMap();
            LuceneIndexBackupComponent backupComponent = (LuceneIndexBackupComponent)jobData.get((Object)KEY_LUCENE_INDEX_BACKUP_COMPONENT);
            if (backupComponent == null) {
                throw new JobExecutionException("Missing job data: luceneIndexBackupComponent");
            }
            backupComponent.backup();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LuceneIndexBackupComponent {
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        boolean executing = false;
        private static String BACKUP_TEMP_NAME = ".indexbackup_temp";
        private TransactionService transactionService;
        private Set<LuceneIndexerAndSearcher> factories;
        private NodeService nodeService;
        private String targetLocation;
        private boolean checkConfiguration = true;

        public void setCheckConfiguration(boolean checkConfiguration) {
            this.checkConfiguration = checkConfiguration;
        }

        public void setTransactionService(TransactionService transactionService) {
            this.transactionService = transactionService;
        }

        public void setFactories(Set<LuceneIndexerAndSearcher> factories) {
            this.factories = factories;
        }

        public void setNodeService(NodeService nodeService) {
            this.nodeService = nodeService;
        }

        public void setTargetLocation(String targetLocation) {
            this.targetLocation = targetLocation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void backup() {
            Object v1;
            block11: {
                this.rwLock.readLock().lock();
                try {
                    if (this.executing) {
                        Object var2_1 = null;
                        this.rwLock.readLock().unlock();
                        return;
                    }
                    Object var2_2 = null;
                    this.rwLock.readLock().unlock();
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    this.rwLock.readLock().unlock();
                    throw throwable;
                }
                this.rwLock.writeLock().lock();
                try {
                    if (this.executing) {
                        Object var4_6 = null;
                        this.rwLock.writeLock().unlock();
                        return;
                    }
                    this.executing = true;
                }
                catch (Throwable throwable) {
                    Object var4_8 = null;
                    this.rwLock.writeLock().unlock();
                    throw throwable;
                }
                Object var4_7 = null;
                this.rwLock.writeLock().unlock();
                try {
                    RetryingTransactionHelper.RetryingTransactionCallback<Object> backupWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                        @Override
                        public Object execute() throws Exception {
                            LuceneIndexBackupComponent.this.backupImpl();
                            return null;
                        }
                    };
                    this.transactionService.getRetryingTransactionHelper().doInTransaction(backupWork);
                    Object var6_10 = null;
                    this.rwLock.writeLock().lock();
                }
                catch (Throwable throwable) {
                    Object v0;
                    Object var6_11 = null;
                    this.rwLock.writeLock().lock();
                    try {
                        this.executing = false;
                        v0 = null;
                    }
                    catch (Throwable throwable2) {
                        v0 = null;
                    }
                    Object var8_15 = v0;
                    this.rwLock.writeLock().unlock();
                    throw throwable;
                }
                try {
                    this.executing = false;
                    v1 = null;
                    break block11;
                }
                catch (Throwable throwable) {
                    v1 = null;
                }
                {
                }
            }
            Object var8_14 = v1;
            this.rwLock.writeLock().unlock();
        }

        private void backupImpl() {
            File targetDir = new File(this.targetLocation);
            if (targetDir.exists() && !targetDir.isDirectory()) {
                throw new AlfrescoRuntimeException("Target location is a file and not a directory: " + targetDir);
            }
            File targetParentDir = targetDir.getParentFile();
            if (targetParentDir == null) {
                throw new AlfrescoRuntimeException("Target location may not be a root directory: " + targetDir);
            }
            File tempDir = new File(targetParentDir, BACKUP_TEMP_NAME);
            for (LuceneIndexerAndSearcher factory : this.factories) {
                BackUpReadOnlyWork backupWork = new BackUpReadOnlyWork(factory, tempDir, targetDir);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Backing up Lucene indexes: \n   Target directory: " + targetDir));
                }
                factory.doReadOnly(backupWork);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Backed up Lucene indexes: \n   Target directory: " + targetDir));
            }
        }

        public void afterPropertiesSetXXX() throws Exception {
            RetryingTransactionHelper.RetryingTransactionCallback<Object> backupWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                @Override
                public Object execute() throws Exception {
                    List stores;
                    File targetDir = new File(LuceneIndexBackupComponent.this.targetLocation).getCanonicalFile();
                    try {
                        stores = LuceneIndexBackupComponent.this.nodeService.getStores();
                    }
                    catch (Exception e) {
                        return null;
                    }
                    HashSet<String> protocols = new HashSet<String>();
                    protocols.add("avm");
                    protocols.add("archive");
                    protocols.add("workspace");
                    protocols.add("locks");
                    for (StoreRef store : stores) {
                        protocols.add(store.getProtocol());
                    }
                    for (LuceneIndexerAndSearcher factory : LuceneIndexBackupComponent.this.factories) {
                        File indexRootDir = new File(factory.getIndexRootLocation()).getCanonicalFile();
                        if (indexRootDir.getCanonicalPath().startsWith(targetDir.getCanonicalPath())) {
                            throw new IllegalArgumentException("Backup directory can not contain or be an index directory");
                        }
                        if (targetDir.getCanonicalPath().startsWith(indexRootDir.getCanonicalPath())) {
                            for (String name : protocols) {
                                File test = new File(indexRootDir, name);
                                if (!targetDir.getCanonicalPath().startsWith(test.getCanonicalPath())) continue;
                                throw new IllegalArgumentException("Backup directory can not be in index directory and match a store protocol name " + targetDir);
                            }
                        }
                        if (!targetDir.exists()) continue;
                        for (File file : targetDir.listFiles()) {
                            if (file.isFile()) {
                                throw new IllegalArgumentException("Existing index backup does not look like the expected structure. It constains a file " + file.getCanonicalPath());
                            }
                            if (protocols.contains(file.getName())) continue;
                            throw new IllegalArgumentException("Existing index backup does not look like the expected structure. It constains a directory with a name that does not match a store protocol " + file.getCanonicalPath());
                        }
                    }
                    return null;
                }
            };
            if (this.checkConfiguration) {
                this.transactionService.getRetryingTransactionHelper().doInTransaction(backupWork, true);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class BackUpReadOnlyWork
        implements LuceneIndexerAndSearcher.ReadOnlyWork<Object> {
            LuceneIndexerAndSearcher factory;
            File tempDir;
            File targetDir;

            BackUpReadOnlyWork(LuceneIndexerAndSearcher factory, File tempDir, File targetDir) {
                this.factory = factory;
                this.tempDir = tempDir;
                this.targetDir = targetDir;
            }

            @Override
            public Object doWork() {
                try {
                    File indexRootDir = new File(this.factory.getIndexRootLocation());
                    this.backupDirectory(indexRootDir, this.tempDir, this.targetDir);
                    return null;
                }
                catch (Throwable e) {
                    throw new AlfrescoRuntimeException("Failed to copy Lucene index root: \n   Index root: " + this.factory.getIndexRootLocation() + "\n" + "   Target: " + this.targetDir, e);
                }
            }

            private void backupDirectory(File sourceDir, File tempDir, File targetDir) throws Exception {
                if (!sourceDir.exists()) {
                    return;
                }
                if (tempDir.exists()) {
                    this.deleteDirectory(tempDir);
                    if (tempDir.exists()) {
                        throw new AlfrescoRuntimeException("Temp directory exists and cannot be deleted: " + tempDir);
                    }
                }
                this.copyDirectory(sourceDir, tempDir, true);
                if (!tempDir.exists()) {
                    throw new AlfrescoRuntimeException("Copy to temp location failed");
                }
                this.deleteDirectory(targetDir);
                if (targetDir.exists()) {
                    throw new AlfrescoRuntimeException("Failed to delete older files from target location");
                }
                tempDir.renameTo(targetDir);
                if (!targetDir.exists()) {
                    throw new AlfrescoRuntimeException("Failed to rename temporary directory to target backup directory");
                }
            }

            private void copyDirectory(File srcDir, File destDir, boolean preserveFileDate) throws IOException {
                if (destDir.exists()) {
                    throw new IOException("Destination should be created from clean");
                }
                if (!destDir.mkdirs()) {
                    throw new IOException("Destination '" + destDir + "' directory cannot be created");
                }
                if (preserveFileDate) {
                    destDir.setLastModified(srcDir.lastModified());
                }
                if (!destDir.canWrite()) {
                    throw new IOException("No acces to destination directory" + destDir);
                }
                File[] files = srcDir.listFiles();
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        File currentCopyTarget = new File(destDir, files[i].getName());
                        if (files[i].isDirectory()) {
                            if (files[i].getName().equals(this.tempDir.getName()) || files[i].getName().equals(this.targetDir.getName())) continue;
                            this.copyDirectory(files[i], currentCopyTarget, preserveFileDate);
                            continue;
                        }
                        this.copyFile(files[i], currentCopyTarget, preserveFileDate);
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Skipping transient directory " + srcDir));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void copyFile(File srcFile, File destFile, boolean preserveFileDate) throws IOException {
                block15: {
                    try {
                        if (destFile.exists()) {
                            throw new IOException("File shoud not exist " + destFile);
                        }
                        FileInputStream input = new FileInputStream(srcFile);
                        try {
                            FileOutputStream output = new FileOutputStream(destFile);
                            try {
                                this.copy(input, output);
                                Object var7_7 = null;
                            }
                            catch (Throwable throwable) {
                                Object var7_8 = null;
                                try {
                                    output.close();
                                }
                                catch (IOException io) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                            try {
                                output.close();
                            }
                            catch (IOException io) {}
                            Object var10_12 = null;
                        }
                        catch (Throwable throwable) {
                            Object var10_13 = null;
                            try {
                                input.close();
                            }
                            catch (IOException io) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {
                            input.close();
                        }
                        catch (IOException io) {}
                        if (srcFile.length() != destFile.length()) {
                            throw new IOException("Failed to copy full from '" + srcFile + "' to '" + destFile + "'");
                        }
                        if (preserveFileDate) {
                            destFile.setLastModified(srcFile.lastModified());
                        }
                    }
                    catch (FileNotFoundException fnfe) {
                        if (!logger.isDebugEnabled()) break block15;
                        logger.debug((Object)("Skipping transient file " + srcFile));
                    }
                }
            }

            public int copy(InputStream input, OutputStream output) throws IOException {
                byte[] buffer = new byte[8192];
                int count = 0;
                int n = 0;
                while ((n = input.read(buffer)) != -1) {
                    output.write(buffer, 0, n);
                    count += n;
                }
                return count;
            }

            public void deleteDirectory(File directory) throws IOException {
                if (!directory.exists()) {
                    return;
                }
                if (!directory.isDirectory()) {
                    throw new IllegalArgumentException("Not a directory " + directory);
                }
                File[] files = directory.listFiles();
                if (files == null) {
                    throw new IOException("Failed to delete director - no access" + directory);
                }
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (file.isDirectory()) {
                        this.deleteDirectory(file);
                        continue;
                    }
                    if (file.delete()) continue;
                    throw new IOException("Unable to delete file: " + file);
                }
                if (!directory.delete()) {
                    throw new IOException("Unable to delete directory " + directory);
                }
            }
        }
    }
}

