/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.ntlm;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.Hashtable;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationException;
import net.sf.acegisecurity.AuthenticationServiceException;
import net.sf.acegisecurity.BadCredentialsException;
import net.sf.acegisecurity.CredentialsExpiredException;
import net.sf.acegisecurity.DisabledException;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.GrantedAuthorityImpl;
import net.sf.acegisecurity.providers.AuthenticationProvider;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.jlan.server.auth.PasswordEncryptor;
import org.alfresco.jlan.server.auth.passthru.AuthenticateSession;
import org.alfresco.jlan.server.auth.passthru.PassthruServers;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.repo.security.authentication.ntlm.NTLMChallenge;
import org.alfresco.repo.security.authentication.ntlm.NTLMLocalToken;
import org.alfresco.repo.security.authentication.ntlm.NTLMPassthruToken;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NTLMAuthenticationProvider
implements AuthenticationProvider {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.acegi");
    public static final String NTLMAuthorityGuest = "Guest";
    public static final String NTLMAuthorityAdministrator = "Administrator";
    private static final long DefaultSessionTimeout = 60000L;
    private static final long MinimumSessionTimeout = 5000L;
    private PassthruServers m_passthruServers = new PassthruServers();
    private PasswordEncryptor m_encryptor = new PasswordEncryptor();
    private boolean m_allowGuest;
    private Hashtable<NTLMPassthruToken, AuthenticateSession> m_passthruSessions = new Hashtable();
    private long m_passthruSessTmo = 60000L;
    private PassthruReaperThread m_reaperThread = new PassthruReaperThread();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Authentication authenticate(Authentication auth) throws AuthenticationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authenticate " + auth));
        }
        if (auth instanceof NTLMPassthruToken) {
            NTLMPassthruToken ntlmToken = (NTLMPassthruToken)auth;
            this.authenticatePassthru(ntlmToken);
            return auth;
        }
        if (!(auth instanceof NTLMLocalToken)) return auth;
        AuthenticateSession authSess = null;
        try {
            NTLMLocalToken ntlmToken = (NTLMLocalToken)auth;
            authSess = this.m_passthruServers.openSession();
            this.authenticateLocal(ntlmToken, authSess);
            Object var5_5 = null;
            if (authSess == null) return auth;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (authSess == null) throw throwable;
            try {
                authSess.CloseSession();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex) {
            return auth;
        }
        authSess.CloseSession();
        return auth;
    }

    public boolean supports(Class authentication) {
        if (NTLMPassthruToken.class.isAssignableFrom(authentication)) {
            return true;
        }
        return NTLMLocalToken.class.isAssignableFrom(authentication);
    }

    public final boolean allowsGuest() {
        return this.m_allowGuest;
    }

    public final void setDomain(String domain) {
        if (this.m_passthruServers.getTotalServerCount() > 0) {
            throw new AlfrescoRuntimeException("Passthru server list already configured");
        }
        try {
            this.m_passthruServers.setDomain(domain);
        }
        catch (IOException ex) {
            throw new AlfrescoRuntimeException("Failed to set passthru domain", (Throwable)ex);
        }
    }

    public final void setServers(String servers) {
        if (this.m_passthruServers.getTotalServerCount() > 0) {
            throw new AlfrescoRuntimeException("Passthru server list already configured");
        }
        this.m_passthruServers.setServerList(servers);
    }

    public final void setUseLocalServer(String useLocal) {
        if (Boolean.parseBoolean(useLocal)) {
            if (this.m_passthruServers.getTotalServerCount() > 0) {
                throw new AlfrescoRuntimeException("Passthru server list already configured");
            }
            try {
                StringBuilder addrStr;
                InetAddress[] localAddrs = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
                if (localAddrs != null && localAddrs.length > 0) {
                    addrStr = new StringBuilder();
                    for (InetAddress curAddr : localAddrs) {
                        if (curAddr.isLoopbackAddress()) continue;
                        addrStr.append(curAddr.getHostAddress());
                        addrStr.append(",");
                    }
                    if (addrStr.length() > 0) {
                        addrStr.setLength(addrStr.length() - 1);
                    }
                } else {
                    throw new AlfrescoRuntimeException("No local server address(es)");
                }
                this.m_passthruServers.setServerList(addrStr.toString());
            }
            catch (UnknownHostException ex) {
                throw new AlfrescoRuntimeException("Failed to get local address list");
            }
        }
    }

    public final void setGuestAccess(String guest) {
        this.m_allowGuest = Boolean.parseBoolean(guest);
    }

    public final void setJCEProvider(String providerClass) {
        block5: {
            try {
                Object jceObj = Class.forName(providerClass).newInstance();
                if (jceObj instanceof Provider) {
                    Provider jceProvider = (Provider)jceObj;
                    Security.addProvider(jceProvider);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Using JCE provider " + providerClass));
                    }
                    break block5;
                }
                throw new AlfrescoRuntimeException("JCE provider class is not a valid Provider class");
            }
            catch (ClassNotFoundException ex) {
                throw new AlfrescoRuntimeException("JCE provider class " + providerClass + " not found");
            }
            catch (Exception ex) {
                throw new AlfrescoRuntimeException("JCE provider class error", (Throwable)ex);
            }
        }
    }

    public final void setSessionTimeout(String sessTmo) {
        try {
            long sessTmoMilli = Long.parseLong(sessTmo) * 1000L;
            if (sessTmoMilli < 5000L) {
                throw new AlfrescoRuntimeException("Authentication session timeout too low, " + sessTmo);
            }
            this.m_passthruSessTmo = sessTmoMilli;
            this.m_reaperThread.setWakeup(sessTmoMilli / 2L);
        }
        catch (NumberFormatException ex) {
            throw new AlfrescoRuntimeException("Invalid authenication session timeout value");
        }
    }

    private final long getSessionTimeout() {
        return this.m_passthruSessTmo;
    }

    private void authenticateLocal(NTLMLocalToken ntlmToken, AuthenticateSession authSess) {
        try {
            String username = (String)ntlmToken.getPrincipal();
            String plainPwd = (String)ntlmToken.getCredentials();
            byte[] ntlm1Pwd = this.m_encryptor.generateEncryptedPassword(plainPwd, authSess.getEncryptionKey(), 1, null, null);
            authSess.doSessionSetup(username, null, ntlm1Pwd);
            if (authSess.isGuest() || username.equalsIgnoreCase("GUEST")) {
                if (this.allowsGuest()) {
                    GrantedAuthority[] authorities = new GrantedAuthority[]{new GrantedAuthorityImpl(NTLMAuthorityGuest)};
                    ntlmToken.setAuthorities(authorities);
                } else {
                    throw new BadCredentialsException("Guest logons disabled");
                }
            }
            ntlmToken.setAuthenticated(true);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationServiceException("JCE provider error", (Throwable)ex);
        }
        catch (InvalidKeyException ex) {
            throw new AuthenticationServiceException("Invalid key error", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new AuthenticationServiceException("I/O error", (Throwable)ex);
        }
        catch (SMBException ex) {
            if (ex.getErrorClass() == 6) {
                Throwable authEx = null;
                switch (ex.getErrorCode()) {
                    case -1073741715: {
                        authEx = new BadCredentialsException("Logon failure");
                        break;
                    }
                    case -1073741710: {
                        authEx = new DisabledException("Account disabled");
                        break;
                    }
                    default: {
                        authEx = new BadCredentialsException("Logon failure");
                    }
                }
                throw authEx;
            }
            throw new BadCredentialsException("Logon failure");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void authenticatePassthru(NTLMPassthruToken ntlmToken) {
        AuthenticateSession authSess = this.m_passthruSessions.get((Object)ntlmToken);
        if (authSess == null) {
            if (ntlmToken.getChallenge() != null) {
                throw new CredentialsExpiredException("Authentication session expired");
            }
            authSess = this.m_passthruServers.openSession();
            ntlmToken.setAuthenticationExpireTime(System.currentTimeMillis() + this.getSessionTimeout());
            ntlmToken.setChallenge(new NTLMChallenge(authSess.getEncryptionKey()));
            StringBuilder details = new StringBuilder();
            details.append(authSess.getDomain());
            details.append("\\");
            details.append(authSess.getPCShare().getNodeName());
            details.append(",");
            details.append(authSess.getSession().getProtocolName());
            ntlmToken.setDetails(details.toString());
            this.m_passthruSessions.put(ntlmToken, authSess);
            if (!logger.isDebugEnabled()) return;
            logger.debug((Object)("Passthru stage 1 token " + (Object)((Object)ntlmToken)));
            return;
        }
        try {
            try {
                byte[] lmPwd = null;
                byte[] ntlmPwd = null;
                if (ntlmToken.getPasswordType() == 0) {
                    lmPwd = ntlmToken.getHashedPassword();
                } else if (ntlmToken.getPasswordType() == 1) {
                    ntlmPwd = ntlmToken.getHashedPassword();
                }
                String username = (String)ntlmToken.getPrincipal();
                authSess.doSessionSetup(username, lmPwd, ntlmPwd);
                if (authSess.isGuest() || username.equalsIgnoreCase("GUEST")) {
                    if (!this.allowsGuest()) throw new BadCredentialsException("Guest logons disabled");
                    GrantedAuthority[] authorities = new GrantedAuthority[]{new GrantedAuthorityImpl(NTLMAuthorityGuest)};
                    ntlmToken.setAuthorities(authorities);
                }
                ntlmToken.setAuthenticated(true);
            }
            catch (IOException ex) {
                throw new AuthenticationServiceException("I/O error", (Throwable)ex);
            }
            catch (SMBException ex) {
                if (ex.getErrorClass() != 6) throw new BadCredentialsException("Logon failure");
                Throwable authEx = null;
                switch (ex.getErrorCode()) {
                    case -1073741715: {
                        authEx = new BadCredentialsException("Logon failure");
                        throw authEx;
                    }
                    case -1073741710: {
                        authEx = new DisabledException("Account disabled");
                        throw authEx;
                    }
                }
                authEx = new BadCredentialsException("Logon failure");
                throw authEx;
            }
            Object var8_11 = null;
            if (authSess == null) return;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (authSess == null) throw throwable;
            try {
                this.m_passthruSessions.remove((Object)ntlmToken);
                authSess.CloseSession();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex) {}
        this.m_passthruSessions.remove((Object)ntlmToken);
        authSess.CloseSession();
        return;
    }

    class PassthruReaperThread
    extends Thread {
        private boolean m_ishutdown;
        private long m_wakeupInterval;

        PassthruReaperThread() {
            this.m_wakeupInterval = NTLMAuthenticationProvider.this.m_passthruSessTmo / 2L;
            this.setDaemon(true);
            this.setName("PassthruReaper");
            this.start();
        }

        public final void setWakeup(long wakeup) {
            this.m_wakeupInterval = wakeup;
        }

        public void run() {
            this.m_ishutdown = false;
            while (!this.m_ishutdown) {
                try {
                    PassthruReaperThread.sleep(this.m_wakeupInterval);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                if (NTLMAuthenticationProvider.this.m_passthruSessions.size() <= 0) continue;
                Enumeration tokenEnum = NTLMAuthenticationProvider.this.m_passthruSessions.keys();
                long timeNow = System.currentTimeMillis();
                while (tokenEnum.hasMoreElements()) {
                    NTLMPassthruToken ntlmToken;
                    block8: {
                        ntlmToken = (NTLMPassthruToken)((Object)tokenEnum.nextElement());
                        if (ntlmToken == null || ntlmToken.getAuthenticationExpireTime() >= timeNow) continue;
                        AuthenticateSession authSess = (AuthenticateSession)NTLMAuthenticationProvider.this.m_passthruSessions.get((Object)ntlmToken);
                        if (authSess != null) {
                            try {
                                authSess.CloseSession();
                            }
                            catch (Exception ex) {
                                if (!logger.isDebugEnabled()) break block8;
                                logger.debug((Object)"Error closing expired authentication session", (Throwable)ex);
                            }
                        }
                    }
                    NTLMAuthenticationProvider.this.m_passthruSessions.remove((Object)ntlmToken);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Removed expired NTLM token " + (Object)((Object)ntlmToken)));
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Passthru reaper thread shutdown");
            }
        }

        public final void shutdownRequest() {
            this.m_ishutdown = true;
            this.interrupt();
        }
    }
}

