/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.dynamic;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.DynamicAuthority;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.impl.ModelDAO;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.util.PropertyCheck;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockOwnerDynamicAuthority
extends AbstractLifecycleBean
implements DynamicAuthority {
    private LockService lockService;
    private NodeService nodeService;
    private ModelDAO modelDAO;
    private List<String> requiredFor;
    private Set<PermissionReference> whenRequired;

    @Override
    public boolean hasAuthority(final NodeRef nodeRef, final String userName) {
        return (Boolean)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                if (LockOwnerDynamicAuthority.this.lockService.getLockStatus(nodeRef, userName) == LockStatus.LOCK_OWNER) {
                    return true;
                }
                if (LockOwnerDynamicAuthority.this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY)) {
                    NodeRef original = null;
                    Serializable reference = LockOwnerDynamicAuthority.this.nodeService.getProperty(nodeRef, ContentModel.PROP_COPY_REFERENCE);
                    if (reference != null) {
                        original = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)reference);
                    }
                    if (original != null && LockOwnerDynamicAuthority.this.nodeService.exists(original)) {
                        return LockOwnerDynamicAuthority.this.lockService.getLockStatus(original, userName) == LockStatus.LOCK_OWNER;
                    }
                    return false;
                }
                return false;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    public String getAuthority() {
        return "ROLE_LOCK_OWNER";
    }

    protected void onBootstrap(ApplicationEvent event) {
        PropertyCheck.mandatory((Object)this, (String)"lockService", (Object)this.lockService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"modelDAO", (Object)this.modelDAO);
        if (this.requiredFor != null) {
            this.whenRequired = new HashSet<PermissionReference>();
            for (String permission : this.requiredFor) {
                PermissionReference permissionReference = this.modelDAO.getPermissionReference(null, permission);
                this.whenRequired.addAll(this.modelDAO.getGranteePermissions(permissionReference));
                this.whenRequired.addAll(this.modelDAO.getGrantingPermissions(permissionReference));
            }
        }
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setModelDAO(ModelDAO modelDAO) {
        this.modelDAO = modelDAO;
    }

    public void setRequiredFor(List<String> requiredFor) {
        this.requiredFor = requiredFor;
    }

    @Override
    public Set<PermissionReference> requiredFor() {
        return this.whenRequired;
    }
}

