/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.person;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.person.HomeFolderManager;
import org.alfresco.repo.security.person.HomeFolderProvider;
import org.alfresco.repo.security.person.HomeSpaceNodeRef;
import org.alfresco.repo.security.person.PermissionsManager;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractHomeFolderProvider
implements HomeFolderProvider,
BeanNameAware,
InitializingBean {
    private String name;
    private HomeFolderManager homeFolderManager;
    private StoreRef storeRef;
    private ServiceRegistry serviceRegistry;
    private TenantService tenantService;
    private String path;
    private Map<String, NodeRef> pathNodeRefs = new ConcurrentHashMap<String, NodeRef>();
    private String ownerOnCreate;
    private PermissionsManager onCreatePermissionsManager;
    private PermissionsManager onReferencePermissionsManager;

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"homeFolderManager", (Object)this.homeFolderManager);
        this.homeFolderManager.addProvider(this);
    }

    protected HomeFolderManager getHomeFolderManager() {
        return this.homeFolderManager;
    }

    public void setHomeFolderManager(HomeFolderManager homeFolderManager) {
        this.homeFolderManager = homeFolderManager;
    }

    public String getName() {
        return this.name;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    protected String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    protected StoreRef getStoreRef() {
        return this.storeRef;
    }

    public void setStoreRef(StoreRef storeRef) {
        this.storeRef = storeRef;
    }

    public void setStoreUrl(String storeUrl) {
        this.storeRef = new StoreRef(storeUrl);
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setOnCreatePermissionsManager(PermissionsManager onCreatePermissionsManager) {
        this.onCreatePermissionsManager = onCreatePermissionsManager;
    }

    public void setOnReferencePermissionsManager(PermissionsManager onReferencePermissionsManager) {
        this.onReferencePermissionsManager = onReferencePermissionsManager;
    }

    public void setOwnerOnCreate(String ownerOnCreate) {
        this.ownerOnCreate = ownerOnCreate;
    }

    protected NodeRef getPathNodeRef() {
        String tenantDomain = this.tenantService != null ? this.tenantService.getCurrentUserDomain() : "";
        NodeRef pathNodeRef = this.pathNodeRefs.get(tenantDomain);
        if (pathNodeRef == null) {
            pathNodeRef = this.resolvePath(this.path);
            this.pathNodeRefs.put(tenantDomain, pathNodeRef);
        }
        return pathNodeRef;
    }

    protected NodeRef resolvePath(String pathToResolve) {
        List refs = this.serviceRegistry.getSearchService().selectNodes(this.serviceRegistry.getNodeService().getRootNode(this.storeRef), pathToResolve, null, (NamespacePrefixResolver)this.serviceRegistry.getNamespaceService(), false);
        if (refs.size() != 1) {
            throw new IllegalStateException("Non-unique path: found : " + pathToResolve + " " + refs.size());
        }
        return (NodeRef)refs.get(0);
    }

    public void onCreateNode(ChildAssociationRef childAssocRef) {
        OnCreateNode action = new OnCreateNode(childAssocRef);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)action, (String)AuthenticationUtil.getSystemUserName());
    }

    protected abstract HomeSpaceNodeRef getHomeFolder(NodeRef var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OnCreateNode
    implements AuthenticationUtil.RunAsWork<NodeRef> {
        ChildAssociationRef childAssocRef;

        OnCreateNode(ChildAssociationRef childAssocRef) {
            this.childAssocRef = childAssocRef;
        }

        public NodeRef doWork() throws Exception {
            NodeRef personNodeRef = this.childAssocRef.getChildRef();
            HomeSpaceNodeRef homeFolder = AbstractHomeFolderProvider.this.getHomeFolder(personNodeRef);
            if (homeFolder.getNodeRef() != null) {
                String ownerToSet;
                String uid = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)AbstractHomeFolderProvider.this.serviceRegistry.getNodeService().getProperty(personNodeRef, ContentModel.PROP_USERNAME));
                if (homeFolder.getStatus() != HomeSpaceNodeRef.Status.VALID) {
                    AbstractHomeFolderProvider.this.serviceRegistry.getNodeService().setProperty(personNodeRef, ContentModel.PROP_HOMEFOLDER, (Serializable)homeFolder.getNodeRef());
                }
                String string = ownerToSet = AbstractHomeFolderProvider.this.ownerOnCreate == null ? uid : AbstractHomeFolderProvider.this.ownerOnCreate;
                if (homeFolder.getStatus() == HomeSpaceNodeRef.Status.CREATED) {
                    if (AbstractHomeFolderProvider.this.onCreatePermissionsManager != null) {
                        AbstractHomeFolderProvider.this.onCreatePermissionsManager.setPermissions(homeFolder.getNodeRef(), ownerToSet, uid);
                    }
                } else if (AbstractHomeFolderProvider.this.onReferencePermissionsManager != null) {
                    AbstractHomeFolderProvider.this.onReferencePermissionsManager.setPermissions(homeFolder.getNodeRef(), ownerToSet, uid);
                }
            }
            return homeFolder.getNodeRef();
        }
    }
}

