/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.person;

import java.util.Set;
import java.util.TreeSet;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.safehaus.uuid.UUID;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class SplitPersonCleanupBootstrapBean
extends AbstractLifecycleBean {
    protected static final Log log = LogFactory.getLog(SplitPersonCleanupBootstrapBean.class);
    private NodeService nodeService;
    private PersonService personService;
    private TransactionService transactionService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    protected void onBootstrap(ApplicationEvent event) {
        log.info((Object)"Removing person entries with GUIDS at the end of the uid ...");
        int count = this.removePeopleWithGUIDBasedIds();
        log.info((Object)("... removed " + count));
    }

    protected int removePeopleWithGUIDBasedIds() {
        Set<String> uidsToRemove = this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Set<String>>(){

            @Override
            public Set<String> execute() throws Exception {
                TreeSet<String> uidsToRemove = new TreeSet<String>();
                Set<NodeRef> people = SplitPersonCleanupBootstrapBean.this.personService.getAllPeople();
                for (NodeRef person : people) {
                    String uid = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)SplitPersonCleanupBootstrapBean.this.nodeService.getProperty(person, ContentModel.PROP_USERNAME));
                    if (!SplitPersonCleanupBootstrapBean.this.isUIDWithGUID(uid)) continue;
                    uidsToRemove.add(uid);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("... will remove person with uid " + uid));
                }
                return uidsToRemove;
            }
        });
        if (uidsToRemove.isEmpty()) {
            return 0;
        }
        BatchProcessor<String> batchProcessor = new BatchProcessor<String>("Split Person Removal", this.transactionService.getRetryingTransactionHelper(), uidsToRemove, 2, 10, (ApplicationEventPublisher)this.getApplicationContext(), log, 100);
        batchProcessor.process(new BatchProcessor.BatchProcessWorker<String>(){

            @Override
            public String getIdentifier(String entry) {
                return entry;
            }

            @Override
            public void beforeProcess() throws Throwable {
                String systemUsername = AuthenticationUtil.getSystemUserName();
                AuthenticationUtil.setFullyAuthenticatedUser((String)systemUsername);
            }

            @Override
            public void afterProcess() throws Throwable {
            }

            @Override
            public void process(String entry) throws Throwable {
                SplitPersonCleanupBootstrapBean.this.personService.deletePerson(entry);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("... removed person with uid " + entry));
                }
            }
        }, true);
        return uidsToRemove.size();
    }

    private boolean isUIDWithGUID(String uid) {
        String guidString;
        if (uid.length() > 36) {
            guidString = uid.substring(uid.length() - 36);
            try {
                UUID id = new UUID(guidString);
                return true;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (uid.length() > 38 && (guidString = uid.substring(uid.length() - 38)).startsWith("(") && guidString.endsWith(")")) {
            guidString = guidString.substring(1, 37);
            try {
                UUID id = new UUID(guidString);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    public static void main(String[] args) {
        String[] test;
        SplitPersonCleanupBootstrapBean tester = new SplitPersonCleanupBootstrapBean();
        for (String uid : test = new String[]{"andy", "andy" + GUID.generate(), "andy(" + GUID.generate() + ")", GUID.generate() + "banana", "andy" + GUID.generate() + "banana", "adbadbaddbadbadbadbabdbadbadbabdabdbbadbadbabdbadbadbadb"}) {
            System.out.println(uid + " ... is a uid with guid = " + tester.isUIDWithGUID(uid));
        }
    }
}

