/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import com.ibatis.common.jdbc.exception.NestedSQLException;
import java.lang.reflect.Method;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.transaction.RollbackException;
import javax.transaction.UserTransaction;
import net.sf.ehcache.distribution.RemoteCacheException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.error.ExceptionStackUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TooBusyException;
import org.alfresco.service.transaction.TransactionService;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.cache.CacheException;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.SQLGrammarException;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DeadlockLoserDataAccessException;
import org.springframework.jdbc.JdbcUpdateAffectedIncorrectNumberOfRowsException;
import org.springframework.jdbc.UncategorizedSQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryingTransactionHelper {
    private static final String MSG_READ_ONLY = "permissions.err_read_only";
    private static final String KEY_ACTIVE_TRANSACTION = "RetryingTransactionHelper.ActiveTxn";
    private static Log logger = LogFactory.getLog(RetryingTransactionHelper.class);
    public static final Class[] RETRY_EXCEPTIONS = new Class[]{ConcurrencyFailureException.class, DeadlockLoserDataAccessException.class, StaleObjectStateException.class, JdbcUpdateAffectedIncorrectNumberOfRowsException.class, LockAcquisitionException.class, ConstraintViolationException.class, UncategorizedSQLException.class, SQLException.class, NestedSQLException.class, BatchUpdateException.class, DataIntegrityViolationException.class, StaleStateException.class, ObjectNotFoundException.class, CacheException.class, RemoteCacheException.class, SQLGrammarException.class};
    private TransactionService txnService;
    private int maxRetries = 20;
    private int minRetryWaitMs = 100;
    private int maxRetryWaitMs = 2000;
    private int retryWaitIncrementMs = 100;
    private long maxExecutionMs;
    private SortedMap<Long, List<Throwable>> txnsInProgress = new TreeMap<Long, List<Throwable>>();
    private int txnCount;
    private boolean readOnly;
    private Random random = new Random(System.currentTimeMillis());

    public void setTransactionService(TransactionService service) {
        this.txnService = service;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setMinRetryWaitMs(int minRetryWaitMs) {
        this.minRetryWaitMs = minRetryWaitMs;
    }

    public void setMaxRetryWaitMs(int maxRetryWaitMs) {
        this.maxRetryWaitMs = maxRetryWaitMs;
    }

    public void setRetryWaitIncrementMs(int retryWaitIncrementMs) {
        if (retryWaitIncrementMs <= 0) {
            throw new IllegalArgumentException("'retryWaitIncrementMs' must be a positive integer.");
        }
        this.retryWaitIncrementMs = retryWaitIncrementMs;
    }

    public void setMaxExecutionMs(long maxExecutionMs) {
        this.maxExecutionMs = maxExecutionMs;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public <R> R doInTransaction(RetryingTransactionCallback<R> cb) {
        return this.doInTransaction(cb, false, false);
    }

    public <R> R doInTransaction(RetryingTransactionCallback<R> cb, boolean readOnly) {
        return this.doInTransaction(cb, readOnly, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R doInTransaction(RetryingTransactionCallback<R> cb, boolean readOnly, boolean requiresNew) {
        if (this.readOnly && !readOnly) {
            throw new AccessDeniedException(MSG_READ_ONLY);
        }
        boolean startingNew = requiresNew;
        if (!startingNew) {
            AlfrescoTransactionSupport.TxnReadState readState = AlfrescoTransactionSupport.getTransactionReadState();
            switch (readState) {
                case TXN_READ_ONLY: {
                    if (readOnly) break;
                    throw new AlfrescoRuntimeException("Read-Write transaction started within read-only transaction");
                }
                case TXN_READ_WRITE: {
                    break;
                }
                case TXN_NONE: {
                    startingNew = true;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown transaction state: " + (Object)((Object)readState));
                }
            }
        }
        long startTime = 0L;
        Exception stackTrace = null;
        if (startingNew && this.maxExecutionMs > 0L) {
            startTime = System.currentTimeMillis();
            RetryingTransactionHelper retryingTransactionHelper = this;
            synchronized (retryingTransactionHelper) {
                long oldestStart;
                long oldestDuration;
                if (this.txnCount > 0 && (oldestDuration = startTime - (oldestStart = this.txnsInProgress.firstKey().longValue())) > this.maxExecutionMs) {
                    throw new TooBusyException("Too busy: " + this.txnCount + " transactions. Oldest " + oldestDuration + " milliseconds", (Throwable)((List)this.txnsInProgress.get(oldestStart)).get(0));
                }
                LinkedList<Exception> traces = (LinkedList<Exception>)this.txnsInProgress.get(startTime);
                if (traces == null) {
                    traces = new LinkedList<Exception>();
                    this.txnsInProgress.put(startTime, traces);
                }
                stackTrace = new Exception("Stack trace");
                traces.add(stackTrace);
                ++this.txnCount;
            }
        }
        try {
            Throwable lastException = null;
            for (int count = 0; count == 0 || count < this.maxRetries; ++count) {
                Object proxyFactory;
                UserTransaction txn = null;
                try {
                    if (startingNew) {
                        txn = requiresNew ? this.txnService.getNonPropagatingUserTransaction(readOnly) : this.txnService.getUserTransaction(readOnly);
                        txn.begin();
                        UserTransactionProtectionAdvise advise = new UserTransactionProtectionAdvise();
                        proxyFactory = new ProxyFactory((Object)txn);
                        proxyFactory.addAdvice((Advice)advise);
                        UserTransaction wrappedTxn = (UserTransaction)proxyFactory.getProxy();
                        AlfrescoTransactionSupport.bindResource(KEY_ACTIVE_TRANSACTION, wrappedTxn);
                    }
                    R result = cb.execute();
                    if (txn != null) {
                        if (txn.getStatus() == 1) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("\nTransaction marked for rollback: \n   Thread: " + Thread.currentThread().getName() + "\n" + "   Txn:    " + txn + "\n" + "   Iteration: " + count));
                            }
                            txn.rollback();
                        } else {
                            txn.commit();
                        }
                    }
                    if (logger.isDebugEnabled() && count != 0) {
                        logger.debug((Object)("\nTransaction succeeded: \n   Thread: " + Thread.currentThread().getName() + "\n" + "   Txn:    " + txn + "\n" + "   Iteration: " + count));
                    }
                    proxyFactory = result;
                }
                catch (Throwable e) {
                    if (txn == null) {
                        RuntimeException ee = AlfrescoRuntimeException.makeRuntimeException((Throwable)e, (String)("Exception from transactional callback: " + cb), (Object[])new Object[0]);
                        throw ee;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("\nTransaction commit failed: \n   Thread: " + Thread.currentThread().getName() + "\n" + "   Txn:    " + txn + "\n" + "   Iteration: " + count + "\n" + "   Exception follows:"), e);
                    }
                    if (txn != null) {
                        try {
                            int txnStatus = txn.getStatus();
                            if (txnStatus != 6 && txnStatus != 4) {
                                txn.rollback();
                            }
                        }
                        catch (Throwable e1) {
                            logger.error((Object)"Rollback failure.  Normal retry behaviour will resume.", e1);
                        }
                    }
                    lastException = e instanceof RollbackException ? (e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new AlfrescoRuntimeException("Exception in Transaction.", e.getCause())) : (e instanceof RuntimeException ? (RuntimeException)e : new AlfrescoRuntimeException("Exception in Transaction.", e));
                    Throwable retryCause = RetryingTransactionHelper.extractRetryCause(e);
                    if (retryCause != null) {
                        int sleepIntervalRandom = count > 0 && this.retryWaitIncrementMs > 0 ? this.random.nextInt(count * this.retryWaitIncrementMs) : this.minRetryWaitMs;
                        int sleepInterval = Math.min(this.maxRetryWaitMs, sleepIntervalRandom);
                        sleepInterval = Math.max(sleepInterval, this.minRetryWaitMs);
                        if (logger.isInfoEnabled() && !logger.isDebugEnabled()) {
                            String msg = String.format("Retrying %s: count %2d; wait: %1.1fs; msg: \"%s\"; exception: (%s)", Thread.currentThread().getName(), count, (double)sleepInterval / 1000.0, retryCause.getMessage(), retryCause.getClass().getName());
                            logger.info((Object)msg);
                        }
                        try {
                            Thread.sleep(sleepInterval);
                        }
                        catch (InterruptedException ie) {}
                        continue;
                    }
                    throw lastException;
                }
                return proxyFactory;
            }
            throw lastException;
        }
        finally {
            if (startingNew && this.maxExecutionMs > 0L) {
                RetryingTransactionHelper wrappedTxn = this;
                synchronized (wrappedTxn) {
                    --this.txnCount;
                    List traces = (List)this.txnsInProgress.get(startTime);
                    if (traces != null) {
                        if (traces.size() == 1) {
                            this.txnsInProgress.remove(startTime);
                        } else {
                            traces.remove(stackTrace);
                        }
                    }
                }
            }
        }
    }

    public static Throwable extractRetryCause(Throwable cause) {
        Throwable retryCause = ExceptionStackUtil.getCause((Throwable)cause, (Class[])RETRY_EXCEPTIONS);
        if (retryCause == null) {
            return null;
        }
        if (retryCause instanceof SQLGrammarException && ((SQLGrammarException)retryCause).getErrorCode() != 3960) {
            return null;
        }
        if (retryCause instanceof NestedSQLException || retryCause instanceof UncategorizedSQLException) {
            if (retryCause.getCause() != null && retryCause.getCause() != retryCause) {
                cause = retryCause.getCause();
                if (retryCause.getMessage().toLowerCase().contains("deadlock")) {
                    return retryCause;
                }
                if (retryCause.getMessage().toLowerCase().contains("constraint")) {
                    return retryCause;
                }
                return RetryingTransactionHelper.extractRetryCause(cause);
            }
            return null;
        }
        return retryCause;
    }

    public static UserTransaction getActiveUserTransaction() {
        if (AlfrescoTransactionSupport.getTransactionReadState() == AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            return null;
        }
        UserTransaction txn = (UserTransaction)AlfrescoTransactionSupport.getResource(KEY_ACTIVE_TRANSACTION);
        if (txn == null) {
            return null;
        }
        return txn;
    }

    private static class UserTransactionProtectionAdvise
    implements MethodBeforeAdvice {
        private UserTransactionProtectionAdvise() {
        }

        public void before(Method method, Object[] args, Object target) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("begin") || methodName.equals("commit") || methodName.equals("rollback")) {
                throw new IllegalAccessException("The user transaction cannot be manipulated from within the transactional work load");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RetryingTransactionCallback<Result> {
        public Result execute() throws Throwable;
    }
}

