/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.transfer.AbstractManifestProcessorBase;
import org.alfresco.repo.transfer.AlienProcessor;
import org.alfresco.repo.transfer.CorrespondingNodeResolver;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.repo.transfer.manifest.TransferManifestDeletedNode;
import org.alfresco.repo.transfer.manifest.TransferManifestHeader;
import org.alfresco.repo.transfer.manifest.TransferManifestNormalNode;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.transfer.TransferReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepoTertiaryManifestProcessorImpl
extends AbstractManifestProcessorBase {
    private NodeService nodeService;
    private AlienProcessor alienProcessor;
    CorrespondingNodeResolver nodeResolver;
    private static final Log log = LogFactory.getLog(RepoTertiaryManifestProcessorImpl.class);
    boolean isSync = false;
    String manifestRepositoryId;

    public RepoTertiaryManifestProcessorImpl(TransferReceiver receiver, String transferId) {
        super(receiver, transferId);
    }

    protected void endManifest() {
    }

    protected void processNode(TransferManifestDeletedNode node) {
    }

    protected void processNode(TransferManifestNormalNode node) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing node with incoming noderef of " + node.getNodeRef()));
        }
        this.logComment("Tertiary Processing incoming node: " + node.getNodeRef() + " --  Source path = " + node.getParentPath() + "/" + node.getPrimaryParentAssoc().getQName());
        if (this.isSync) {
            ChildAssociationRef primaryParentAssoc = node.getPrimaryParentAssoc();
            CorrespondingNodeResolver.ResolvedParentChildPair resolvedNodes = this.nodeResolver.resolveCorrespondingNode(node.getNodeRef(), primaryParentAssoc, node.getParentPath());
            NodeRef nodeRef = resolvedNodes.resolvedChild;
            if (this.nodeService.exists(nodeRef)) {
                log.debug((Object)"destination node exists - check the children");
                List<ChildAssociationRef> expectedChildren = node.getChildAssocs();
                ArrayList<NodeRef> expectedChildNodeRefs = new ArrayList<NodeRef>();
                for (ChildAssociationRef ref : expectedChildren) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("expecting child node" + ref));
                    }
                    expectedChildNodeRefs.add(ref.getChildRef());
                }
                List actualChildren = this.nodeService.getChildAssocs(nodeRef);
                for (ChildAssociationRef child : actualChildren) {
                    NodeRef childNodeRef;
                    log.debug((Object)("checking child: " + child));
                    if (!child.isPrimary() || expectedChildNodeRefs.contains(childNodeRef = child.getChildRef()) || !this.nodeService.hasAspect(childNodeRef, TransferModel.ASPECT_TRANSFERRED)) continue;
                    log.debug((Object)("an unexpected transferred child node:" + child));
                    this.logComment("Transfer sync mode - checking unexpected child node:" + child);
                    String fromRepositoryId = (String)((Object)this.nodeService.getProperty(childNodeRef, TransferModel.PROP_FROM_REPOSITORY_ID));
                    if (fromRepositoryId != null && this.manifestRepositoryId != null) {
                        if (this.nodeService.hasAspect(childNodeRef, TransferModel.ASPECT_ALIEN)) {
                            log.debug((Object)("node to be deleted contains alien content so needs to be pruned." + childNodeRef));
                            this.logComment("Transfer sync mode - node contains alien content so can't be deleted. " + childNodeRef);
                            this.alienProcessor.pruneNode(childNodeRef, fromRepositoryId);
                            continue;
                        }
                        log.debug((Object)"node not alien");
                        if (!this.manifestRepositoryId.equalsIgnoreCase(fromRepositoryId)) continue;
                        this.logDeleted(node.getNodeRef(), childNodeRef, this.nodeService.getPath(childNodeRef));
                        this.nodeService.deleteNode(childNodeRef);
                        log.debug((Object)("deleted node:" + childNodeRef));
                        continue;
                    }
                    log.debug((Object)"node does not have a transferred aspect");
                }
            } else {
                log.debug((Object)"not sync mode - do nothing");
            }
        }
    }

    protected void processHeader(TransferManifestHeader header) {
        this.isSync = header.isSync();
        log.debug((Object)("isSync :" + this.isSync));
        this.manifestRepositoryId = header.getRepositoryId();
        log.debug((Object)("fromRepositoryId:" + this.manifestRepositoryId));
    }

    protected void startManifest() {
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setAlienProcessor(AlienProcessor alienProcessor) {
        this.alienProcessor = alienProcessor;
    }

    public AlienProcessor getAlienProcessor() {
        return this.alienProcessor;
    }

    public void setNodeResolver(CorrespondingNodeResolver nodeResolver) {
        this.nodeResolver = nodeResolver;
    }
}

