/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.alfresco.repo.transfer.TransferServiceImpl2;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.transfer.TransferCallback;
import org.alfresco.service.cmr.transfer.TransferCancelledException;
import org.alfresco.service.cmr.transfer.TransferDefinition;
import org.alfresco.service.cmr.transfer.TransferEndEvent;
import org.alfresco.service.cmr.transfer.TransferEventCancelled;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferService;
import org.alfresco.service.cmr.transfer.TransferTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferServiceImpl
implements TransferService {
    private TransferServiceImpl2 transferServiceImpl2;

    public void setTransferServiceImpl2(TransferServiceImpl2 transferServiceImpl2) {
        this.transferServiceImpl2 = transferServiceImpl2;
    }

    @Override
    public TransferTarget createTransferTarget(String name) {
        return this.transferServiceImpl2.createTransferTarget(name);
    }

    @Override
    public TransferTarget createAndSaveTransferTarget(String name, String title, String description, String endpointProtocol, String endpointHost, int endpointPort, String endpointPath, String username, char[] password) {
        return this.transferServiceImpl2.createAndSaveTransferTarget(name, title, description, endpointProtocol, endpointHost, endpointPort, endpointPath, username, password);
    }

    @Override
    public Set<TransferTarget> getTransferTargets() {
        return this.transferServiceImpl2.getTransferTargets();
    }

    @Override
    public Set<TransferTarget> getTransferTargets(String groupName) {
        return this.transferServiceImpl2.getTransferTargets(groupName);
    }

    @Override
    public void deleteTransferTarget(String name) {
        this.transferServiceImpl2.deleteTransferTarget(name);
    }

    @Override
    public void enableTransferTarget(String name, boolean enable) {
        this.transferServiceImpl2.enableTransferTarget(name, enable);
    }

    @Override
    public boolean targetExists(String name) {
        return this.transferServiceImpl2.targetExists(name);
    }

    @Override
    public TransferTarget getTransferTarget(String name) {
        return this.transferServiceImpl2.getTransferTarget(name);
    }

    @Override
    public TransferTarget saveTransferTarget(TransferTarget update) {
        return this.transferServiceImpl2.saveTransferTarget(update);
    }

    @Override
    public void transferAsync(String targetName, TransferDefinition definition, TransferCallback ... callbacks) {
        this.transferServiceImpl2.transferAsync(targetName, definition, callbacks);
    }

    @Override
    public void transferAsync(String targetName, TransferDefinition definition, Collection<TransferCallback> callbacks) {
        this.transferServiceImpl2.transferAsync(targetName, definition, callbacks);
    }

    @Override
    public NodeRef transfer(String targetName, TransferDefinition definition) {
        return this.transfer(targetName, definition, new TransferCallback[0]);
    }

    @Override
    public NodeRef transfer(String targetName, TransferDefinition definition, TransferCallback ... callbacks) {
        return this.transfer(targetName, definition, Arrays.asList(callbacks));
    }

    @Override
    public NodeRef transfer(String targetName, TransferDefinition definition, Collection<TransferCallback> callbacks) {
        TransferEndEvent event = this.transferServiceImpl2.transfer(targetName, definition, callbacks);
        if (event instanceof TransferEventCancelled) {
            throw new TransferCancelledException();
        }
        return event.getSourceReport();
    }

    @Override
    public void verify(TransferTarget target) throws TransferException {
        this.transferServiceImpl2.verify(target);
    }

    @Override
    public void cancelAsync(String transferId) {
        this.transferServiceImpl2.cancelAsync(transferId);
    }
}

