/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.integrity.IntegrityChecker;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.version.BaseVersionStoreTest;
import org.alfresco.repo.version.Version2ServiceImpl;
import org.alfresco.repo.version.VersionMigrator;
import org.alfresco.repo.version.VersionServiceImpl;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VersionMigratorTest
extends BaseVersionStoreTest {
    private static Log logger = LogFactory.getLog(VersionMigratorTest.class);
    protected VersionServiceImpl version1Service = new VersionServiceImpl();
    protected Version2ServiceImpl version2Service;
    protected NodeService versionNodeService;
    protected VersionMigrator versionMigrator;
    protected PolicyComponent policyComponent;
    protected DictionaryService dictionaryService;
    protected CheckOutCheckInService cociService;
    protected IntegrityChecker integrityChecker;

    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.versionMigrator = (VersionMigrator)this.applicationContext.getBean("versionMigrator");
        this.policyComponent = (PolicyComponent)this.applicationContext.getBean("policyComponent");
        this.dictionaryService = (DictionaryService)this.applicationContext.getBean("dictionaryService");
        this.version2Service = (Version2ServiceImpl)this.applicationContext.getBean("versionService");
        this.versionNodeService = (NodeService)this.applicationContext.getBean("versionNodeService");
        this.cociService = (CheckOutCheckInService)this.applicationContext.getBean("CheckoutCheckinService");
        this.integrityChecker = (IntegrityChecker)this.applicationContext.getBean("integrityChecker");
        this.version1Service.setDbNodeService(this.dbNodeService);
        this.version1Service.setNodeService(this.dbNodeService);
        this.version1Service.setPolicyComponent(this.policyComponent);
        this.version1Service.setDictionaryService(this.dictionaryService);
        this.version1Service.initialiseWithoutBind();
        super.setVersionService(this.version1Service);
    }

    public void testMigrateOneVersion() throws Exception {
        if (this.version2Service.useDeprecatedV1) {
            logger.info((Object)"testMigrateOneVersion: skip");
            return;
        }
        NodeRef versionableNode = this.createNewVersionableNode();
        logger.info((Object)("testMigrateOneVersion: versionedNodeRef = " + versionableNode));
        String nextVersionLabel = this.peekNextVersionLabel(versionableNode, this.versionProperties);
        Date beforeVersionDate = (Date)this.nodeService.getProperty(versionableNode, ContentModel.PROP_CREATED);
        long beforeVersionTime = beforeVersionDate.getTime();
        logger.info((Object)("beforeVersion Date/Time: " + beforeVersionDate + " [" + beforeVersionTime + "]"));
        Version oldVersion = this.createVersion(versionableNode);
        QName oldVersionType = this.versionNodeService.getType(oldVersion.getFrozenStateNodeRef());
        Set oldVersionAspects = this.versionNodeService.getAspects(oldVersion.getFrozenStateNodeRef());
        Map oldVersionProps = this.versionNodeService.getProperties(oldVersion.getFrozenStateNodeRef());
        logger.info((Object)("oldVersion props: " + oldVersion));
        logger.info((Object)("oldVersion created: " + oldVersion.getFrozenModifiedDate() + " [" + oldVersion.getFrozenModifiedDate().getTime() + "]"));
        logger.info((Object)("oldVersion props via versionNodeService: " + oldVersionProps));
        VersionHistory vh = this.version1Service.getVersionHistory(versionableNode);
        VersionMigratorTest.assertEquals((int)1, (int)vh.getAllVersions().size());
        NodeRef oldVHNodeRef = this.version1Service.getVersionHistoryNodeRef(versionableNode);
        Thread.sleep(70000L);
        NodeRef versionedNodeRef = this.versionMigrator.v1GetVersionedNodeRef(oldVHNodeRef);
        NodeRef newVHNodeRef = this.versionMigrator.migrateVersionHistory(oldVHNodeRef, versionedNodeRef);
        this.versionMigrator.v1DeleteVersionHistory(oldVHNodeRef);
        VersionHistory vh2 = this.version2Service.getVersionHistory(versionableNode);
        VersionMigratorTest.assertEquals((int)1, (int)vh2.getAllVersions().size());
        Version newVersion = vh2.getRootVersion();
        logger.info((Object)("newVersion props: " + newVersion));
        logger.info((Object)("newVersion created: " + newVersion.getFrozenModifiedDate() + " [" + newVersion.getFrozenModifiedDate().getTime() + "]"));
        super.setVersionService(this.version2Service);
        this.checkNewVersion(beforeVersionTime, nextVersionLabel, newVersion, versionableNode);
        QName newVersionType = this.versionNodeService.getType(newVersion.getFrozenStateNodeRef());
        Set newVersionAspects = this.versionNodeService.getAspects(newVersion.getFrozenStateNodeRef());
        Map newVersionProps = this.versionNodeService.getProperties(newVersion.getFrozenStateNodeRef());
        logger.info((Object)("newVersion props via versionNodeService: " + newVersionProps));
        VersionMigratorTest.assertEquals((Object)oldVersionType, (Object)newVersionType);
        VersionMigratorTest.assertEquals((int)oldVersionAspects.size(), (int)newVersionAspects.size());
        for (QName key : oldVersionAspects) {
            VersionMigratorTest.assertTrue((String)("" + key), (boolean)newVersionAspects.contains(key));
        }
        int expectedPropCount = oldVersionProps.size();
        if (oldVersionProps.get(ContentModel.PROP_ACCESSED) == null) {
            --expectedPropCount;
        }
        VersionMigratorTest.assertEquals((int)expectedPropCount, (int)newVersionProps.size());
        for (QName key : oldVersionProps.keySet()) {
            if (key.equals((Object)ContentModel.PROP_ACCESSED) && oldVersionProps.get(key) == null) continue;
            VersionMigratorTest.assertEquals((String)("" + key), oldVersionProps.get(key), newVersionProps.get(key));
        }
        VersionMigratorTest.assertEquals((String)oldVersion.getFrozenStateNodeRef().getId(), (String)newVersion.getFrozenStateNodeRef().getId());
        logger.info((Object)("testMigrateOneVersion: Migrated from oldVHNodeRef = " + oldVHNodeRef + " to newVHNodeRef = " + newVHNodeRef));
    }

    public void testMigrateMultipleVersions() throws Exception {
        if (this.version2Service.useDeprecatedV1) {
            logger.info((Object)"testMigrateOneVersion: skip");
            return;
        }
        NodeRef versionableNode = this.createNewVersionableNode();
        String nextVersionLabel1 = this.peekNextVersionLabel(versionableNode, this.versionProperties);
        long beforeVersionTime1 = ((Date)this.nodeService.getProperty(versionableNode, ContentModel.PROP_CREATED)).getTime();
        Version version1 = this.createVersion(versionableNode);
        logger.info((Object)version1);
        String nextVersionLabel2 = this.peekNextVersionLabel(versionableNode, this.versionProperties);
        long beforeVersionTime2 = ((Date)this.nodeService.getProperty(versionableNode, ContentModel.PROP_CREATED)).getTime();
        Version version2 = this.createVersion(versionableNode);
        logger.info((Object)version2);
        String nextVersionLabel3 = this.peekNextVersionLabel(versionableNode, this.versionProperties);
        long beforeVersionTime3 = ((Date)this.nodeService.getProperty(versionableNode, ContentModel.PROP_CREATED)).getTime();
        Version version3 = this.createVersion(versionableNode);
        logger.info((Object)version3);
        VersionHistory vh1 = this.version1Service.getVersionHistory(versionableNode);
        VersionMigratorTest.assertEquals((int)3, (int)vh1.getAllVersions().size());
        logger.info((Object)("testMigrateMultipleVersions: versionedNodeRef = " + versionableNode));
        NodeRef oldVHNodeRef = this.version1Service.getVersionHistoryNodeRef(versionableNode);
        NodeRef versionedNodeRef = this.versionMigrator.v1GetVersionedNodeRef(oldVHNodeRef);
        NodeRef newVHNodeRef = this.versionMigrator.migrateVersionHistory(oldVHNodeRef, versionedNodeRef);
        this.versionMigrator.v1DeleteVersionHistory(oldVHNodeRef);
        VersionHistory vh2 = this.version2Service.getVersionHistory(versionableNode);
        VersionMigratorTest.assertEquals((int)3, (int)vh2.getAllVersions().size());
        super.setVersionService(this.version2Service);
        Version[] newVersions = vh2.getAllVersions().toArray(new Version[0]);
        this.checkVersion(beforeVersionTime1, nextVersionLabel1, newVersions[2], versionableNode);
        this.checkVersion(beforeVersionTime2, nextVersionLabel2, newVersions[1], versionableNode);
        this.checkNewVersion(beforeVersionTime3, nextVersionLabel3, newVersions[0], versionableNode);
        VersionMigratorTest.assertEquals((String)version1.getFrozenStateNodeRef().getId(), (String)newVersions[2].getFrozenStateNodeRef().getId());
        VersionMigratorTest.assertEquals((String)version2.getFrozenStateNodeRef().getId(), (String)newVersions[1].getFrozenStateNodeRef().getId());
        VersionMigratorTest.assertEquals((String)version3.getFrozenStateNodeRef().getId(), (String)newVersions[0].getFrozenStateNodeRef().getId());
        logger.info((Object)("testMigrateMultipleVersions: Migrated from oldVHNodeRef = " + oldVHNodeRef + " to newVHNodeRef = " + newVHNodeRef));
    }

    public void testMigrateMultipleNodesSuccessful() throws Exception {
        this.testMigrateMultipleNodes(false);
    }

    public void test_ETHREEOH_2091() throws Exception {
        this.testMigrateMultipleNodes(true);
    }

    private void testMigrateMultipleNodes(final boolean withSkip) {
        if (this.version2Service.useDeprecatedV1) {
            logger.info((Object)"testMigrateOneVersion: skip");
            return;
        }
        int nodeCount = 5;
        final NodeRef[] versionableNodes = new NodeRef[5];
        this.setComplete();
        this.endTransaction();
        RetryingTransactionHelper txHelper = this.transactionService.getRetryingTransactionHelper();
        int i = 0;
        while (i < 5) {
            final int idx = i++;
            txHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                @Override
                public NodeRef execute() throws Throwable {
                    NodeRef versionableNode = null;
                    versionableNode = idx % 2 == 0 ? VersionMigratorTest.this.createNewVersionableNode() : VersionMigratorTest.this.createNewVersionableContentNode(true);
                    VersionMigratorTest.this.createVersion(versionableNode);
                    versionableNodes[idx] = versionableNode;
                    return null;
                }
            });
        }
        this.setComplete();
        this.endTransaction();
        txHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                for (int i = 0; i < 5; ++i) {
                    VersionHistory vh1 = VersionMigratorTest.this.version1Service.getVersionHistory(versionableNodes[i]);
                    Assert.assertNotNull((Object)vh1);
                    Assert.assertEquals((int)1, (int)vh1.getAllVersions().size());
                }
                return null;
            }
        });
        this.setComplete();
        this.endTransaction();
        if (withSkip) {
            this.dictionaryDAO.removeModel(QName.createQName((String)"http://www.alfresco.org/test/versionstorebasetest/1.0", (String)"versionstorebasetestmodel"));
        }
        txHelper = this.transactionService.getRetryingTransactionHelper();
        txHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                VersionMigratorTest.this.versionMigrator.migrateVersions(1, 1, -1, false, null, false);
                return null;
            }
        });
        this.setComplete();
        this.endTransaction();
        txHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                for (int i = 0; i < 5; ++i) {
                    VersionHistory vh2 = VersionMigratorTest.this.version2Service.getVersionHistory(versionableNodes[i]);
                    if (withSkip && i % 2 == 0) {
                        Assert.assertNull((Object)vh2);
                        continue;
                    }
                    Assert.assertNotNull((Object)vh2);
                    Assert.assertEquals((int)1, (int)vh2.getAllVersions().size());
                }
                return null;
            }
        });
    }

    private NodeRef createNewVersionableContentNode(boolean versionable) {
        this.versionableNodes = new HashMap();
        NodeRef nodeRef = this.dbNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"myNode"), ContentModel.TYPE_CONTENT, (Map)this.nodeProperties).getChildRef();
        if (versionable) {
            this.dbNodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, new HashMap());
        }
        VersionMigratorTest.assertNotNull((Object)nodeRef);
        this.versionableNodes.put(nodeRef.getId(), nodeRef);
        ContentWriter contentWriter = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.putContent("This is the versioned test content.");
        HashMap<QName, String> authorProps = new HashMap<QName, String>(1, 1.0f);
        authorProps.put(ContentModel.PROP_AUTHOR, "Charles Dickens");
        this.dbNodeService.addAspect(nodeRef, ContentModel.ASPECT_AUTHOR, authorProps);
        return nodeRef;
    }

    public void test_ETHREEOH_1540() throws Exception {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}MyVersionableNode"), TEST_TYPE_QNAME, (Map)this.nodeProperties).getChildRef();
        this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_TITLED, null);
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"name"));
        ContentWriter contentWriter = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype("text/plain");
        contentWriter.setEncoding("UTF-8");
        contentWriter.putContent("my content");
        VersionHistory vh1 = this.version1Service.getVersionHistory(nodeRef);
        VersionMigratorTest.assertNull((Object)vh1);
        this.version2Service.useDeprecatedV1 = true;
        this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        vh1 = this.version1Service.getVersionHistory(nodeRef);
        VersionMigratorTest.assertNull((Object)vh1);
        NodeRef workingCopyNodeRef = this.cociService.checkout(nodeRef);
        vh1 = this.version1Service.getVersionHistory(nodeRef);
        VersionMigratorTest.assertNull((Object)vh1);
        int v1count = 3;
        for (int i = 1; i <= v1count; ++i) {
            HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
            versionProperties.put("description", (Serializable)((Object)("This is a test checkin - " + i)));
            this.cociService.checkin(workingCopyNodeRef, versionProperties);
            vh1 = this.version1Service.getVersionHistory(nodeRef);
            VersionMigratorTest.assertEquals((int)i, (int)vh1.getAllVersions().size());
            workingCopyNodeRef = this.cociService.checkout(nodeRef);
            vh1 = this.version1Service.getVersionHistory(nodeRef);
            VersionMigratorTest.assertEquals((int)i, (int)vh1.getAllVersions().size());
        }
        NodeRef oldVHNodeRef = this.version1Service.getVersionHistoryNodeRef(nodeRef);
        this.version2Service.useDeprecatedV1 = false;
        NodeRef versionedNodeRef = this.versionMigrator.v1GetVersionedNodeRef(oldVHNodeRef);
        NodeRef newVHNodeRef = this.versionMigrator.migrateVersionHistory(oldVHNodeRef, versionedNodeRef);
        this.versionMigrator.v1DeleteVersionHistory(oldVHNodeRef);
        VersionHistory vh2 = this.version2Service.getVersionHistory(nodeRef);
        VersionMigratorTest.assertEquals((int)v1count, (int)vh2.getAllVersions().size());
        int v2count = 3;
        for (int i = 1; i <= v2count; ++i) {
            this.versionProperties = new HashMap();
            this.versionProperties.put("description", "This is a test checkin - " + (v1count + i));
            this.cociService.checkin(workingCopyNodeRef, this.versionProperties);
            vh2 = this.version2Service.getVersionHistory(nodeRef);
            VersionMigratorTest.assertEquals((int)(v1count + i), (int)vh2.getAllVersions().size());
            workingCopyNodeRef = this.cociService.checkout(nodeRef);
            vh2 = this.version2Service.getVersionHistory(nodeRef);
            VersionMigratorTest.assertEquals((int)(v1count + i), (int)vh2.getAllVersions().size());
        }
        logger.info((Object)("testMigrateOneCheckoutVersion: Migrated from oldVHNodeRef = " + oldVHNodeRef + " to newVHNodeRef = " + newVHNodeRef));
    }

    public void testMigrateVersionWithAssocs() throws Exception {
        if (this.version2Service.useDeprecatedV1) {
            logger.info((Object)"testMigrateVersionWithAssocs: skip");
            return;
        }
        NodeRef versionableNode = this.createNewVersionableNode();
        NodeRef targetNode = this.createNewNode();
        this.nodeService.createAssociation(versionableNode, targetNode, TEST_ASSOC);
        String nextVersionLabel1 = this.peekNextVersionLabel(versionableNode, this.versionProperties);
        long beforeVersionTime1 = ((Date)this.nodeService.getProperty(versionableNode, ContentModel.PROP_CREATED)).getTime();
        Version version1 = this.createVersion(versionableNode);
        logger.info((Object)version1);
        VersionHistory vh1 = this.version1Service.getVersionHistory(versionableNode);
        VersionMigratorTest.assertEquals((int)1, (int)vh1.getAllVersions().size());
        List oldChildAssocs = this.nodeService.getChildAssocs(version1.getFrozenStateNodeRef());
        List oldAssocs = this.nodeService.getTargetAssocs(version1.getFrozenStateNodeRef(), RegexQNamePattern.MATCH_ALL);
        logger.info((Object)("testMigrateVersionWithAssocs: versionedNodeRef = " + versionableNode));
        NodeRef oldVHNodeRef = this.version1Service.getVersionHistoryNodeRef(versionableNode);
        NodeRef versionedNodeRef = this.versionMigrator.v1GetVersionedNodeRef(oldVHNodeRef);
        NodeRef newVHNodeRef = this.versionMigrator.migrateVersionHistory(oldVHNodeRef, versionedNodeRef);
        this.versionMigrator.v1DeleteVersionHistory(oldVHNodeRef);
        VersionHistory vh2 = this.version2Service.getVersionHistory(versionableNode);
        VersionMigratorTest.assertEquals((int)1, (int)vh2.getAllVersions().size());
        super.setVersionService(this.version2Service);
        Version[] newVersions = vh2.getAllVersions().toArray(new Version[0]);
        Version newVersion1 = newVersions[0];
        this.checkVersion(beforeVersionTime1, nextVersionLabel1, newVersion1, versionableNode);
        List newChildAssocs = this.nodeService.getChildAssocs(newVersion1.getFrozenStateNodeRef());
        VersionMigratorTest.assertEquals((int)oldChildAssocs.size(), (int)newChildAssocs.size());
        for (ChildAssociationRef oldChildAssoc : oldChildAssocs) {
            boolean found = false;
            for (ChildAssociationRef newChildAssoc : newChildAssocs) {
                if (!newChildAssoc.getParentRef().getId().equals(oldChildAssoc.getParentRef().getId()) || !newChildAssoc.getChildRef().equals((Object)oldChildAssoc.getChildRef()) || !newChildAssoc.getTypeQName().equals((Object)oldChildAssoc.getTypeQName()) || !newChildAssoc.getQName().equals((Object)oldChildAssoc.getQName()) || newChildAssoc.isPrimary() != oldChildAssoc.isPrimary() || newChildAssoc.getNthSibling() != oldChildAssoc.getNthSibling()) continue;
                found = true;
                break;
            }
            if (found) continue;
            VersionMigratorTest.fail((String)(oldChildAssoc.toString() + " not found"));
        }
        List newAssocs = this.nodeService.getTargetAssocs(newVersion1.getFrozenStateNodeRef(), RegexQNamePattern.MATCH_ALL);
        VersionMigratorTest.assertEquals((int)oldAssocs.size(), (int)newAssocs.size());
        for (AssociationRef oldAssoc : oldAssocs) {
            boolean found = false;
            for (AssociationRef newAssoc : newAssocs) {
                if (!newAssoc.getSourceRef().getId().equals(oldAssoc.getSourceRef().getId()) || !newAssoc.getTargetRef().equals((Object)oldAssoc.getTargetRef()) || !newAssoc.getTypeQName().equals((Object)oldAssoc.getTypeQName()) || !EqualsHelper.nullSafeEquals((Object)newAssoc.getId(), (Object)oldAssoc.getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            VersionMigratorTest.fail((String)(oldAssoc.toString() + " not found"));
        }
        logger.info((Object)("testMigrateVersionWithAssocs: Migrated from oldVHNodeRef = " + oldVHNodeRef + " to newVHNodeRef = " + newVHNodeRef));
    }
}

