/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.workflow.jbpm.AlfrescoJobExecutorThread;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.job.executor.JobExecutor;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springmodules.workflow.jbpm31.JbpmFactoryLocator;

public class AlfrescoJobExecutor
extends JobExecutor {
    private static final long serialVersionUID = -4576396495395482111L;
    private static Log log = LogFactory.getLog(JobExecutor.class);
    private TransactionService transactionService;
    private JbpmConfiguration jbpmConfiguration;
    private JobLockService jobLockService;
    private boolean jobExecutorLockEnabled = true;

    public void setJobExecutorLockEnabled(boolean jobExecutorLockEnabled) {
        this.jobExecutorLockEnabled = jobExecutorLockEnabled;
    }

    public boolean getJobExecutorLockEnabled() {
        return this.jobExecutorLockEnabled;
    }

    public TransactionService getTransactionService() {
        return this.transactionService;
    }

    public JobLockService getJobLockService() {
        return this.jobLockService;
    }

    public AlfrescoJobExecutor() {
        JbpmFactoryLocator factoryLocator = new JbpmFactoryLocator();
        BeanFactoryReference factory = factoryLocator.useBeanFactory(null);
        this.transactionService = (TransactionService)factory.getFactory().getBean(ServiceRegistry.TRANSACTION_SERVICE.getLocalName());
        this.jobLockService = (JobLockService)factory.getFactory().getBean(ServiceRegistry.JOB_LOCK_SERVICE.getLocalName());
        this.jbpmConfiguration = (JbpmConfiguration)factory.getFactory().getBean("jbpm_configuration");
    }

    protected synchronized void startThread() {
        String threadName = this.getNextThreadName();
        AlfrescoJobExecutorThread thread = new AlfrescoJobExecutorThread(threadName, this, this.jbpmConfiguration, this.getIdleInterval(), this.getMaxIdleInterval(), this.getMaxLockTime(), this.getHistoryMaxSize());
        this.getThreads().put(threadName, thread);
        log.debug((Object)("starting new job executor thread '" + threadName + "'"));
        ((Thread)((Object)thread)).setDaemon(true);
        ((Thread)((Object)thread)).start();
    }
}

