/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jscript;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.jscript.ValueConverter;
import org.alfresco.repo.workflow.jscript.JscriptWorkflowDefinition;
import org.alfresco.repo.workflow.jscript.JscriptWorkflowInstance;
import org.alfresco.repo.workflow.jscript.JscriptWorkflowTask;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.mozilla.javascript.Scriptable;

public class WorkflowManager
extends BaseScopableProcessorExtension {
    private ServiceRegistry services;

    public void setServiceRegistry(ServiceRegistry services) {
        this.services = services;
    }

    public JscriptWorkflowDefinition getDefinition(String id) {
        WorkflowDefinition cmrWorkflowDefinition = this.services.getWorkflowService().getDefinitionById(id);
        return new JscriptWorkflowDefinition(cmrWorkflowDefinition, this.services, this.getScope());
    }

    public JscriptWorkflowDefinition getDefinitionByName(String name) {
        WorkflowDefinition cmrWorkflowDefinition = this.services.getWorkflowService().getDefinitionByName(name);
        return new JscriptWorkflowDefinition(cmrWorkflowDefinition, this.services, this.getScope());
    }

    public Scriptable getAssignedTasks() {
        return this.getAssignedTasksByState(WorkflowTaskState.IN_PROGRESS);
    }

    public Scriptable getCompletedTasks() {
        return this.getAssignedTasksByState(WorkflowTaskState.COMPLETED);
    }

    public JscriptWorkflowInstance getInstance(String workflowInstanceID) {
        WorkflowInstance cmrWorkflowInstance = this.services.getWorkflowService().getWorkflowById(workflowInstanceID);
        return new JscriptWorkflowInstance(cmrWorkflowInstance, this.services, this.getScope());
    }

    public Scriptable getPooledTasks(String authority) {
        List<WorkflowTask> cmrPooledTasks = this.services.getWorkflowService().getPooledTasks(authority);
        ArrayList<JscriptWorkflowTask> pooledTasks = new ArrayList<JscriptWorkflowTask>();
        for (WorkflowTask cmrPooledTask : cmrPooledTasks) {
            pooledTasks.add(new JscriptWorkflowTask(cmrPooledTask, this.services, this.getScope()));
        }
        Scriptable pooledTasksScriptable = (Scriptable)new ValueConverter().convertValueForScript(this.services, this.getScope(), null, pooledTasks);
        return pooledTasksScriptable;
    }

    public JscriptWorkflowTask getTask(String id) {
        WorkflowTask cmrWorkflowTask = this.services.getWorkflowService().getTaskById(id);
        return new JscriptWorkflowTask(cmrWorkflowTask, this.services, this.getScope());
    }

    public JscriptWorkflowTask getTaskById(String id) {
        return this.getTask(id);
    }

    public Scriptable getLatestDefinitions() {
        List<WorkflowDefinition> cmrDefinitions = this.services.getWorkflowService().getDefinitions();
        ArrayList<JscriptWorkflowDefinition> workflowDefs = new ArrayList<JscriptWorkflowDefinition>();
        for (WorkflowDefinition cmrDefinition : cmrDefinitions) {
            workflowDefs.add(new JscriptWorkflowDefinition(cmrDefinition, this.services, this.getScope()));
        }
        Scriptable workflowDefsScriptable = (Scriptable)new ValueConverter().convertValueForScript(this.services, this.getScope(), null, workflowDefs);
        return workflowDefsScriptable;
    }

    public Scriptable getAllDefinitions() {
        List<WorkflowDefinition> cmrDefinitions = this.services.getWorkflowService().getAllDefinitions();
        ArrayList<JscriptWorkflowDefinition> workflowDefs = new ArrayList<JscriptWorkflowDefinition>();
        for (WorkflowDefinition cmrDefinition : cmrDefinitions) {
            workflowDefs.add(new JscriptWorkflowDefinition(cmrDefinition, this.services, this.getScope()));
        }
        Scriptable workflowDefsScriptable = (Scriptable)new ValueConverter().convertValueForScript(this.services, this.getScope(), null, workflowDefs);
        return workflowDefsScriptable;
    }

    public ScriptNode createPackage() {
        NodeRef node = this.services.getWorkflowService().createPackage(null);
        return new ScriptNode(node, this.services);
    }

    private Scriptable getAssignedTasksByState(WorkflowTaskState state) {
        List<WorkflowTask> cmrAssignedTasks = this.services.getWorkflowService().getAssignedTasks(this.services.getAuthenticationService().getCurrentUserName(), state);
        ArrayList<JscriptWorkflowTask> assignedTasks = new ArrayList<JscriptWorkflowTask>();
        for (WorkflowTask cmrTask : cmrAssignedTasks) {
            assignedTasks.add(new JscriptWorkflowTask(cmrTask, this.services, this.getScope()));
        }
        Scriptable assignedTasksScriptable = (Scriptable)new ValueConverter().convertValueForScript(this.services, this.getScope(), null, assignedTasks);
        return assignedTasksScriptable;
    }
}

