/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.model.WCMWorkflowModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.LayeringDescriptor;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.namespace.QName;
import org.alfresco.wcm.sandbox.SandboxInfo;
import org.alfresco.wcm.util.WCMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WCMWorkflowUtil {
    private static final Log logger = LogFactory.getLog(WCMWorkflowUtil.class);

    public static NodeRef createWorkflowPackage(WorkflowService workflowService, AVMService avmService, SandboxInfo sandboxInfo) {
        String workflowMainStoreName = sandboxInfo.getMainStoreName();
        String packagesPath = WCMUtil.buildStoreRootPath(workflowMainStoreName);
        AVMNodeDescriptor packageDesc = avmService.lookup(-1, packagesPath);
        NodeRef packageNodeRef = workflowService.createPackage(AVMNodeConverter.ToNodeRef(-1, packageDesc.getPath()));
        avmService.setNodeProperty(packagesPath, WorkflowModel.PROP_IS_SYSTEM_PACKAGE, new PropertyValue(DataTypeDefinition.BOOLEAN, Boolean.valueOf(true)));
        return packageNodeRef;
    }

    public static List<WorkflowTask> getAssociatedTasksForSandbox(WorkflowService workflowService, String storeName) {
        long start = System.currentTimeMillis();
        String fromPath = WCMUtil.buildStoreRootPath(storeName);
        WorkflowTaskQuery query = new WorkflowTaskQuery();
        HashMap<QName, Object> props = new HashMap<QName, Object>(1, 1.0f);
        props.put(WCMWorkflowModel.PROP_FROM_PATH, fromPath);
        query.setProcessCustomProps(props);
        query.setActive(true);
        List<WorkflowTask> tasks = workflowService.queryTasks(query);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("getAssociatedTasksForSandbox: " + storeName + " (found " + tasks.size() + " tasks originating user sandbox " + fromPath + ") in " + (System.currentTimeMillis() - start) + " msecs"));
        }
        return tasks;
    }

    public static List<WorkflowTask> getAssociatedTasksForNode(AVMService avmService, AVMNodeDescriptor node, List<WorkflowTask> tasks) {
        LinkedList<WorkflowTask> result = new LinkedList<WorkflowTask>();
        for (WorkflowTask task : tasks) {
            NodeRef ref = task.path.instance.workflowPackage;
            String path = WCMUtil.getCorrespondingPath(node.getPath(), ref.getStoreRef().getIdentifier());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("checking store " + ref.getStoreRef().getIdentifier() + " for " + node.getPath() + " (" + path + ")"));
            }
            try {
                LayeringDescriptor ld = avmService.getLayeringInfo(-1, path);
                if (ld.isBackground()) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(path + " is in the foreground.  workflow active"));
                }
                result.add(task);
            }
            catch (AVMNotFoundException avmnfe) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)(path + " not found"));
            }
        }
        return result;
    }

    public static List<WorkflowTask> getAssociatedTasksForNode(WorkflowService workflowService, AVMService avmService, AVMNodeDescriptor node) {
        List<WorkflowTask> tasks = WCMWorkflowUtil.getAssociatedTasksForSandbox(workflowService, WCMUtil.getSandboxStoreId(node.getPath()));
        return WCMWorkflowUtil.getAssociatedTasksForNode(avmService, node, tasks);
    }

    public static List<String> getAssociatedPathsForSandbox(AVMSyncService avmSyncService, WorkflowService workflowService, String sandboxName) {
        long start = System.currentTimeMillis();
        List<WorkflowTask> tasks = WCMWorkflowUtil.getAssociatedTasksForSandbox(workflowService, sandboxName);
        List<String> storeRelativePaths = WCMWorkflowUtil.getAssociatedPathsForSandboxTasks(avmSyncService, sandboxName, tasks);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getAssociatedPathsForSandbox: " + sandboxName + " (tasks=" + tasks.size() + ", paths=" + storeRelativePaths.size() + ") in " + (System.currentTimeMillis() - start) + " msecs"));
        }
        return storeRelativePaths;
    }

    private static List<String> getAssociatedPathsForSandboxTasks(AVMSyncService avmSyncService, String sandboxName, List<WorkflowTask> tasks) {
        long start = System.currentTimeMillis();
        String stagingSandboxName = WCMUtil.buildStagingStoreName(WCMUtil.getWebProjectStoreId(sandboxName));
        ArrayList<String> storeRelativePaths = new ArrayList<String>(tasks.size());
        for (WorkflowTask task : tasks) {
            NodeRef ref = task.path.instance.workflowPackage;
            String wfPath = (String)AVMNodeConverter.ToAVMVersionPath(ref).getSecond();
            String stagingSandboxPath = WCMUtil.getCorrespondingPath(wfPath, stagingSandboxName);
            List<AVMDifference> diffs = avmSyncService.compare(-1, wfPath, -1, stagingSandboxPath, null);
            for (AVMDifference diff : diffs) {
                storeRelativePaths.add(WCMUtil.getStoreRelativePath(diff.getSourcePath()));
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("getAssociatedPathsForSandboxTasks: " + sandboxName + " (tasks=" + tasks.size() + ", paths=" + storeRelativePaths.size() + ") in " + (System.currentTimeMillis() - start) + " msecs"));
        }
        return storeRelativePaths;
    }
}

