/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.mcast;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import org.apache.catalina.cluster.MembershipListener;
import org.apache.catalina.cluster.mcast.McastMember;
import org.apache.catalina.cluster.mcast.McastMembership;
import org.apache.catalina.cluster.mcast.McastService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class McastServiceImpl {
    private static Log log = LogFactory.getLog(McastService.class);
    protected boolean doRun = false;
    protected MulticastSocket socket;
    protected McastMember member;
    protected InetAddress address;
    protected int port;
    protected long timeToExpiration;
    protected long sendFrequency;
    protected DatagramPacket sendPacket;
    protected DatagramPacket receivePacket;
    protected McastMembership membership;
    protected MembershipListener service;
    protected ReceiverThread receiver;
    protected SenderThread sender;
    protected long serviceStartTime = System.currentTimeMillis();
    protected int mcastTTL = -1;
    protected int mcastSoTimeout = -1;
    protected InetAddress mcastBindAddress = null;
    protected int recoveryCounter = 10;
    protected long recoverySleepTime = 5000L;
    protected boolean recoveryEnabled = true;
    protected Object expiredMutex = new Object();

    public McastServiceImpl(McastMember member, long sendFrequency, long expireTime, int port, InetAddress bind, InetAddress mcastAddress, int ttl, int soTimeout, MembershipListener service) throws IOException {
        this.member = member;
        this.address = mcastAddress;
        this.port = port;
        this.mcastSoTimeout = soTimeout;
        this.mcastTTL = ttl;
        this.mcastBindAddress = bind;
        this.timeToExpiration = expireTime;
        this.service = service;
        this.sendFrequency = sendFrequency;
        this.init();
    }

    protected void init() throws IOException {
        this.setupSocket();
        this.sendPacket = new DatagramPacket(new byte[1000], 1000);
        this.sendPacket.setAddress(this.address);
        this.sendPacket.setPort(this.port);
        this.receivePacket = new DatagramPacket(new byte[1000], 1000);
        this.receivePacket.setAddress(this.address);
        this.receivePacket.setPort(this.port);
        if (this.membership == null) {
            this.membership = new McastMembership(this.member.getName());
        }
    }

    protected void setupSocket() throws IOException {
        this.socket = this.mcastBindAddress != null ? new MulticastSocket(new InetSocketAddress(this.mcastBindAddress, this.port)) : new MulticastSocket(this.port);
        this.socket.setLoopbackMode(false);
        if (this.mcastBindAddress != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Setting multihome multicast interface to:" + this.mcastBindAddress));
            }
            this.socket.setInterface(this.mcastBindAddress);
        }
        if (this.mcastSoTimeout <= 0) {
            this.mcastSoTimeout = (int)this.sendFrequency;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Setting cluster mcast soTimeout to " + this.mcastSoTimeout));
        }
        this.socket.setSoTimeout(this.mcastSoTimeout);
        if (this.mcastTTL >= 0) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Setting cluster mcast TTL to " + this.mcastTTL));
            }
            this.socket.setTimeToLive(this.mcastTTL);
        }
    }

    public synchronized void start(int level) throws IOException {
        if (this.sender != null && this.receiver != null) {
            throw new IllegalStateException("Service already running.");
        }
        if (level == 1) {
            this.socket.joinGroup(this.address);
            this.doRun = true;
            this.receiver = new ReceiverThread();
            this.receiver.setDaemon(true);
            this.receiver.start();
        }
        if (level == 2) {
            this.serviceStartTime = System.currentTimeMillis();
            this.sender = new SenderThread(this.sendFrequency);
            this.sender.setDaemon(true);
            this.sender.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() throws IOException {
        try {
            this.socket.leaveGroup(this.address);
        }
        catch (IOException iOException) {
        }
        finally {
            this.doRun = false;
            if (this.sender != null) {
                this.sender.interrupt();
            }
            this.sender = null;
            if (this.receiver != null) {
                this.receiver.interrupt();
            }
            this.receiver = null;
            this.serviceStartTime = Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive() throws IOException {
        try {
            this.socket.receive(this.receivePacket);
            byte[] data = new byte[this.receivePacket.getLength()];
            System.arraycopy(this.receivePacket.getData(), this.receivePacket.getOffset(), data, 0, data.length);
            McastMember m = McastMember.getMember(data);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Mcast receive ping from member " + m));
            }
            if (this.membership.memberAlive(m)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Mcast add member " + m));
                }
                this.service.memberAdded(m);
            }
        }
        finally {
            this.checkExpire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkExpire() {
        Object object = this.expiredMutex;
        synchronized (object) {
            McastMember[] expired = this.membership.expire(this.timeToExpiration);
            for (int i = 0; i < expired.length; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Mcast exipre member " + expired[i]));
                }
                this.service.memberDisappeared(expired[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send() throws Exception {
        try {
            this.member.inc();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Mcast send ping from member " + this.member));
            }
            byte[] data = this.member.getData(this.serviceStartTime);
            DatagramPacket p = new DatagramPacket(data, data.length);
            p.setAddress(this.address);
            p.setPort(this.port);
            this.socket.send(p);
        }
        finally {
            this.checkExpire();
        }
    }

    public long getServiceStartTime() {
        return this.serviceStartTime;
    }

    public int getRecoveryCounter() {
        return this.recoveryCounter;
    }

    public boolean isRecoveryEnabled() {
        return this.recoveryEnabled;
    }

    public long getRecoverySleepTime() {
        return this.recoverySleepTime;
    }

    public void setRecoveryCounter(int recoveryCounter) {
        this.recoveryCounter = recoveryCounter;
    }

    public void setRecoveryEnabled(boolean recoveryEnabled) {
        this.recoveryEnabled = recoveryEnabled;
    }

    public void setRecoverySleepTime(long recoverySleepTime) {
        this.recoverySleepTime = recoverySleepTime;
    }

    protected static class RecoveryThread
    extends Thread {
        static boolean running = false;
        McastServiceImpl parent = null;

        public RecoveryThread(McastServiceImpl parent) {
            this.parent = parent;
            if (!RecoveryThread.init(this)) {
                parent = null;
            }
        }

        public static synchronized boolean init(RecoveryThread t) {
            if (running) {
                return false;
            }
            if (!t.parent.isRecoveryEnabled()) {
                return false;
            }
            running = true;
            t.setName("Cluster-MembershipRecovery");
            t.setDaemon(true);
            t.start();
            return true;
        }

        public boolean stopService() {
            try {
                this.parent.stop();
                return true;
            }
            catch (Exception x) {
                log.warn((Object)"Recovery thread failed to stop membership service.", (Throwable)x);
                return false;
            }
        }

        public boolean startService() {
            try {
                this.parent.init();
                this.parent.start(1);
                this.parent.start(2);
                return true;
            }
            catch (Exception x) {
                log.warn((Object)"Recovery thread failed to start membership service.", (Throwable)x);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            boolean success = false;
            int attempt = 0;
            try {
                while (!success) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Cluster membership, running recovery thread, multicasting is not functional.");
                    }
                    if (success = this.stopService()) {
                        try {
                            Thread.sleep(1000 + this.parent.mcastSoTimeout);
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                        success = this.startService();
                        if (success && log.isInfoEnabled()) {
                            log.info((Object)"Membership recovery was successful.");
                        }
                    }
                    try {
                        if (success) continue;
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Recovery attempt " + ++attempt + " failed, trying again in " + this.parent.recoverySleepTime + " milliseconds"));
                        }
                        Thread.sleep(this.parent.recoverySleepTime);
                        this.parent.checkExpire();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return;
            }
            finally {
                running = false;
            }
        }
    }

    public class SenderThread
    extends Thread {
        long time;
        McastServiceImpl service;

        public SenderThread(long time) {
            this.time = time;
            this.setName("Cluster-MembershipSender");
        }

        public void run() {
            int errorCounter = 0;
            while (McastServiceImpl.this.doRun) {
                block8: {
                    try {
                        McastServiceImpl.this.send();
                        errorCounter = 0;
                    }
                    catch (Exception x) {
                        if (errorCounter == 0) {
                            log.warn((Object)"Unable to send mcast message.", (Throwable)x);
                        } else if (log.isDebugEnabled()) {
                            log.debug((Object)"Unable to send mcast message.", (Throwable)x);
                        }
                        if (++errorCounter < McastServiceImpl.this.recoveryCounter) break block8;
                        errorCounter = 0;
                        new RecoveryThread(McastServiceImpl.this);
                    }
                }
                try {
                    Thread.sleep(this.time);
                }
                catch (Exception exception) {}
            }
            log.warn((Object)("Sender Thread ends with errorCounter=" + errorCounter + "."));
        }
    }

    public class ReceiverThread
    extends Thread {
        public ReceiverThread() {
            this.setName("Cluster-MembershipReceiver");
        }

        public void run() {
            int errorCounter = 0;
            while (McastServiceImpl.this.doRun) {
                try {
                    McastServiceImpl.this.receive();
                    errorCounter = 0;
                }
                catch (Exception x) {
                    if (errorCounter == 0) {
                        if (!(x instanceof SocketTimeoutException)) {
                            log.warn((Object)("Error receiving mcast package (errorCounter=" + errorCounter + "). Sleeping " + McastServiceImpl.this.sendFrequency + " ms"), (Throwable)x);
                        }
                    } else if (!(x instanceof SocketTimeoutException) && log.isDebugEnabled()) {
                        log.debug((Object)("Error receiving mcast package (errorCounter=" + errorCounter + "). Sleeping " + McastServiceImpl.this.sendFrequency + " ms"), (Throwable)x);
                    }
                    try {
                        Thread.sleep(McastServiceImpl.this.sendFrequency);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (++errorCounter < McastServiceImpl.this.recoveryCounter) continue;
                    log.warn((Object)("Error receiving mcast package (errorCounter=" + errorCounter + "). Try Recovery!"), (Throwable)x);
                    errorCounter = 0;
                    new RecoveryThread(McastServiceImpl.this);
                }
            }
            log.warn((Object)("Receiver Thread ends with errorCounter=" + errorCounter + "."));
        }
    }
}

