/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.session;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.cluster.CatalinaCluster;
import org.apache.catalina.cluster.ClusterManager;
import org.apache.catalina.cluster.ClusterValve;
import org.apache.catalina.cluster.session.DeltaSession;
import org.apache.catalina.cluster.session.SessionIDMessage;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JvmRouteBinderValve
extends ValveBase
implements ClusterValve,
Lifecycle {
    public static Log log = LogFactory.getLog(JvmRouteBinderValve.class);
    protected static final String info = "org.apache.catalina.cluster.session.JvmRouteBinderValve/1.3";
    protected CatalinaCluster cluster;
    protected StringManager sm = StringManager.getManager((String)"org.apache.catalina.cluster.session");
    protected boolean started = false;
    protected boolean enabled = true;
    protected long numberOfSessions = 0L;
    protected String sessionIdAttribute = "org.apache.catalina.cluster.session.JvmRouteOrignalSessionID";
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);

    public String getInfo() {
        return info;
    }

    public String getSessionIdAttribute() {
        return this.sessionIdAttribute;
    }

    public void setSessionIdAttribute(String sessionIdAttribute) {
        this.sessionIdAttribute = sessionIdAttribute;
    }

    public long getNumberOfSessions() {
        return this.numberOfSessions;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        Manager manager;
        if (this.getEnabled() && this.getCluster() != null && request.getContext() != null && request.getContext().getDistributable() && (manager = request.getContext().getManager()) != null && manager instanceof ClusterManager && this.getCluster().getManager(((ClusterManager)manager).getName()) != null) {
            this.handlePossibleTurnover(request, response);
        }
        this.getNext().invoke(request, response);
    }

    protected void handlePossibleTurnover(Request request, Response response) {
        Session session = request.getSessionInternal(false);
        if (session != null) {
            String jvmRoute;
            long t1 = 0L;
            if (log.isDebugEnabled()) {
                t1 = System.currentTimeMillis();
            }
            if ((jvmRoute = this.getLocalJvmRoute(request)) == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)this.sm.getString("jvmRoute.missingJvmRouteAttribute"));
                }
                return;
            }
            this.handleJvmRoute(request, response, session.getIdInternal(), jvmRoute);
            if (log.isDebugEnabled()) {
                long t2 = System.currentTimeMillis();
                long time = t2 - t1;
                log.debug((Object)this.sm.getString("jvmRoute.turnoverInfo", (Object)new Long(time)));
            }
        }
    }

    protected String getLocalJvmRoute(Request request) {
        Manager manager = this.getManager(request);
        if (manager instanceof ManagerBase) {
            return ((ManagerBase)manager).getJvmRoute();
        }
        return null;
    }

    protected Manager getManager(Request request) {
        Manager manager = request.getContext().getManager();
        if (log.isDebugEnabled()) {
            if (manager != null) {
                log.debug((Object)this.sm.getString("jvmRoute.foundManager", (Object)manager, (Object)request.getContext().getName()));
            } else {
                log.debug((Object)this.sm.getString("jvmRoute.notFoundManager", (Object)manager, (Object)request.getContext().getName()));
            }
        }
        return manager;
    }

    public CatalinaCluster getCluster() {
        return this.cluster;
    }

    public void setCluster(CatalinaCluster cluster) {
        this.cluster = cluster;
    }

    protected void handleJvmRoute(Request request, Response response, String sessionId, String localJvmRoute) {
        String requestJvmRoute = null;
        int index = sessionId.indexOf(".");
        if (index > 0) {
            requestJvmRoute = sessionId.substring(index + 1, sessionId.length());
        }
        if (requestJvmRoute != null && !requestJvmRoute.equals(localJvmRoute)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)this.sm.getString("jvmRoute.failover", (Object)requestJvmRoute, (Object)localJvmRoute, (Object)sessionId));
            }
            String newSessionID = sessionId.substring(0, index) + "." + localJvmRoute;
            Session catalinaSession = null;
            try {
                catalinaSession = this.getManager(request).findSession(sessionId);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (catalinaSession != null) {
                this.changeSessionID(request, response, sessionId, newSessionID, catalinaSession);
                ++this.numberOfSessions;
            } else if (log.isDebugEnabled()) {
                log.debug((Object)this.sm.getString("jvmRoute.cannotFindSession", (Object)sessionId));
            }
        }
    }

    protected void changeSessionID(Request request, Response response, String sessionId, String newSessionID, Session catalinaSession) {
        this.lifecycle.fireLifecycleEvent("Before session migration", (Object)catalinaSession);
        request.setRequestedSessionId(newSessionID);
        catalinaSession.setId(newSessionID);
        if (catalinaSession instanceof DeltaSession) {
            ((DeltaSession)catalinaSession).resetDeltaRequest();
        }
        if (request.isRequestedSessionIdFromCookie()) {
            this.setNewSessionCookie(request, response, newSessionID);
        }
        if (this.sessionIdAttribute != null && !"".equals(this.sessionIdAttribute)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)this.sm.getString("jvmRoute.set.orignalsessionid", (Object)this.sessionIdAttribute, (Object)sessionId));
            }
            request.setAttribute(this.sessionIdAttribute, (Object)sessionId);
        }
        ClusterManager manager = (ClusterManager)catalinaSession.getManager();
        this.sendSessionIDClusterBackup(manager, request, sessionId, newSessionID);
        this.lifecycle.fireLifecycleEvent("After session migration", (Object)catalinaSession);
        if (log.isDebugEnabled()) {
            log.debug((Object)this.sm.getString("jvmRoute.changeSession", (Object)sessionId, (Object)newSessionID));
        }
    }

    protected void sendSessionIDClusterBackup(ClusterManager manager, Request request, String sessionId, String newSessionID) {
        SessionIDMessage msg = new SessionIDMessage();
        msg.setOrignalSessionID(sessionId);
        msg.setBackupSessionID(newSessionID);
        Context context = request.getContext();
        msg.setContextPath(context.getPath());
        msg.setHost(context.getParent().getName());
        if (manager.isSendClusterDomainOnly()) {
            this.cluster.sendClusterDomain(msg);
        } else {
            this.cluster.send(msg);
        }
    }

    protected void setNewSessionCookie(Request request, Response response, String sessionId) {
        Context context;
        if (response != null && (context = request.getContext()).getCookies()) {
            Cookie newCookie = new Cookie("JSESSIONID", sessionId);
            newCookie.setMaxAge(-1);
            String contextPath = null;
            if (!response.getConnector().getEmptySessionPath() && context != null) {
                contextPath = context.getEncodedPath();
            }
            if (contextPath != null && contextPath.length() > 0) {
                newCookie.setPath(contextPath);
            } else {
                newCookie.setPath("/");
            }
            if (request.isSecure()) {
                newCookie.setSecure(true);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)this.sm.getString("jvmRoute.newSessionCookie", (Object)sessionId, (Object)"JSESSIONID", (Object)newCookie.getPath(), (Object)new Boolean(newCookie.getSecure())));
            }
            response.addCookie(newCookie);
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("jvmRoute.valve.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.cluster == null) {
            Container hostContainer = this.getContainer();
            if (!(hostContainer instanceof Host)) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)this.sm.getString("jvmRoute.configure.warn"));
                }
                hostContainer = hostContainer.getParent();
            }
            if (hostContainer instanceof Host && ((Host)hostContainer).getCluster() != null) {
                this.cluster = (CatalinaCluster)((Host)hostContainer).getCluster();
            } else {
                Container engine = hostContainer.getParent();
                if (engine instanceof Engine && ((Engine)engine).getCluster() != null) {
                    this.cluster = (CatalinaCluster)((Engine)engine).getCluster();
                }
            }
        }
        if (this.cluster == null) {
            throw new RuntimeException("No clustering support at container " + this.container.getName());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)this.sm.getString("jvmRoute.valve.started"));
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("jvmRoute.valve.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.cluster = null;
        this.numberOfSessions = 0L;
        if (log.isInfoEnabled()) {
            log.info((Object)this.sm.getString("jvmRoute.valve.stopped"));
        }
    }
}

