/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.catalina.cluster.tcp.ClusterReceiverBase;
import org.apache.catalina.cluster.tcp.SocketReplicationThread;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SocketReplicationListener
extends ClusterReceiverBase {
    private static Log log = LogFactory.getLog(SocketReplicationListener.class);
    protected static StringManager sm = StringManager.getManager((String)"org.apache.catalina.cluster.tcp");
    private static final String info = "SocketReplicationListener/1.3";
    private ServerSocket serverSocket = null;
    private int tcpListenMaxPort;
    private int tcpListenTimeout = 1;

    public String getInfo() {
        return info;
    }

    public int getTcpListenMaxPort() {
        return this.tcpListenMaxPort;
    }

    public void setTcpListenMaxPort(int maxListenPort) {
        this.tcpListenMaxPort = maxListenPort;
    }

    public int getTcpListenTimeout() {
        return this.tcpListenTimeout;
    }

    public void setTcpListenTimeout(int tcpListenTimeout) {
        this.tcpListenTimeout = tcpListenTimeout;
    }

    public void start() {
        super.start();
        long reqStart = System.currentTimeMillis();
        long reqNow = 0L;
        boolean isTimeout = false;
        do {
            try {
                Thread.sleep(50L);
            }
            catch (Exception sleep) {
                // empty catch block
            }
            reqNow = System.currentTimeMillis();
            boolean bl = isTimeout = reqNow - reqStart > (long)(1000 * this.getTcpListenTimeout());
        } while (!this.doListen && !isTimeout);
        if (isTimeout || !this.doListen) {
            log.error((Object)sm.getString("SocketReplictionListener.timeout", (Object)this.getTcpListenAddress(), (Object)Integer.toString(this.getTcpListenPort()), (Object)Long.toString(reqNow - reqStart), (Object)Boolean.toString(this.doListen)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void listen() {
        if (this.doListen) {
            log.warn((Object)sm.getString("SocketReplictionListener.allreadyExists", (Object)this.getTcpListenAddress(), (Object)Integer.toString(this.getTcpListenPort())));
            return;
        }
        try {
            this.serverSocket = this.createServerSocket();
            if (this.serverSocket != null) {
                this.doListen = true;
                while (this.doListen) {
                    try {
                        Socket socket = this.serverSocket.accept();
                        if (!this.doListen || socket == null) continue;
                        socket.setReceiveBufferSize(this.getRxBufSize());
                        socket.setSendBufferSize(this.getTxBufSize());
                        socket.setTcpNoDelay(this.isTcpNoDelay());
                        socket.setKeepAlive(this.isSoKeepAlive());
                        socket.setOOBInline(this.isOoBInline());
                        socket.setReuseAddress(this.isSoReuseAddress());
                        socket.setSoLinger(this.isSoLingerOn(), this.getSoLingerTime());
                        socket.setTrafficClass(this.getSoTrafficClass());
                        if (this.getTimeout() > -1) {
                            socket.setSoTimeout(this.getTimeout());
                        }
                        SocketReplicationThread t = new SocketReplicationThread(this, socket);
                        t.setDaemon(true);
                        t.start();
                    }
                    catch (IOException iex) {
                        log.warn((Object)sm.getString("SocketReplictionListener.accept.failure", (Object)this.getTcpListenAddress(), (Object)Integer.toString(this.getTcpListenPort())), (Throwable)iex);
                    }
                }
                this.serverSocket.close();
            } else {
                log.fatal((Object)sm.getString("SocketReplictionListener.serverSocket.notExists", (Object)this.getTcpListenAddress(), (Object)Integer.toString(this.getTcpListenPort()), (Object)Integer.toString(this.getTcpListenMaxPort())));
            }
        }
        catch (IOException iex) {
            log.warn((Object)sm.getString("SocketReplictionListener.openclose.failure", (Object)this.getTcpListenAddress(), (Object)Integer.toString(this.getTcpListenPort())), (Throwable)iex);
        }
        finally {
            this.doListen = false;
            this.serverSocket = null;
        }
    }

    protected ServerSocket createServerSocket() {
        int startPort = this.getTcpListenPort();
        int maxPort = this.getTcpListenMaxPort();
        InetAddress inet = this.getBind();
        ServerSocket sSocket = null;
        if (maxPort < startPort) {
            maxPort = startPort;
        }
        for (int i = startPort; i <= maxPort; ++i) {
            try {
                sSocket = inet == null ? new ServerSocket(i, 0) : new ServerSocket(i, 0, inet);
                this.setTcpListenPort(i);
                break;
            }
            catch (IOException ex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("SocketReplictionListener.portbusy", (Object)inet.getHostAddress(), (Object)Integer.toString(i), (Object)ex.toString()));
                }
                try {
                    Thread.sleep(25L);
                }
                catch (InterruptedException ti) {
                    // empty catch block
                }
                continue;
            }
        }
        if (sSocket != null && log.isInfoEnabled()) {
            log.info((Object)sm.getString("SocketReplictionListener.open", (Object)inet.getHostAddress(), (Object)Integer.toString(this.getTcpListenPort())));
        }
        return sSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unLockSocket() {
        Socket s = null;
        InetAddress ladr = this.getBind();
        try {
            if (ladr == null || "0.0.0.0".equals(ladr.getHostAddress())) {
                ladr = InetAddress.getLocalHost();
            }
            s = new Socket(ladr, this.getTcpListenPort());
            s.setSoLinger(true, 0);
        }
        catch (IOException iex) {
            log.warn((Object)sm.getString("SocketReplictionListener.unlockSocket.failure", (Object)this.getTcpListenAddress(), (Object)Integer.toString(this.getTcpListenPort())), (Throwable)iex);
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected void stopListening() {
        this.unLockSocket();
        this.doListen = false;
    }
}

