/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.catalina.valve;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.tomcat.util.buf.MessageBytes;

public class AVMRequestDumperValve
extends ValveBase {
    private static final String info = "org.alfresco.catalina.valve.AVMRequestDumperValve/1.0";
    protected static StringManager sm = StringManager.getManager((String)"org.apache.catalina.valves");

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        Log log = this.container.getLogger();
        System.out.println("REQUEST URI       =" + request.getRequestURI());
        System.out.println("          authType=" + request.getAuthType());
        System.out.println(" characterEncoding=" + request.getCharacterEncoding());
        System.out.println("     contentLength=" + request.getContentLength());
        System.out.println("       contentType=" + request.getContentType());
        System.out.println("       contextPath=" + request.getContextPath());
        MessageBytes urlMB_req_path = request.getRequestPathMB();
        MessageBytes urlMB_req_path_decoded = request.getDecodedRequestURIMB();
        if (request.getContextPath() != null) {
            urlMB_req_path.toChars();
            urlMB_req_path_decoded.toChars();
            System.out.println("       RequestPath=" + urlMB_req_path.getCharChunk().toString());
            System.out.println("    decoded ReqPath=" + urlMB_req_path_decoded.getCharChunk().toString());
        } else {
            System.out.println("       WARNING: Context is NULL so can't fetch RequestPath or decoded ReqPath");
        }
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                System.out.println("            cookie=" + cookies[i].getName() + "=" + cookies[i].getValue());
            }
        }
        Enumeration hnames = request.getHeaderNames();
        while (hnames.hasMoreElements()) {
            String hname = (String)hnames.nextElement();
            Enumeration hvalues = request.getHeaders(hname);
            while (hvalues.hasMoreElements()) {
                String hvalue = (String)hvalues.nextElement();
                System.out.println("            header=" + hname + "=" + hvalue);
            }
        }
        System.out.println("            locale=" + request.getLocale());
        System.out.println("            method=" + request.getMethod());
        Enumeration pnames = request.getParameterNames();
        while (pnames.hasMoreElements()) {
            String pname = (String)pnames.nextElement();
            String[] pvalues = request.getParameterValues(pname);
            StringBuffer result = new StringBuffer(pname);
            result.append('=');
            for (int i = 0; i < pvalues.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(pvalues[i]);
            }
            System.out.println("         parameter=" + result.toString());
        }
        System.out.println("          pathInfo=" + request.getPathInfo());
        System.out.println("          protocol=" + request.getProtocol());
        System.out.println("       queryString=" + request.getQueryString());
        System.out.println("        remoteAddr=" + request.getRemoteAddr());
        System.out.println("        remoteHost=" + request.getRemoteHost());
        System.out.println("        remoteUser=" + request.getRemoteUser());
        System.out.println("requestedSessionId=" + request.getRequestedSessionId());
        System.out.println("            scheme=" + request.getScheme());
        System.out.println("        serverName=" + request.getServerName());
        System.out.println("        serverPort=" + request.getServerPort());
        System.out.println("       servletPath=" + request.getServletPath());
        System.out.println("          isSecure=" + request.isSecure());
        System.out.println("---------------------------------------------------------------");
        this.getNext().invoke(request, response);
        System.out.println("---------------------------------------------------------------");
        System.out.println("Post service info:");
        System.out.println("          authType=" + request.getAuthType());
        System.out.println("     contentLength=" + response.getContentLength());
        System.out.println("       contentType=" + response.getContentType());
        Cookie[] rcookies = response.getCookies();
        for (int i = 0; i < rcookies.length; ++i) {
            System.out.println("            cookie=" + rcookies[i].getName() + "=" + rcookies[i].getValue() + "; domain=" + rcookies[i].getDomain() + "; path=" + rcookies[i].getPath());
        }
        String[] rhnames = response.getHeaderNames();
        for (int i = 0; i < rhnames.length; ++i) {
            String[] rhvalues = response.getHeaderValues(rhnames[i]);
            for (int j = 0; j < rhvalues.length; ++j) {
                System.out.println("            header=" + rhnames[i] + "=" + rhvalues[j]);
            }
        }
        System.out.println("           message=" + response.getMessage());
        System.out.println("        remoteUser=" + request.getRemoteUser());
        System.out.println("            status=" + response.getStatus());
        System.out.println("===============================================================");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RequestDumperValve[");
        if (this.container != null) {
            sb.append(this.container.getName());
        }
        sb.append("]");
        return sb.toString();
    }
}

