/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mbeans;

import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.alfresco.catalina.host.AVMHost;
import org.alfresco.jndi.AVMFileDirContext;
import org.alfresco.mbeans.VirtServerInfoMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class VirtServerRegistrationThread
extends Thread {
    private static Log log = LogFactory.getLog(VirtServerRegistrationThread.class);
    ApplicationContext springContext_;
    JMXServiceURL url_;
    Map<String, Object> env_;
    String virt_url_;
    String virt_domain_;
    String virt_fqdn_;
    int virt_http_port_;
    int virt_connect_retry_interval_;
    ObjectName virt_registry_;
    Attribute virt_server_attrib_;
    boolean done_ = false;
    JMXConnector conn_;
    ServerStatus alfrescoStatus = ServerStatus.AVAILABLE;

    public VirtServerRegistrationThread() {
        String mount_path;
        this.springContext_ = AVMHost.GetSpringApplicationContext();
        VirtServerInfoMBean serverInfo = (VirtServerInfoMBean)this.springContext_.getBean("virtServerInfo");
        String os_name = System.getProperty("os.name");
        serverInfo.setVirtServerOsName(os_name);
        if (os_name.startsWith("Windows")) {
            mount_path = serverInfo.getVirtServerCifsAvmVersionTreeWin();
            if (mount_path == null) {
                mount_path = "c:\\alfresco_no_cifs\\";
            } else if (mount_path.length() == 1) {
                mount_path = mount_path + ":\\";
            } else if (mount_path.length() == 2 && mount_path.charAt(1) == ':') {
                mount_path = mount_path + "\\";
            }
        } else {
            mount_path = serverInfo.getVirtServerCifsAvmVersionTreeUnix();
            if (mount_path == null) {
                mount_path = "/alfresco_no_cifs/";
            }
        }
        AVMFileDirContext.setAVMFileDirMountPoint((String)mount_path);
        String catalina_base = System.getProperty("catalina.base");
        if (catalina_base == null) {
            catalina_base = System.getProperty("catalina.home");
        }
        if (catalina_base != null) {
            if (!catalina_base.endsWith("/")) {
                catalina_base = catalina_base + "/";
            }
        } else {
            catalina_base = "";
        }
        String password_file = catalina_base + "conf/alfresco-jmxrmi.password";
        Properties passwordProps = new Properties();
        String jmxrmi_password = null;
        try {
            passwordProps.load(new FileInputStream(password_file));
            jmxrmi_password = passwordProps.getProperty("controlRole");
            this.virt_connect_retry_interval_ = serverInfo.getVirtServerConnectionRetryInterval();
            String avm_jmx_url = "service:jmx:rmi://ignored/jndi/rmi://" + serverInfo.getAlfrescoJmxRmiHost() + ":" + serverInfo.getAlfrescoJmxRmiPort() + "/alfresco/jmxrmi";
            this.url_ = new JMXServiceURL(avm_jmx_url);
            if (log.isInfoEnabled()) {
                log.info((Object)("Remote Alfresco JMX Server url_ is " + avm_jmx_url));
            }
            this.env_ = new HashMap<String, Object>();
            String[] cred = new String[]{"controlRole", jmxrmi_password};
            this.env_.put("jmx.remote.credentials", cred);
            this.virt_registry_ = ObjectName.getInstance("Alfresco:Name=VirtServerRegistry,Type=VirtServerRegistry");
            this.virt_fqdn_ = this.virt_domain_ = serverInfo.getVirtServerDomain();
            this.virt_http_port_ = serverInfo.getVirtServerHttpPort();
            this.virt_url_ = "service:jmx:rmi://ignored/jndi/rmi://" + this.virt_fqdn_ + ":" + serverInfo.getVirtServerJmxRmiPort() + "/alfresco/jmxrmi";
            this.virt_server_attrib_ = new Attribute("VirtServerJmxUrl", this.virt_url_);
        }
        catch (Exception e) {
            log.error((Object)"Could not find password file for remote Alfresco JMX Server", (Throwable)e);
        }
    }

    public void run() {
        while (!this.getDone()) {
            this.registerVirtServer();
            try {
                Thread.sleep(this.virt_connect_retry_interval_);
            }
            catch (Exception e) {}
        }
        JMXConnectorCloseThread conn_close = new JMXConnectorCloseThread(this.conn_);
        conn_close.start();
        this.conn_ = null;
    }

    private void registerVirtServer() {
        try {
            if (this.conn_ == null) {
                this.conn_ = JMXConnectorFactory.connect(this.url_, this.env_);
                if (log.isInfoEnabled()) {
                    log.info((Object)"Connected to remote Alfresco JMX Server");
                }
            }
            MBeanServerConnection mbsc = this.conn_.getMBeanServerConnection();
            mbsc.invoke(this.virt_registry_, "registerVirtServerInfo", new Object[]{this.virt_url_, this.virt_fqdn_, new Integer(this.virt_http_port_)}, new String[]{"java.lang.String", "java.lang.String", "java.lang.Integer"});
            this.alfrescoStatus = ServerStatus.AVAILABLE;
        }
        catch (Exception e) {
            if (this.alfrescoStatus == ServerStatus.AVAILABLE) {
                this.alfrescoStatus = ServerStatus.NOT_AVAILABLE;
                log.error((Object)("Connection failure to remote Alfresco JMX Server: " + this.url_ + e.getMessage()));
            }
            JMXConnectorCloseThread conn_close = new JMXConnectorCloseThread(this.conn_);
            conn_close.start();
            this.conn_ = null;
        }
    }

    public void setDone() {
        this.done_ = true;
    }

    public boolean getDone() {
        return this.done_;
    }

    protected class JMXConnectorCloseThread
    extends Thread {
        JMXConnector connection_;

        public JMXConnectorCloseThread(JMXConnector connection) {
            this.connection_ = connection;
        }

        public void run() {
            if (this.connection_ != null) {
                try {
                    this.connection_.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ServerStatus {
        NOT_AVAILABLE,
        AVAILABLE;

    }
}

