/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.res.StringManager;

public class AjpMessage {
    protected static Log log = LogFactory.getLog(AjpMessage.class);
    protected static StringManager sm = StringManager.getManager((String)"org.apache.coyote.ajp");
    protected byte[] buf = null;
    protected int pos;
    protected int len;

    public AjpMessage(int packetSize) {
        this.buf = new byte[packetSize];
    }

    public void reset() {
        this.len = 4;
        this.pos = 4;
    }

    public void end() {
        this.len = this.pos;
        int dLen = this.len - 4;
        this.buf[0] = 65;
        this.buf[1] = 66;
        this.buf[2] = (byte)(dLen >>> 8 & 0xFF);
        this.buf[3] = (byte)(dLen & 0xFF);
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int getLen() {
        return this.len;
    }

    public void appendInt(int val) {
        this.buf[this.pos++] = (byte)(val >>> 8 & 0xFF);
        this.buf[this.pos++] = (byte)(val & 0xFF);
    }

    public void appendByte(int val) {
        this.buf[this.pos++] = (byte)val;
    }

    public void appendLongInt(int val) {
        this.buf[this.pos++] = (byte)(val >>> 24 & 0xFF);
        this.buf[this.pos++] = (byte)(val >>> 16 & 0xFF);
        this.buf[this.pos++] = (byte)(val >>> 8 & 0xFF);
        this.buf[this.pos++] = (byte)(val & 0xFF);
    }

    public void appendBytes(MessageBytes mb) {
        if (mb == null) {
            log.error((Object)sm.getString("ajpmessage.null"), (Throwable)new NullPointerException());
            this.appendInt(0);
            this.appendByte(0);
            return;
        }
        if (mb.getType() == 2) {
            ByteChunk bc = mb.getByteChunk();
            this.appendByteChunk(bc);
        } else if (mb.getType() == 3) {
            CharChunk cc = mb.getCharChunk();
            this.appendCharChunk(cc);
        } else {
            this.appendString(mb.toString());
        }
    }

    public void appendByteChunk(ByteChunk bc) {
        if (bc == null) {
            log.error((Object)sm.getString("ajpmessage.null"), (Throwable)new NullPointerException());
            this.appendInt(0);
            this.appendByte(0);
            return;
        }
        this.appendBytes(bc.getBytes(), bc.getStart(), bc.getLength());
    }

    public void appendCharChunk(CharChunk cc) {
        if (cc == null) {
            log.error((Object)sm.getString("ajpmessage.null"), (Throwable)new NullPointerException());
            this.appendInt(0);
            this.appendByte(0);
            return;
        }
        int start = cc.getStart();
        int end = cc.getEnd();
        this.appendInt(end - start);
        char[] cbuf = cc.getBuffer();
        for (int i = start; i < end; ++i) {
            int c = cbuf[i];
            if (c <= 31 && c != 9) {
                c = 32;
            } else if (c == 127) {
                c = 32;
            }
            this.appendByte(c);
        }
        this.appendByte(0);
    }

    public void appendString(String str) {
        if (str == null) {
            log.error((Object)sm.getString("ajpmessage.null"), (Throwable)new NullPointerException());
            this.appendInt(0);
            this.appendByte(0);
            return;
        }
        int len = str.length();
        this.appendInt(len);
        for (int i = 0; i < len; ++i) {
            int c = str.charAt(i);
            if (c <= 31 && c != 9) {
                c = 32;
            } else if (c == 127) {
                c = 32;
            }
            this.appendByte(c);
        }
        this.appendByte(0);
    }

    public void appendBytes(byte[] b, int off, int numBytes) {
        if (this.pos + numBytes + 3 >= this.buf.length) {
            log.error((Object)sm.getString("ajpmessage.overflow", (Object)("" + numBytes), (Object)("" + this.pos)), (Throwable)new ArrayIndexOutOfBoundsException());
            if (log.isDebugEnabled()) {
                this.dump("Overflow/coBytes");
            }
            return;
        }
        this.appendInt(numBytes);
        System.arraycopy(b, off, this.buf, this.pos, numBytes);
        this.pos += numBytes;
        this.appendByte(0);
    }

    public int getInt() {
        int b1 = this.buf[this.pos++] & 0xFF;
        int b2 = this.buf[this.pos++] & 0xFF;
        return (b1 << 8) + b2;
    }

    public int peekInt() {
        int b1 = this.buf[this.pos] & 0xFF;
        int b2 = this.buf[this.pos + 1] & 0xFF;
        return (b1 << 8) + b2;
    }

    public byte getByte() {
        byte res = this.buf[this.pos++];
        return res;
    }

    public byte peekByte() {
        byte res = this.buf[this.pos];
        return res;
    }

    public void getBytes(MessageBytes mb) {
        int length = this.getInt();
        if (length == 65535 || length == -1) {
            mb.recycle();
            return;
        }
        mb.setBytes(this.buf, this.pos, length);
        this.pos += length;
        ++this.pos;
    }

    public int getBytes(byte[] dest) {
        int length = this.getInt();
        if (this.pos + length > this.buf.length) {
            log.error((Object)sm.getString("ajpmessage.read", (Object)("" + length)));
            return 0;
        }
        if (length == 65535 || length == -1) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, dest, 0, length);
        this.pos += length;
        ++this.pos;
        return length;
    }

    public int getLongInt() {
        int b1 = this.buf[this.pos++] & 0xFF;
        b1 <<= 8;
        b1 |= this.buf[this.pos++] & 0xFF;
        b1 <<= 8;
        b1 |= this.buf[this.pos++] & 0xFF;
        b1 <<= 8;
        return b1 |= this.buf[this.pos++] & 0xFF;
    }

    public int getHeaderLength() {
        return 4;
    }

    public int processHeader() {
        this.pos = 0;
        int mark = this.getInt();
        this.len = this.getInt();
        if (mark != 4660 && mark != 16706) {
            log.error((Object)sm.getString("ajpmessage.invalid", (Object)("" + mark)));
            if (log.isDebugEnabled()) {
                this.dump("In: ");
            }
            return -1;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received " + this.len + " " + this.buf[0]));
        }
        return this.len;
    }

    public void dump(String msg) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(msg + ": " + this.buf + " " + this.pos + "/" + (this.len + 4)));
        }
        int max = this.pos;
        if (this.len + 4 > this.pos) {
            max = this.len + 4;
        }
        if (max > 1000) {
            max = 1000;
        }
        if (log.isDebugEnabled()) {
            for (int j = 0; j < max; j += 16) {
                log.debug((Object)AjpMessage.hexLine(this.buf, j, this.len));
            }
        }
    }

    protected static String hexLine(byte[] buf, int start, int len) {
        int i;
        StringBuffer sb = new StringBuffer();
        for (i = start; i < start + 16; ++i) {
            if (i < len + 4) {
                sb.append(AjpMessage.hex(buf[i]) + " ");
                continue;
            }
            sb.append("   ");
        }
        sb.append(" | ");
        for (i = start; i < start + 16 && i < len + 4; ++i) {
            if (!Character.isISOControl((char)buf[i])) {
                sb.append(new Character((char)buf[i]));
                continue;
            }
            sb.append(".");
        }
        return sb.toString();
    }

    protected static String hex(int x) {
        String h = Integer.toHexString(x);
        if (h.length() == 1) {
            h = "0" + h;
        }
        return h.substring(h.length() - 2);
    }
}

