/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.ssi.ByteArrayServletOutputStream;
import org.apache.catalina.ssi.ResponseIncludeWrapper;
import org.apache.catalina.ssi.SSIProcessor;
import org.apache.catalina.ssi.SSIServletExternalResolver;

public class SSIFilter
implements Filter {
    protected FilterConfig config = null;
    protected int debug = 0;
    protected Long expires = null;
    protected boolean isVirtualWebappRelative = false;
    protected Pattern contentTypeRegEx = null;
    protected Pattern shtmlRegEx = Pattern.compile("text/x-server-parsed-html(;.*)?");

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
        String value = null;
        try {
            value = config.getInitParameter("debug");
            this.debug = Integer.parseInt(value);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            value = config.getInitParameter("contentType");
            this.contentTypeRegEx = Pattern.compile(value);
        }
        catch (Throwable t) {
            this.contentTypeRegEx = this.shtmlRegEx;
            StringBuffer msg = new StringBuffer();
            msg.append("Invalid format or no contentType initParam; ");
            msg.append("expected regular expression; defaulting to ");
            msg.append(this.shtmlRegEx.pattern());
            config.getServletContext().log(msg.toString());
        }
        try {
            value = config.getInitParameter("isVirtualWebappRelative");
            this.isVirtualWebappRelative = Integer.parseInt(value) > 0;
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            value = config.getInitParameter("expires");
            this.expires = Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            this.expires = null;
            config.getServletContext().log("Invalid format for expires initParam; expected integer (seconds)");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.debug > 0) {
            config.getServletContext().log("SSIFilter.init() SSI invoker started with 'debug'=" + this.debug);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        req.setAttribute("org.apache.catalina.ssi.SSIServlet", (Object)"true");
        ByteArrayServletOutputStream basos = new ByteArrayServletOutputStream();
        ResponseIncludeWrapper responseIncludeWrapper = new ResponseIncludeWrapper(this.config.getServletContext(), req, res, basos);
        chain.doFilter((ServletRequest)req, (ServletResponse)responseIncludeWrapper);
        responseIncludeWrapper.flushOutputStreamOrWriter();
        byte[] bytes = basos.toByteArray();
        String contentType = responseIncludeWrapper.getContentType();
        if (this.contentTypeRegEx.matcher(contentType).matches()) {
            String encoding = res.getCharacterEncoding();
            SSIServletExternalResolver ssiExternalResolver = new SSIServletExternalResolver(this.config.getServletContext(), req, res, this.isVirtualWebappRelative, this.debug, encoding);
            SSIProcessor ssiProcessor = new SSIProcessor(ssiExternalResolver, this.debug);
            InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), encoding);
            ByteArrayOutputStream ssiout = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)ssiout, encoding));
            long lastModified = ssiProcessor.process(reader, responseIncludeWrapper.getLastModified(), writer);
            writer.flush();
            bytes = ssiout.toByteArray();
            if (this.expires != null) {
                res.setDateHeader("expires", new Date().getTime() + this.expires * 1000L);
            }
            if (lastModified > 0L) {
                res.setDateHeader("last-modified", lastModified);
            }
            res.setContentLength(bytes.length);
            Matcher shtmlMatcher = this.shtmlRegEx.matcher(responseIncludeWrapper.getContentType());
            if (shtmlMatcher.matches()) {
                String enc = shtmlMatcher.group(1);
                res.setContentType("text/html" + (enc != null ? enc : ""));
            }
        }
        try {
            ServletOutputStream out = res.getOutputStream();
            out.write(bytes);
        }
        catch (Throwable t) {
            PrintWriter out = res.getWriter();
            ((Writer)out).write(new String(bytes));
        }
    }

    public void destroy() {
    }
}

