/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.status;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.catalina.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jk.status.JkStatus;
import org.apache.jk.status.JkStatusParser;
import org.apache.tomcat.util.digester.Digester;

public class JkStatusAccessor {
    private static Log log = LogFactory.getLog(JkStatusAccessor.class);
    protected static final String info = "org.apache.jk.status.JkStatusAccessor/1.0";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JkStatus status(String url, String username, String password) throws Exception {
        if (url == null || "".equals(url)) {
            return null;
        }
        HttpURLConnection hconn = null;
        JkStatus status = null;
        try {
            Digester digester;
            hconn = this.openConnection(url + "?cmd=list&mime=xml", username, password);
            Digester digester2 = digester = JkStatusParser.getDigester();
            synchronized (digester2) {
                status = (JkStatus)digester.parse(hconn.getInputStream());
            }
        }
        catch (Throwable t) {
            throw new Exception(t);
        }
        finally {
            if (hconn != null) {
                try {
                    hconn.disconnect();
                }
                catch (Throwable u) {}
                hconn = null;
            }
        }
        return status;
    }

    protected HttpURLConnection openConnection(String url, String username, String password) throws IOException, MalformedURLException, ProtocolException {
        URLConnection conn = new URL(url).openConnection();
        HttpURLConnection hconn = (HttpURLConnection)conn;
        hconn.setAllowUserInteraction(false);
        hconn.setDoInput(true);
        hconn.setUseCaches(false);
        hconn.setDoOutput(false);
        hconn.setRequestMethod("GET");
        hconn.setRequestProperty("User-Agent", "JkStatus-Client/1.0");
        if (username != null && password != null) {
            this.setAuthHeader(hconn, username, password);
        }
        hconn.connect();
        return hconn;
    }

    protected void setAuthHeader(HttpURLConnection hconn, String username, String password) {
        String input = username + ":" + password;
        String output = new String(Base64.encode((byte[])input.getBytes()));
        hconn.setRequestProperty("Authorization", "Basic " + output);
    }
}

