<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:xhtml="http://www.w3.org/1999/xhtml"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		exclude-result-prefixes="xhtml">

    <xsl:output method="html" version="4.01" encoding="UTF-8" indent="yes"
                doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
                doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
    <xsl:preserve-space elements="*"/>

    <xsl:template match="/">
      <html>
	<head>
	  <style type="text/css">
body
{
  font-family: Tahoma, Arial, Helvetica, sans-serif;
  background-color: white;
  font-size: 11px;
}

.name 
{
  color: #003366;
  font-weight: bold;
  margin-right: 10px;
  margin-top: 10px;
}
	  </style>
	  <title>Simple Test</title>
	</head>
	<body id="mybody">
	  <div>Generated by output-method-callout.xsl</div>
	  
	  <div class="name">
	    &lt;xsl:value-of select="$alf:avm_sandbox_url"/&gt;
	  </div>
	  <span><xsl:value-of select="$alf:avm_sandbox_url"/></span>

	  <div class="name">
	    &lt;xsl:value-of select="$alf:form_instance_data_file_name"/&gt;
	  </div>
	  <span><xsl:value-of select="$alf:form_instance_data_file_name"/></span>

	  <div class="name">
	    &lt;xsl:value-of select="$alf:rendition_file_name"/&gt;
	  </div>
	  <span><xsl:value-of select="$alf:rendition_file_name"/></span>

	  <div class="name">
	    &lt;xsl:value-of select="$alf:parent_path"/&gt;
	  </div>
	  <span><xsl:value-of select="$alf:parent_path"/></span>

	  <div class="name">
	    &lt;xsl:value-of select="$alf:request_context_path"/&gt;
	  </div>
	  <span><xsl:value-of select="$alf:request_context_path"/></span>

	  <div class="name">
	    &lt;xsl:value-of select="$alf:request_context_path"/&gt;&lt;xsl:value-of select="/simple/uri"/&gt;
	  </div>
	  <span><xsl:value-of select="$alf:request_context_path"/><xsl:value-of select="/simple/uri"/></span>

	  <div class="name">
	    &lt;xsl:value-of select="alf:_getAVMPath('foo')"/&gt;
	  </div>
	  <span><xsl:value-of select="alf:_getAVMPath('foo')"/></span>

	  <div class="name">
	    &lt;xsl:value-of select="alf:_getAVMPath('/foo')"/&gt;
	  </div>
	  <span><xsl:value-of select="alf:_getAVMPath('/foo')"/></span>

	  <div class="name">My value accessed using /simple/string:</div>	
          <span><xsl:value-of select="/simple/string"/></span>

	  <div class="name">My value accessed using alf:parseXMLDocument($alf:form_instance_data_file_name):</div>
	  <span><xsl:value-of select="alf:parseXMLDocument($alf:form_instance_data_file_name)/string"/></span>

	  <div class="name">My value accessed using document(concat('/', $alf:form_instance_data_file_name)):</div>
	  <span><xsl:value-of select="document(concat('/', $alf:form_instance_data_file_name))/simple/string"/></span>

          <div class="name">Values from xml files generated by in <xsl:value-of select="$alf:parent_path"/>:</div>
	  <ul>
	  <xsl:for-each select="alf:parseXMLDocuments('form-data-functions-test')">
	    <li>
	      <div class="name">
		&lt;xsl:value-of select="@alf:file_name"/&gt; = &lt;xsl:value-of select="string"/&gt;
	      </div>
	      <span>
		<xsl:value-of select="@alf:file_name"/> = <xsl:value-of select="string"/>
	      </span>
	    </li>
	  </xsl:for-each>
          </ul>
        </body>
      </html>
    </xsl:template>
</xsl:stylesheet>
